<?php $__env->startSection('main'); ?>
<style type="text/css">
	.tooltip-custom {
		display: inline-block;
		position: relative;
		vertical-align: middle;
		line-height: 16px;
		margin: -5px 0 -3px;
		padding: 4px 0;
	}
	.tooltip-custom .icon {
		background: url("../images/seller_settings.png") no-repeat;
		background-size: 120px 200px;
	}
	.tooltip-custom .icon {
		display: block;
		width: 14px;
		height: 14px;
		background-position: -95px -150px !important;
		opacity: 0.4;
	}
	.tooltip-custom em {
		font-weight: normal;
		font-size: 12px;
		padding: 2px 10px 10px;
		width: 200px;
		white-space: normal;
		line-height: 16px;
		top: 22px;
		text-align: left;
		margin-left: -100px !important;
		left: 50%;
		background: #2c3239;
		border-radius: 2px;
		color: #fff;
		font-style: normal;
		position: absolute;
		display: none;
		z-index: 1;
	}
	.tooltip-custom em::after{
		-moz-border-bottom-colors: none;
		-moz-border-left-colors: none;
		-moz-border-right-colors: none;
		-moz-border-top-colors: none;
		border-color: #2c3239 transparent transparent;
		border-image: none;
		border-style: solid;
		border-width: 3px;
		top: -6px;
		content: "";
		left: 50%;
		margin-left: -3px;
		position: absolute;
		transform: rotate(180deg);
	}
	.tooltip-custom:hover em {
		display: block !important;
	}
	.box-body
	{
		padding: 0;
	}
</style>
<div class="content-wrapper">
	<section class="content-header">
		<h1> Payment Gateway </h1>
		<ol class="breadcrumb">
			<li>
				<a href="<?php echo e(url(LOGIN_USER_TYPE.'/dashboard')); ?>"> <i class="fa fa-dashboard"></i> Home </a>
			</li>
			<li>
				<a href="<?php echo e(url(LOGIN_USER_TYPE.'/payment_gateway')); ?>"> Payment Gateway </a>
			</li>
			<li class="active"> Edit </li>
		</ol>
	</section>
	<section class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="box box-info">
					<div class="box-header with-border">
						<h3 class="box-title"> Payment Gateway Form </h3>
					</div>
					<?php echo Form::open(['url' => 'admin/payment_gateway', 'class' => 'form-horizontal']); ?>

					<div class="box-body">
						<span class="text-danger">(*)Fields are Mandatory</span>
						<!-- Paypal Section Start -->
						<div class="box-body">
							<div class="form-group" ng-init="paypal_enabled=<?php echo e(old('paypal_enabled',payment_gateway('is_enabled','Paypal'))); ?>">
								<label for="input_paypal_enabled" class="col-sm-3 control-label">Is Paypal Enabled <em class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('paypal_enabled', array('0' => 'No', '1' => 'Yes'), '', ['class' => 'form-control', 'id' => 'input_paypal_enabled', 'ng-model' => 'paypal_enabled']); ?>

									<span class="text-danger"><?php echo e($errors->first('paypal_enabled')); ?></span>
								</div>
							</div>

							<div class="form-group">
								<label for="input_paypal_mode" class="col-sm-3 control-label">PayPal Mode <em ng-show="paypal_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('paypal_mode', array('sandbox' => 'Sandbox', 'live' => 'Live'), old('paypal_mode',payment_gateway('mode','Paypal')), ['class' => 'form-control', 'id' => 'input_paypal_mode']); ?>

									<span class="text-danger"><?php echo e($errors->first('paypal_mode')); ?></span>
								</div>
							</div>

							<div class="form-group">
								<label for="input_paypal_id" class="col-sm-3 control-label">PayPal Id <em ng-show="paypal_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paypal_id', old('paypal_id',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('paypal_id','Paypal'))), ['class' => 'form-control', 'id' => 'input_paypal_id', 'placeholder' => 'PayPal Id']); ?>

									<span class="text-danger"><?php echo e($errors->first('paypal_id')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_paypal_client" class="col-sm-3 control-label">PayPal Client ID <em ng-show="paypal_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paypal_client', old('paypal_client',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('client','Paypal'))), ['class' => 'form-control', 'id' => '', 'placeholder' => 'PayPal Client']); ?>

									<span class="text-danger"><?php echo e($errors->first('paypal_client')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_paypal_secret" class="col-sm-3 control-label"> PayPal Secret <em ng-show="paypal_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paypal_secret', old('paypal_secret',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('secret','Paypal'))), ['class' => 'form-control', 'id' => '', 'placeholder' => 'PayPal Secret']); ?>

									<span class="text-danger"><?php echo e($errors->first('paypal_secret')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="accessToken" class="col-sm-3 control-label"> PayPal Access Token <em ng-show="paypal_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paypal_access_token', old('paypal_access_token',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('access_token','Paypal'))), ['class' => 'form-control', 'id' => 'accessToken', 'placeholder' => 'PayPal Access Token']); ?>

									<span class="text-danger"><?php echo e($errors->first('paypal_access_token')); ?></span>
								</div>
							</div>
						</div>
						<!-- Paypal Section End -->
						<!-- Stripe Section Start -->
						<div class="box-body" ng-init="stripe_enabled=<?php echo e(old('stripe_enabled',payment_gateway('is_enabled','Stripe'))); ?>">
							<div class="form-group">
								<label for="input_stripe_enabled" class="col-sm-3 control-label">Is Stripe Enabled <em class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('stripe_enabled', array('0' => 'No', '1' => 'Yes'), old('stripe_enabled',payment_gateway('is_enabled','Stripe')), ['class' => 'form-control', 'id' => 'input_stripe_enabled','ng-model' => 'stripe_enabled']); ?>

									<span class="text-danger"><?php echo e($errors->first('stripe_enabled')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_stripe_publish_key" class="col-sm-3 control-label"> Stripe Key <em ng-show="stripe_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('stripe_publish_key', preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', old('stripe_publish_key',payment_gateway('publish','Stripe'))), ['class' => 'form-control', 'id' => 'input_stripe_publish_key', 'placeholder' => 'Stripe Key']); ?>

									<span class="text-danger"><?php echo e($errors->first('stripe_publish_key')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_stripe_secret_key" class="col-sm-3 control-label"> Stripe Secret <em ng-show="stripe_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('stripe_secret_key', old('stripe_secret_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('secret','Stripe'))), ['class' => 'form-control', 'id' => 'input_stripe_secret_key', 'placeholder' => 'Stripe Secret']); ?>

									<span class="text-danger"><?php echo e($errors->first('stripe_secret_key')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_stripe_api_version" class="col-sm-3 control-label"> Stripe API Version <em ng-show="stripe_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('stripe_api_version', old('stripe_api_version',payment_gateway('api_version','Stripe')), ['class' => 'form-control', 'id' => 'input_stripe_api_version', 'placeholder' => 'Stripe API Version']); ?>

									<span class="text-danger"><?php echo e($errors->first('stripe_api_version')); ?></span>
								</div>
							</div>
						</div>
					</div>
					<!-- Stripe Section End -->
					
						<!-- Paytm Section Start -->
						<div class="box-body">
							<div class="form-group" ng-init="paytm_enabled=<?php echo e(old('paytm_enabled',payment_gateway('is_enabled','Paytm'))); ?>">
								<label for="input_paytm_enabled" class="col-sm-3 control-label">Is Paytm Enabled <em class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('paytm_enabled', array('0' => 'No', '1' => 'Yes'), '', ['class' => 'form-control', 'id' => 'input_paytm_enabled', 'ng-model' => 'paytm_enabled']); ?>

									<span class="text-danger"><?php echo e($errors->first('paytm_enabled')); ?></span>
								</div>
							</div>

							<div class="form-group">
								<label for="input_paytm_mode" class="col-sm-3 control-label">Paytm Mode <em ng-show="paytm_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('paytm_mode', array('local' => 'Sandbox', 'live' => 'Live'),preg_replace('/[a-zA-Z]+|\d+/', 'XXXX',  old('paytm_mode',payment_gateway('mode','Paytm'))), ['class' => 'form-control', 'id' => 'input_paytm_mode']); ?>

									<span class="text-danger"><?php echo e($errors->first('paytm_mode')); ?></span>
								</div>
							</div>

							<div class="form-group">
								<label for="input_paytm_id" class="col-sm-3 control-label">Paytm Merchant Id <em ng-show="paytm_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paytm_id', old('paytm_id',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('merchant_id','Paytm'))), ['class' => 'form-control', 'id' => 'input_paytm_id', 'placeholder' => 'paytm merchant Id']); ?>

									<span class="text-danger"><?php echo e($errors->first('paytm_id')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_paytm_key" class="col-sm-3 control-label">Paytm Merchant Key <em ng-show="paytm_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paytm_key', old('paytm_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('key','Paytm'))), ['class' => 'form-control', 'id' => '', 'placeholder' => 'paytm key']); ?>

									<span class="text-danger"><?php echo e($errors->first('paytm_key')); ?></span>
								</div>
							</div>

							<div class="form-group">
								<label for="input_paytm_website" class="col-sm-3 control-label">Paytm Merchant Website <em ng-show="paytm_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paytm_website', old('paytm_website',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('website','Paytm'))), ['class' => 'form-control', 'id' => '', 'placeholder' => 'paytm merchant website']); ?>

									<span class="text-danger"><?php echo e($errors->first('paytm_website')); ?></span>
								</div>
							</div>

							<div class="form-group">
								<label for="input_paytm_channel" class="col-sm-3 control-label">Paytm Merchant Channel <em ng-show="paytm_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paytm_channel', old('paytm_channel',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('channel','Paytm'))), ['class' => 'form-control', 'id' => '', 'placeholder' => 'paytm merchant channel']); ?>

									<span class="text-danger"><?php echo e($errors->first('paytm_channel')); ?></span>
								</div>
							</div>

							<div class="form-group">
								<label for="input_paytm_type" class="col-sm-3 control-label">Paytm Industry Type <em ng-show="paytm_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('paytm_type', old('paytm_type',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('type','Paytm'))), ['class' => 'form-control', 'id' => '', 'placeholder' => 'paytm industry type']); ?>

									<span class="text-danger"><?php echo e($errors->first('paytm_type')); ?></span>
								</div>
							</div>

		
						<!-- Razory Pay Section Start  -->
						<div class="box-body" ng-init="razorpay_enabled=<?php echo e(old('razorpay_enabled',payment_gateway('is_enabled','Razorpay'))); ?>">
							<div class="form-group">
								<label for="input_razorpay_enabled" class="col-sm-3 control-label">Is Razorpay Enabled <em class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('razorpay_enabled', array('0' => 'No', '1' => 'Yes'), old('razorpay_enabled',payment_gateway('is_enabled','Razorpay')), ['class' => 'form-control', 'id' => 'input_razorpay_enabled','ng-model' => 'razorpay_enabled']); ?>

									<span class="text-danger"><?php echo e($errors->first('razorpay_enabled')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_razorpay_mode" class="col-sm-3 control-label">Razorpay Mode <em ng-show="razorpay_enabled == '1'" class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('razorpay_mode', array('sandbox' => 'Sandbox', 'live' => 'Live'), old('razorpay_mode',payment_gateway('mode','Razorpay')), ['class' => 'form-control', 'id' => 'input_razorpay_mode']); ?>

									<span class="text-danger"><?php echo e($errors->first('razorpay_mode')); ?></span>
								</div>
							</div>

							<div class="form-group">
								<label for="input_razorpay_publish_key" class="col-sm-3 control-label"> Razorpay Key <em ng-show="razorpay_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('razorpay_publish_key', old('razorpay_publish_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('key','Razorpay'))), ['class' => 'form-control', 'id' => 'input_razorpay_publish_key', 'placeholder' => 'Razorpay Key']); ?>

									<span class="text-danger"><?php echo e($errors->first('razorpay_publish_key')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_razorpay_secret_key" class="col-sm-3 control-label"> Razorpay Secret <em ng-show="razorpay_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('razorpay_secret_key', old('razorpay_secret_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('secret','Razorpay'))), ['class' => 'form-control', 'id' => 'input_razorpay_secret_key', 'placeholder' => 'Razorpay Secret']); ?>

									<span class="text-danger"><?php echo e($errors->first('razorpay_secret_key')); ?></span>
								</div>
							</div>
		
						</div>
				
					 <!-- Razory Pay Section End -->
					  
					  
					 	<!-- Flutterwave Section Start -->
						 <div class="box-body" ng-init="flutterwave_enabled=<?php echo e(old('flutterwave_enabled',payment_gateway('is_enabled','Flutterwave'))); ?>">
							<div class="form-group">
								<label for="input_flutterwave_enabled" class="col-sm-3 control-label">Is Flutterwave Enabled <em class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('flutterwave_enabled', array('0' => 'No', '1' => 'Yes'), old('flutterwave_enabled',payment_gateway('is_enabled','Flutterwave')), ['class' => 'form-control', 'id' => 'input_flutterwave_enabled','ng-model' => 'flutterwave_enabled']); ?>

									<span class="text-danger"><?php echo e($errors->first('flutterwave_enabled')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_flutterwave_publish_key" class="col-sm-3 control-label"> Flutterwave Key <em ng-show="flutterwave_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('flutterwave_publish_key', preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', old('flutterwave_publish_key',payment_gateway('key','Flutterwave'))), ['class' => 'form-control', 'id' => 'input_flutterwave_publish_key', 'placeholder' => 'Flutterwave Key']); ?>

									<span class="text-danger"><?php echo e($errors->first('flutterwave_publish_key')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_flutterwave_secret_key" class="col-sm-3 control-label"> Flutterwave Secret <em ng-show="flutterwave_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('flutterwave_secret_key', old('flutterwave_secret_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('secret','Flutterwave'))), ['class' => 'form-control', 'id' => 'input_flutterwave_secret_key', 'placeholder' => 'Flutterwave Secret']); ?>

									<span class="text-danger"><?php echo e($errors->first('flutterwave_secret_key')); ?></span>
								</div>
							</div>
							<div class="form-group">
								<label for="input_flutterwave_hash_key" class="col-sm-3 control-label"> Flutterwave Hash <em ng-show="flutterwave_enabled == '1'" class="text-danger">*</em></label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::text('flutterwave_hash_key', old('flutterwave_hash_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('hash','Flutterwave'))), ['class' => 'form-control', 'id' => 'input_flutterwave_hash_key', 'placeholder' => 'Flutterwave Hash']); ?>

									<span class="text-danger"><?php echo e($errors->first('flutterwave_hash_key')); ?></span>
								</div>
							</div>

						</div>
						

						<!-- Flutterwave Section End -->
					
								
					<!-- Redsys Section Start -->
					<div class="box-body">
						<div class="form-group" ng-init="redsys_enabled=<?php echo e(old('redsys_enabled',payment_gateway('is_enabled','Redsys'))); ?>">
							<label for="input_redsys_enabled" class="col-sm-3 control-label">Is Redsys Enabled <em class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::select('redsys_enabled', array('0' => 'No', '1' => 'Yes'), '', ['class' => 'form-control', 'id' => 'input_redsys_enabled', 'ng-model' => 'redsys_enabled']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_enabled')); ?></span>
							</div>
						</div>

						<div class="form-group">
							<label for="input_redsys_enviroment" class="col-sm-3 control-label">Redsys Mode <em ng-show="redsys_enabled == '1'" class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::select('redsys_enviroment', array('test' => 'Test', 'live' => 'Live'), old('redsys_enviroment',payment_gateway('mode','Paytm')), ['class' => 'form-control', 'id' => 'input_redsys_enviroment']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_enviroment')); ?></span>
							</div>
						</div>

						<div class="form-group">
							<label for="input_redsys_merchant_code" class="col-sm-3 control-label">Redsys Merchant Code <em ng-show="redsys_enabled == '1'" class="text-danger">*</em></label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('redsys_merchant_code', old('redsys_merchant_code',payment_gateway('merchant_code','Redsys')), ['class' => 'form-control', 'id' => 'input_redsys_merchant_code', 'placeholder' => 'redsys merchant code']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_merchant_code')); ?></span>
							</div>
						</div>
						<div class="form-group">
							<label for="input_redsys_key" class="col-sm-3 control-label">Redsys  Key <em ng-show="redsys_enabled == '1'" class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('redsys_key', old('redsys_key',payment_gateway('key','Redsys')), ['class' => 'form-control', 'id' => '', 'placeholder' => 'redsys key']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_key')); ?></span>
							</div>
						</div>

						<div class="form-group">
							<label for="input_redsys_terminal" class="col-sm-3 control-label">Redsys Terminal <em ng-show="redsys_enabled == '1'" class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('redsys_terminal', old('redsys_terminal',payment_gateway('terminal','Redsys')), ['class' => 'form-control', 'id' => '', 'placeholder' => 'redsys terminal']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_terminal')); ?></span>
							</div>
						</div>

						<div class="form-group">
							<label for="input_redsys_url_notification" class="col-sm-3 control-label">Redsys Url Notification <em ng-show="redsys_enabled == '1'" class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('redsys_url_notification', old('redsys_url_notification',payment_gateway('url_notification','Redsys')), ['class' => 'form-control', 'id' => '', 'placeholder' => 'redsys url notification']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_url_notification')); ?></span>
							</div>
						</div>
						
							<div class="form-group">
							<label for="input_redsys_url_ok" class="col-sm-3 control-label">Redsys Url Ok <em ng-show="redsys_enabled == '1'" class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('redsys_url_ok', old('redsys_url_notification',payment_gateway('url_ok','Redsys')), ['class' => 'form-control', 'id' => '', 'placeholder' => 'redsys url ok']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_url_ok')); ?></span>
							</div>
						</div>
						
								<div class="form-group">
							<label for="input_redsys_url_ko" class="col-sm-3 control-label">Redsys Url Ko <em ng-show="redsys_enabled == '1'" class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('redsys_url_ko', old('redsys_url_notification',payment_gateway('url_ko','Redsys')), ['class' => 'form-control', 'id' => '', 'placeholder' => 'redsys url ko']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_url_ko')); ?></span>
							</div>
						</div>

						<div class="form-group">
							<label for="input_redsys_tradename" class="col-sm-3 control-label">Redsys Tradename <em ng-show="redsys_enabled == '1'" class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('redsys_tradename', old('redsys_tradename',payment_gateway('tradename','Redsys')), ['class' => 'form-control', 'id' => '', 'placeholder' => 'redsys trade name']); ?>

								<span class="text-danger"><?php echo e($errors->first('redsys_tradename')); ?></span>
							</div>
						</div>

						<!---Redsys Section End -->
						

					<!-- Braintree Section Start -->
					<div class="box-body" ng-init="bt_enabled=<?php echo e(old('bt_enabled',payment_gateway('is_enabled','Braintree'))); ?>">
						<div class="form-group">
								<label for="input_bt_enabled" class="col-sm-3 control-label">Is Braintree Enabled <em class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php echo Form::select('bt_enabled', array('0' => 'No', '1' => 'Yes'), preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', old('bt_enabled',payment_gateway('is_enabled','Braintree'))), ['class' => 'form-control', 'id' => 'input_bt_enabled','ng-model' => 'bt_enabled']); ?>

									<span class="text-danger"><?php echo e($errors->first('bt_enabled')); ?></span>
								</div>
							</div>
						<div class="form-group">
							<label for="input_mode" class="col-sm-3 control-label"> Payment Mode <em ng-show="bt_enabled == '1'" class="text-danger">*</em> </label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::select('bt_mode', array('sandbox' => 'Sandbox', 'production' => 'Production'), old('bt_mode'
								,payment_gateway('mode','Braintree')), ['class' => 'form-control', 'id' => 'input_mode']); ?>

								<span class="text-danger"><?php echo e($errors->first('mode')); ?></span>
							</div>
						</div>
						<div class="form-group">
							<label for="input_merchant_id" class="col-sm-3 control-label"> Braintree Merchant ID <em ng-show="bt_enabled == '1'" class="text-danger">*</em></label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('bt_merchant_id', old('bt_merchant_id',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('merchant_id','Braintree'))), ['class' => 'form-control', 'id' => 'input_merchant_id', 'placeholder' => 'Merchant ID']); ?>

								<span class="text-danger"><?php echo e($errors->first('bt_merchant_id')); ?></span>
							</div>
						</div>
						<div class="form-group">
							<label for="input_merchant_id" class="col-sm-3 control-label">
								Braintree Merchant Account ID
								<span class="tooltip-custom"><i class="icon"></i> 
									<em style="margin-left: -108px;">
										Merchant account ID is a unique identifier for a specific merchant account in your gateway, and is used to specify which merchant account to use when creating a transaction.
									</em>
								</span>
							</label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('merchant_account_id', old('merchant_account_id', preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('merchant_account_id','Braintree'))), ['class'=>'form-control', 'id'=>'input_merchant_account_id', 'placeholder'=>'Braintree Merchant Account Id']); ?>

								<small class="description" style="color: #9da1ab;">
					                For default account id, leave it as empty.
					            </small>
							</div>
						</div>

						<div class="form-group">
							<label for="input_bt_public" class="col-sm-3 control-label"> Braintree Public Key <em ng-show="bt_enabled == '1'" class="text-danger">*</em></label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('bt_public_key', old('bt_public_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('public_key','Braintree'))), ['class' => 'form-control', 'id' => 'input_bt_public', 'placeholder' => 'Public Key']); ?>

								<span class="text-danger"><?php echo e($errors->first('bt_public_key')); ?></span>
							</div>
						</div>
						<div class="form-group">
							<label for="input_bt_private_key" class="col-sm-3 control-label"> Braintree Private Key <em ng-show="bt_enabled == '1'" class="text-danger">*</em></label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('bt_private_key', old('bt_private_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('private_key','Braintree'))), ['class' => 'form-control', 'id' => 'input_bt_private_key', 'placeholder' => 'Private Key']); ?>

								<span class="text-danger"><?php echo e($errors->first('bt_private_key')); ?></span>
							</div>
						</div>
						<div class="form-group">
							<label for="input_tokenization_key" class="col-sm-3 control-label">
								Braintree Tokenization Key
								<span class="tooltip-custom"><i class="icon"></i> 
									<em style="margin-left: -108px;">
										Manage the ways you authorize requests to Braintree for client requests
									</em>
								</span>
								<em class="text-danger">*</em>
							</label>
							<div class="col-md-7 col-sm-offset-1">
								<?php echo Form::text('tokenization_key', old('tokenization_key',preg_replace('/[a-zA-Z]+|\d+/', 'XXXX', payment_gateway('tokenization_key','Braintree'))), ['class'=>'form-control', 'id'=>'input_tokenization_key', 'placeholder'=>'Braintree Tokenization Key']); ?>

								<span class="text-danger"><?php echo e($errors->first('tokenization_key')); ?></span>
							</div>
						</div>
					</div>
					<!-- Braintree Section End -->

				

					<!-- Payout Methods Section Start -->
						<div class="box-body">
							<div class="form-group">
								<label for="input_payout_methods" class="col-sm-3 control-label"> Payout Methods <em class="text-danger">*</em> </label>
								<div class="col-md-7 col-sm-offset-1">
									<?php $__currentLoopData = PAYOUT_METHODS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payout_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<div ng-init="payout_method_<?php echo e($payout_method['key']); ?>=<?php echo e(isPayoutEnabled($payout_method['key'])); ?>">
										<input type="checkbox" name="payout_methods[]" id="payout_method-<?php echo e($payout_method['key']); ?>" value="<?php echo e($payout_method['key']); ?>" ng-checked="<?php echo e(isPayoutEnabled($payout_method['key'])); ?>"> <label for="payout_method-<?php echo e($payout_method['key']); ?>" ng-model="payout_method_<?php echo e($payout_method['key']); ?>"> <?php echo e($payout_method["value"]); ?> </label>
									</div>										
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</div>
							</div>
					</div>
					<!-- Payout Methods Section End -->
					
					<div class="box-footer text-center">
						<button type="submit" class="btn btn-info" name="submit" value="submit">Submit</button>
						<button type="reset" class="btn btn-default"> Cancel </button>
					</div>
				</div>
			</div>
			<?php echo Form::close(); ?>

		</div>
	</div>
</section>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ridein/resources/views/admin/payment_gateway.blade.php ENDPATH**/ ?>