<?php

return [
	'admin' => [
		'dashboard' => 'Dashboard',
		'copyright' => 'Copyright',
		'all_rights_reserved' => 'All rights reserved',
		'manage_admin' => [
			'title' => 'Manage Admin',
			'admin_users' => 'Admin Users',
			'role_and_permissions' => 'Role and Permissions'
		],
		"manage_company" => 'Manage Company',
		'manage_drivers' => 'Manage Drivers',
		'manage_riders' => "Manage Riders",
		'manage_documents' => 'Manage Documents',
		'send_messages' => 'Send Messages',
		'manage_emails' => [
			'title' => 'Manage Emails',
			'send_mail' => 'Send Mail',
			'email_settings' => 'Email Settings',
		],
		'manage_manual_booking' => [
			'title' => 'Manage Manual Booking',
			'manual_booking' => 'Manual Booking',
			'view_manual' => 'View Manual/Schedule Booking',
		],
		'vehicle_make' => 'Vehicle Make',
		'vehicle_model' => 'Vehicle Model',
		'additional_reasons' => 'Additional Reasons',
		'manage_cancel_reason' => 'Manage Cancel Reason',
		'manage_locations' => 'Manage Locations',
		'manage_fare' => 'Manage Fare',
		'manage_trips' => [
			'title' => 'Manage Trips',
			'manage_ride_requests' => 'Manage Ride Requests',
			'manage_trips' => 'Manage Trips',
			'manage_canceled_trips' => 'Manage Canceled Trips',
			'cancelled_trips' => 'Cancelled Trips',
			'manage_payments' => 'Manage Payments',
			'request_details' => 'Request Details',
			'ratings' => 'Ratings',
			'payments' => 'Payments',
			'ride_requests' => 'Ride Requests',
			'trips' => 'Trips',
		],
		'manage_payouts' => [
			'title' => 'Manage Payouts',
			'company_payouts' => 'Company Payouts',
			'driver_payouts' => 'Driver Payouts',
			'driver_payouts_title' => 'Manage Driver :payout_title',
			'company_payouts_title' => ' Manage Company :payout_title',
			'table' => [
				'id' => 'Id',
				'driver_id' => 'Driver ID',
				'driver_name' => 'Driver Name',
				'payout_amount' => 'Payout Amount',
				'company_id' => 'Company ID',
				'company_name' => 'Company Name',
				'payout_amount' => 'Payout Amount',
				'action' => 'Action',
			]
		],
		'manage_owe_amount' => 'Manage Owe Amount',
		'manage_statements' => [
			'title' => 'Manage Statements',
			'overall_statements' => 'Overall Statements',
			'drivers_statments' => 'Drivers Statements',
			'statements' => 'Statements',
			'filter_by' => 'Filter By',
			'search' => 'Search',
			'total_amount_received' => 'Total Amount Received',
			'total_earnings' => 'Total Earnings',
			'completed_rides' => 'Completed Rides',
			'cancelled_rides' => 'Cancelled Rides',
			'drivers' => 'Drivers',
			'overall' => 'Overall',
			'view_by_rider' => 'View By Rider',
			'from_date' => 'From Date',
			'to_date' => 'To Date',
			'today' => 'Today',
			'weekly' => 'Weekly',
			'monthly' => 'Monthly',
			'yearly' => 'Yearly',
			'custom' => 'Custom',
			'view_trip_details' => 'View Trip Details',
			'table' => [
				'driver_id' => 'Driver ID',
				'driver_name' => 'Driver Name',
				'mobile' => 'Mobile',
				'total_rides' => 'Total Rides',
				'earnings' => 'Earnings',
				'joined_at' => 'Joined At',
				'details' => 'Details',
				'booking_id' => 'Booking Id',
				'company_name' => 'Company Name',
				'pickup_location' => 'Pickup Location',
				'drop_location' => 'Drop Location',
				'trip_details' => 'Trip Details',
				'admin_commission' => 'Admin Commmission',
				'admin_payout_status' => 'Admin Payout Status',
				'dated_on' => 'Dated On',
				'status' => 'Status',
				'earned' => 'Earned'
			]
		],
		'manage_wallet_and_promo' => [
			'title' => 'Manage Wallet & Promo',
			'wallet' => 'wallet',
			'manage_wallet_amount' => 'Manage Wallet Amount',
			'manage_promo_code' => 'Manage Promo Code',
			'add_wallet' => 'Add Wallet',
			'add_wallet_amount' => 'Add Wallet Amount',
			'add_title' => 'Add Wallet Form',
			'edit_wallet' => 'Edit Wallet Amount',
			'edit_title' => 'Edit Wallet Form',
			'rider' => 'Rider',
			'promo_code' => 'Promo Code',
			'add_promo_code' => 'Add Promo Code',
			'add_promo_code_form' => 'Add Promo Code Form',
			'edit_promo_code' => 'Edit Promo Code',
			'edit_promo_code_form' => 'Edit Promo Code Form',
			'table' => [
				'id' => 'id',
				'user_id' => 'User Id',
				'first_name' => 'First Name',
				'last_name' => 'Last Name',
				'wallet_amount' => 'Wallet Amount',
				'currency_code' => 'Currency Code',
				'action' => 'Action',
				'code' => 'Code',
				'original_amount' => 'Original Amount',
				'expire_date' => 'Expire Date',
				'status' => 'Status',
			],
			'form' => [
				'username' => 'Username',
				'amount' => 'Amount',
				'currency_code' => 'Currency Code',
				'promo_code' => 'Promo Code',
				'expire_date' => 'Expire Date',
				'status' => 'Status'
			]

		],
		'referrals' => [
			'title' => "Referrals",
			'drivers' => 'Drivers',
			'riders' => 'Riders',
			'referral' => 'Referral',
			'view_referral_details' => 'View Referral Details',
			'details' => 'Details',
			'table' => [
				'id' => 'Id',
				'name' => 'Name',
				'driver_name' => 'Driver Name',
				'referral_name' => 'Referral Name',
				'currency_code' => 'Currency Code',
				'earned_amount' => 'Earned Amount',
				'pending_amount' => 'Pending Amount',
				'action' => 'Action',
				'trips' => 'Trips',
				'remaining_trips' => 'Remaining Trips',
				'remaining_days' => 'Remaining Days',
				'amount' => 'Amount',
				'status' => 'Status',
			]
		],
		'manage_map' => [
			'title' => 'Manage Map',
			'map_view' => 'Map View',
			'heat_map' => 'Heat Map',
			'map' => 'Map',
			'user' => 'User',
			'unavailable_driver' => 'Unavailable Driver',
			'available_driver' => 'Available Driver',
			'unactivated_driver' => 'Unactivated Driver',
		],
		'manage_mobile_app_version' => [
			'title' => 'Manage Mobile App Version',
			'subtitle' => 'Mobile App version',
			'edit_mobile_app_version_form' => 'Edit Mobile App Version Form',
			'add_mobile_app_version_form' => 'Add Mobile App Version Form',
			'table' => [
				'id' => 'Id',
				'version' => 'Version',
				'device_type' => 'Device Type',
				'user_type' => 'User Type',
				'force_update' => 'Force Update',
				'created_at' => 'Created At',
				'updated_at' => 'Updated At',
				'action' => 'Action',
			],
			'form' => [
				'version' => 'Version',
				'device_type' => 'Device Type',
				'user_type' => 'User Type',
				'force_update' => 'Force Update',
			]

		],
		'api_credentials' => [
			'title' => 'Api Credentials',
			'form_title' => 'Api Credentials Form',
			'form' => [
				'google_map_key' => 'Google Map Key',
				'google_map_server_key' => 'Google Map Server Key',
				'twillo_sid' => 'Twillo SID',
				'twillo_token' => 'Twillo Token',
				'twillo_from_number' => 'Twillo From Number',
				'twillo_service_sid' => 'Twillo Service SID',
				'apple_service_id' => 'Apple Service Id',
				'apple_team_id' => 'Apple Team Id',
				'apple_key_id' => 'Apple Key Id',
				'apple_key_file' => 'Apple Key File',
				'firebase_database_url' => 'Firebase Database URL',
				'firebase_service_account' => 'Firebase Service Account File (JSON)'
			]
		],
		'payment_gateway' => [
			'title' => 'Payment Gateway',
			'form_title' => 'Payment Gateway Form',
			'note' => 'Note',
			'zaincash_note' => 'Please make sure to set the Default Currency and Payment Currency to Iraqi Dinar as the default payment option in the site settings.',
			'tabs' => [
				'paypal' => 'Paypal',
				'stripe' => 'Stripe',
				'paytm' => 'Paytm',
				'razorpay' => 'RazorPay',
				'flutterwave' => 'FlutterWave',
				'redsys' => 'Redsys',
				'braintree' => 'Braintree',
				'zaincash' => 'Zaincash',
				'mtn' => 'MTN momo',
				'yoPayment' => 'Yo! Payments',
				'payout_methods' => 'Payout Methods'
			],
			'form' => [
				'is_paypal_enabled' => 'Is Paypal Enabled',
				'paypal_mode' => 'PayPal Mode',
				'paypal_id' => 'PayPal Id',
				'paypal_client_id' => 'PayPal Client ID ',
				'paypal_secret' => 'PayPal Secret',
				'paypal_access_token' => 'PayPal Access Token ',
				'is_stripe_enabled' => 'Is Stripe Enabled',
				'stripe_key' => 'Stripe Key',
				'stripe_secret' => 'Stripe Secret',
				'stripe_api_version' => 'Stripe API Version',
				'is_paytm_enabled' => 'Is Paytm Enabled ',
				'paytm_mode' => 'Paytm Mode',
				'paytm_merchant_id' => 'Paytm Merchant Id ',
				'paytm_merchant_key' => 'Paytm Merchant Key',
				'paytm_merchant_website' => 'Paytm Merchant Website',
				'paytm_merchant_channel' => 'Paytm Merchant Channel ',
				'paytm_industry_type' => 'Paytm Industry Type ',
				'is_razorpay_enabled' => 'Is Razorpay Enabled',
				'razorpay_mode' => 'Razorpay Mode',
				'razorpay_key' => 'Razorpay Key',
				'razorpay_secret' => 'Razorpay Secret',
				'is_flutterwave_enabled' => 'Is Flutterwave Enabled',
				'flutterwave_key' => 'Flutterwave Key',
				'flutterwave_secret' => 'Flutterwave Secret',
				'flutterwave_hash' => 'Flutterwave Hash ',
				'is_redsys_enabled' => 'Is Redsys Enabled',
				'redsys_mode' => 'Redsys Mode',
				'redsys_merchant_mode' => 'Redsys Merchant Code',
				'redsys_key' => 'Redsys Key',
				'redsys_terminal' => 'Redsys Terminal',
				'redsys_url_notification' => 'Redsys Url Notification ',
				'redsys_url_ok' => 'Redsys Url Ok',
				'redsys_url_ko' => 'Redsys Url Ko',
				'redsys_tradename' => 'Redsys Tradename',
				'is_braintree_enabled' => 'Is Braintree Enabled',
				'payment_mode' => 'Payment Mode',
				'braintree_merchant_id' => 'Braintree Merchant ID ',
				'Braintree_merchant_account_id' => 'Braintree Merchant Account ID ',
				'braintree_public_key' => 'Braintree Public Key',
				'braintree_private_key' => 'Braintree Private Key ',
				'braintree_tokenization_key' => 'Braintree Tokenization Key',
				'zaincash_mode' => 'Zaincash Mode',
				'is_zaincash_enabled' => 'Is Zaincash Enabled',
				'zaincash_msisdn' => 'Zaincash MSISDN',
				'zaincash_merchant_id' => 'Zaincash Merchant ID',
				'zaincash_merchant_secret' => 'Zaincash Merchant Secret',
				'web_payment' => 'Web payment',
				'payout_methods' => 'Payout Methods',
				'mtn_mode' => 'Mtn Mode',
				'is_mtn_enabled' => 'Is MTN Enabled',
				'mtn_subscription_key' => 'MTN Subscription key',
				'mtn_collection_id' => 'MTN Collection ID',
				'mtn_secret' => 'MTN Secret',
				'mtn_callback_url' => 'MTN Callback URL',
				'is_mtn_disbursement_enabled' => 'Is MTN Disbursement Enabled',
				'mtn_disbursement_mode' => 'MTN Disbursement Mode',
				'mtn_disbursement_subscription_key' => 'MTN Disbursement Subscription key',
				'mtn_disbursement_collection_id' => 'MTN Disbursement Collection ID',
				'mtn_disbursement_secret' => 'MTN Disbursement Secret',
				'mtn_disbursement_callback_url' => 'MTN Disbursement Callback URL',
				'is_yopayment_enabled' => 'Is Yo Payment',
				'yopayment_mode' => ' Yo Payment Mode',
				'yopayment_username' => 'Yo Payment Username',
				'yopayment_password' => 'Yo Payment Password'
			]
		],
		'mange_fees' => [
			'title' => 'Manage Fees',
			'fees' => 'Fees',
			'fees_form' => 'Fees Form',
			'form' => [
				'rider_service_fee' => 'Rider Service Fee',
				'driver_peak_fare' => 'Driver Peak Fare',
				'is_pool' => '2nd Rider Amount',
				'is_pool_small' => 'For Pool Trips',
				'driver_service_fee' => 'Driver Service Fee',
				'apply_trip_additional_fee' => 'Apply Trip Additional Fee'
			]
		],
		'manage_referral_settings' => [
			'title' => 'Manage Referral Settings',
			'referral_settings' => 'Referral Settings',
			'form_title' => 'Manage Driver Referral Settings Form',
			'form' => [
				'number_of_trips' => 'Number Of Trips',
				'driver_days' => 'Time Frame (In days)',
				'currency_code' => 'Currency Code',
				'driver_amount' => 'Amount for Trips',
				'referral_amount' => 'Referral Amount',
				'time_frame' => 'Time Frame'
			]
		],
		'manage_metas' => [
			'title' => 'Manage Metas',
			'metas' => 'Metas',
			'edit_meta' => 'Edit Metas',
			'edit_meta_form' => 'Edit Meta Form',
			'table' => [
				'id' => 'Id',
				'url' => 'Url',
				'title' => 'Title',
				'description' => 'Description',
				'keywords' => 'Keywords',
				'action' => 'Action',
			],
			'form' => [
				'page_url' => 'Page URL',
				'page_title' => 'Page Title',
				'meta_description' => 'Meta Description',
				'keywords' => 'Keywords'
			]
		],
		'manage_country' => [
			'title' => 'Manage Countries',
			'country' => 'Country',
			'add_country' => 'Add Country',
			'add_country_form' => 'Add Country Form',
			'edit_country' => 'Edit Country',
			'edit_country_form' => 'Edit Country Form',
			'table' => [
				'id' => 'Id',
				'short_name' => 'Short Name',
				'long_name' => 'Long Name',
				'iso3' => 'Iso3',
				'num_code' => 'Num Code',
				'phone_code' => 'Phone Code',
				'action' => 'Action',
			],
			'form' => [
				'short_name' => 'Short Name',
				'long_name' => 'Long Name',
				'iso3' => 'Iso3',
				'num_code' => 'Num Code',
				'phone_code' => 'Phone Code',
			]
		],
		'manage_currency' => [
			'title' => 'Manage Currencies',
			'currency' => 'Currency',
			'add_currency' => 'Add Currency',
			'add_currency_form' => 'Add Currency Form',
			'edit_currency' => 'Edit Currency',
			'edit_currency_form' => 'Edit Currency Form',
			'table' => [
				'id' => 'Id',
				'name' => 'Name',
				'code' => 'Code',
				'rate' => 'Rate',
				'status' => 'Status',
				'action' => 'Action',
			],
			'form' => [
				'name' => 'Name',
				'code' => 'Code',
				'rate' => 'Rate',
				'symbol' => 'Symbol',
				'status' => 'Status',
			]
		],
		'manage_language' => [
			'title' => 'Manage Languages',
			'language' => 'Language',
			'add_language' => 'Add Language',
			'add_language_form' => 'Add Language Form',
			'edit_language' => 'Edit Language',
			'edit_language_form' => 'Edit Language Form',
			'table' => [
				'id' => 'Id',
				'name' => 'Name',
				'value' => 'Value',
				'status' => "Status",
				'action' => 'Action',
			],
			'form' => [
				'name' => 'Name',
				'value' => 'Value',
				'status' => "Status",
			]
		],
		'manage_static_pages' => [
			'title' => 'Manage Static Pages',
			'static_page' => 'Static Pages',
			'page' => 'Page',
			'add_page' => 'Add Page',
			'add_page_form' => 'Add Page Form',
			'edit_page' => 'Edit Page',
			'edit_page_form' => 'Edit Page Form',
			'translations' => 'Translations',
			'add_translation' => 'Add translation',
			'table' => [
				'id' => 'Id',
				'name' => 'Name',
				'url' => 'Url',
				'status' => 'Status',
				'updated_at' => 'Updated At',
				'action' => 'Action',
			],
			'form' => [
				'name' => 'Name',
				'content' => 'Content',
				'footer' => 'Footer',
				'status' => 'Status',
				'language' => 'Language',
				'question' => 'Question',
				'answer' => 'Answer'
			]
		],
		'manage_help' => [
			'title' => 'Manage Help',
			'help' => 'Help',
			'category' => 'Categories',
			'subcategory' => 'Subcategories',
			'help_category' => 'Help Category',
			'add_help' => 'Add Help',
			'add_help_form' => 'Add Help Form',
			'edit_help' => 'Edit Help',
			'edit_help_form' => 'Edit Help Form',
			'help_sub_category' => 'Help Sub Category',
			'add_help_category' => 'Add Help Category',
			'add_help_category_form' => 'Add Help Category Form',
			'edit_help_category_form' => 'Edit Help Category Form',
			'help_sub_category' => 'Help Sub Category',
			'add_help_sub_category' => 'Add Help Sub Category',
			'add_help_sub_category_form' => 'Add Help Sub Category Form',
			'edit_help_sub_category' => 'Edit Help Sub Category',
			'edit_help_sub_category_form' => 'Edit Help Sub Category Form',
			'translations' => 'Translations',
			'add_translation' => 'Add translation',
			'table' => [
				'id' => "Id",
				'category' => 'Category',
				'subcategory' => 'Sub Category',
				'question' => 'Question',
				'suggested' => 'Suggested',
				'answer' => 'Answer',
				'status' => 'Status',
				'action' => 'Action',
				'name' => 'Name',
				'description' => 'Description',
				'suggested' => 'Suggested',
			],
			'form' => [
				'language' => 'Language',
				'category' => 'Category',
				'subcategory' => 'Sub Category',
				'question' => 'Question',
				'answer' => 'Answer',
				'name' => 'Name',
				'description' => 'Description',
				'suggested' => 'Suggested',
				'status' => 'Status',
			]
		],
		'join_us_links' => [
			'title' => 'Join Use Links',
			'join_us' => 'Join Us',
			'join_us_form' => 'Join Us Form',
			'form' => [
				'facebook' => 'Facebook',
				'instagram' => 'Instagram',
				'twitter' => 'Twitter',
				'linkedin' => 'Linkedin',
				'pinterest' => 'Pinterest',
				'youtube' => 'YouTube',
				'app_store_rider' => 'App store link to rider',
				'app_store_driver' => 'App store link to driver',
				'play_store_rider' => 'Play store link to rider',
				'play_store_driver' => 'Play store link to driver'
			]
		],
		'manage_support' => [
			'title' => 'Manage Support',
			'support' => 'Support',
			'add_support' => 'Add Support',
			'add_support_form' => 'Add Support Form',
			'edit_support' => 'Edit Support',
			'edit_support_form' => 'Edit Support Form',
			'note' => 'Note* : Please fill it with the country code.(Ex-911234567890).',
			'table' => [
				'id' => 'Id',
				'name' => "Name",
				'link' => 'Link',
				'status' => 'Status',
				'action' => 'Action',
			],
			'form' => [
				'name' => "Name",
				'link' => 'Link',
				'status' => 'Status',
				'image' => 'Image',
				'number' => 'Number'
			]
		],
		'site_setting' => [
			'title' => 'Site Settings',
			'site_settings_form' => 'Site Settings Form',
			'pool' => 'Pool Trip Only',
			'note' => 'Note : This currency must be same as your Braintree currency',
			'form' => [
				'site_name' => 'Site Name',
				'version' => 'Version',
				'header_logo' => 'Header Logo',
				'header_white_logo' => 'Header White Logo',
				'favicon' => 'Favicon',
				'timezones' => 'Timezones',
				'default_currency' => 'Default Currency',
				'payment_currency' => 'Payment Currency',
				'trip_default_payment_method' => 'Trip Default Payment Method',
				'driver_kilometer' => 'Driver Kilometer',
				'pickup_kilometer' => 'Pickup Kilo Meter',
				'drop_kilometer' => 'Drop Kilo Meter',
				'head_code' => 'Add code to the < head >(for tracking codes such as google analytics)',
				'default_language' => 'Default Language',
				'country_code' => 'Country Code',
				'manual_booking_contact_number' => 'Manual Booking Contact Number',
				'heat_map' => 'Heat Map',
				'heat_map_hours' => 'Heat Map Hours',
				'update_location_interval' => 'Update Location Interval',
				'otp_verification' => 'OTP Verification',
				'covid_feature' => 'Covid Feature',
				'driver_request_seconds' => 'Driver Request Seconds',
				'driver_request_limit' => 'Driver Request Limit',
				'pay_to_admin_driver_limit' => 'Pay to admin Driver Limit (Fixed Amount)*',
				'copyright_year' => 'Copyright Year',
				'copyright_url' => 'Copyright URL',
				'copyright_name' => 'Copyright Name',
			]
		],
		'control_panel' => 'Control Panel',
		'home' => 'Home',
		'fields_are_mandatory' => 'Fields are Mandatory',
		'submit' => 'Submit',
		'cancel' => 'Cancel',
		'add' => 'Add',
		'edit' => 'Edit',
		'reset' => 'Reset',
		'dashboard_page' => [
			'dashboard' => 'Dashboard',
			'total_earnings' => 'Total Earnings',
			'total_drivers' => 'Total Drivers',
			'total_riders' => 'Total Riders',
			'total_trips' => 'Total Trips',
			'today_earnings' => 'Today Earnings',
			'today_drivers' => 'Today Drivers',
			'today_riders' => 'Today Riders',
			'today_trips' => 'Today Trips',
			'sales_graph' => 'Sales Graph',
			'calender' => 'Calender',
			'recent_ride_requests' => 'Recent Ride Request',
			"table" => [
				'group_id' => 'Group ID',
				'rider_name' => 'Rider name',
				'dated_on' => 'Dated On',
				'status' => 'Status',
				'driver_name' => 'Driver name',
				'group_id' => 'Group ID',
			]
		],
		"manage_admin_page" => [
			'admin_users' => 'Admin Users',
			'add_admin_user' => "Add Admin User",
			'add_admin_user_form' => 'Add Admin User Form',
			'edit_admin_user' => 'Edit Admin User',
			'edit_admin_user_form' => 'Edit Admin User Form',
			'add_role' => 'Add role',
			'add_role_form' => 'Add Role Form',
			'edit_role' => 'Edit role',
			'edit_role_form' => 'Edit Role Form',
			'roles' => 'Roles',
			'table' => [
				'id' => "ID",
				'username' => 'Username',
				'email' => 'Email',
				'status' => 'Status',
				'action' => 'Action',
				'name' => 'Name',
				'display_name' => 'Display Name',
				'description' => 'Description',
			],
			'form' => [
				'name' => "Name",
				'username' => 'Username',
				'email' => 'Email Address',
				'password' => 'Password',
				'country_code' => 'Country Code',
				'mobile_number' => 'Mobile Number (for SOS purpose)',
				'role' => 'Role',
				'status' => 'Status',
				'display_name' => 'Display Name',
				'description' => 'Description',
				'permissions' => 'Permissions',
			]
		],
		"manage_company_page" => [
			'title' => 'Manage Company',
			'add_company' => 'Add Company',
			'add_company_form' => 'Add Company Form',
			'edit_company' => 'Edit Company',
			'edit_company_form' => 'Edit Company Form',
			'companies' => 'Companies',
			'form' => [
				'name' => 'Name',
				'vat_number' => 'Vat Number',
				'email' => 'Email',
				'password' => 'Password',
				'country_code' => 'Country code',
				'mobile_number' => 'Mobile Number',
				'status' => 'Status',
				'address_line' => 'Address Line',
				'city' => 'City',
				'state' => 'State',
				'postal_code' => 'Postal Code',
				'profile' => 'Profile',
				'company_commission' => 'Company Commission'
			],
			'table' => [
				'id' => 'Id',
				'name' => 'Name',
				'drivers' => 'Drivers',
				'email' => 'Email',
				'mobile_number' => 'Mobile Number',
				'status' => 'Status',
				'action' => 'Action'
			]
		],
		"manage_drivers_page" => [
			'title' => 'Manage Drivers',
			'drivers' => 'Drivers',
			'add_driver' => 'Add Driver',
			'add_driver_form' => 'Add Driver Form',
			'edit_driver' => 'Edit Driver',
			'edit_driver_form' => 'Edit Driver Form',
			'table' => [
				'id' => 'Id',
				'first_name' => 'First Name',
				'last_name' => 'Last Name',
				'company_name' => 'Company Name',
				'email' => 'Email',
				'gender' => 'Gender',
				'status' => 'Status',
				'mobile_number' => 'Mobile Number',
				'device_type' => 'Device Type',
				'created_at' => 'Created At',
				'action' => 'Action',
			],
			'form' => [
				'first_name' => 'First Name',
				'last_name' => 'Last Name',
				'password' => 'Password',
				'country_code' => 'Country Code',
				'company_name' => 'Company Name',
				'email' => 'Email',
				'gender' => 'Gender',
				'status' => 'Status',
				'mobile_number' => 'Mobile Number',
				'device_type' => 'Device Type',
				'address_line1' => 'Address Line 1',
				'address_line2' => 'Address Line 2',
				'city' => 'City',
				'state' => 'State',
				'postal_code' => 'Postal code',
				'expire_date' => 'Expire Date',
				'account_holder_name' => 'Account Holder Name',
				'account_number' => 'Account Number',
				'name_of_bank' => 'Name of Bank',
				'bank_location' => 'Bank Location',
				'code' => 'BIC/SWIFT Code',
			]
		],
		"manage_riders_page" => [
			'title' => 'Manage Riders',
			'riders' => 'Riders',
			'add_rider' => 'Add Rider',
			'add_rider_form' => 'Add Rider Form',
			'edit_rider' => 'Edit Rider',
			'edit_rider_form' => 'Edit Rider Form',
			'table' => [
				'id' => 'Id',
				'first_name' => 'First Name',
				'last_name' => 'Last Name',
				'email' => 'Email',
				'gender' => 'Gender',
				'status' => 'Status',
				'mobile_number' => 'Mobile Number',
				'device_type' => 'Device Type',
				'created_at' => 'Created At',
				'action' => 'Action',
			],
			'form' => [
				'first_name' => 'First Name',
				'last_name' => 'Last Name',
				'password' => 'Password',
				'country_code' => 'Country Code',
				'email' => 'Email',
				'gender' => 'Gender',
				'status' => 'Status',
				'mobile_number' => 'Mobile Number',
				'device_type' => 'Device Type',
				'home_location' => 'Home Location',
				'office_location' => 'Office Location'
			]
		],
		"manage_documents_page" => [
			'title' => 'Documents',
			'add_documents' => 'Add Documents',
			'add_documents_form' => ':add Documents Form',
			'edit_documents' => 'Edit Documents',
			'edit_documents_form' => ':edit Documents Form',
			'table' => [
				'id' => 'Id',
				'document_for' => 'Document For',
				'country' => 'Country',
				'document_name' => 'Document Name',
				'status' => 'Status',
				'action' => 'Action',
			],
			'form' => [
				'language' => 'Language',
				'document_for' => 'Document For',
				'country' => 'Country',
				'document_name' => 'Document Name',
				'status' => 'Status',
				'expire_on_date' => 'Expire On Date',
			]
		],
		'manage_send_message_page' => [
			'title' => 'Send Message',
			'send_message_form' => 'Send Message Form',
			'all' => 'All',
			"specific_users" => "Specific Users",
			'sms' => 'SMS',
			'push_notification' => 'Push Notification',
			'all_driver' => 'Driver',
			'all_rider' => 'Rider',
			'all_company' => 'Company',
			'all_type' => 'Rider & Driver & Company',
			'form' => [
				'to' => 'To',
				'user_type' => 'User Type',
				'message_type' => 'Message Type',
				'message' => 'Message',
			]
		],
		'manage_emails_page' => [
			'send_email' => 'Send Email',
			'send_email_form' => 'Send Email Form',
			'notes' => 'Note : Email will be sent for registered users only.',
			'email_settings' => 'Email Settings',
			'email_settings_form' => 'Email Settings Form',
			'form' => [
				'email_to' => 'Email To',
				'email_address' => 'Email Address',
				'subject' => 'Subject',
				'message' => 'Message (Salutation will be automatically added)',
				'host' => 'Host',
				'driver' => 'Driver',
				'port' => 'Port',
				'from_address' => 'From Address',
				'form_name' => 'Form Name',
				'encryption' => 'Encryption',
				'username' => 'Username',
				'password' => 'Password',
			]
		],
		'manage_manual_booking_page' => [
			"manage_bookings" => 'Manage Bookings',
			'title' => 'Manual Booking',
			'heading' => 'Manual Taxi Dispatch',
			'select_driver_availability' => 'Select Driver Availability',
			'map_zoom_level' => 'Map Zoom Level',
			'auto_assign_driver' => 'Auto Assign Driver',
			'fare_estimation' => 'Fare Estimation',
			'minimum_fare' => 'Minimum Fare',
			'base_fare' => 'Base Fare',
			'distance' => 'Distance',
			'time' => 'Time',
			'minutes' => 'Minutes',
			'peak_price' => 'Peak Price',
			'total_fare' => 'Total Fare',
			'notes' => 'Notes',
			'cancel_reason' => 'Cancel Reason',
			'booking_cancel' => 'Booking Cancel',
			'booking_cancel_reason' => 'Booking Cancel Reason',
			'cancel_by' => 'Cancel By',
			'cancelled_by' => 'Cancelled By',
			'reason' => "Reason",
			'cancel' => 'Cancel',
			'trip_cancelled' => 'Trip cancelled',
			'immediate_request' => 'Immediate Request',
			'manual_auto_booking' => [
				'title' => 'Manual Auto Booking',
				'point_1' => 'Administrator can Add / Edit Ride later booking on this page.',
				'point_2' => 'Driver current availability is not connected with booking being made.',
				'point_3' => 'Adding booking from here will not send request to Driver immediately.',
				'point_' => 'In case of "Auto Assign Driver" option selected, Driver(s) get automatic request before 5 minutes of actual booking time.',
				'point_5' => 'In case of "Auto Assign Driver" option not selected, Driver(s) get booking confirmation sms as well as reminder sms before 30 minutes of actual booking.',
				'point_6' => 'Driver has to start the scheduled Trip by going to "Your Trip" >> Upcoming section from Driver App.',
				'point_7' => 'In case of "Auto Assign Driver", the competitive algorithm will be followed.'
			],
			'manual_assign_booking' => [
				'title' => 'Manual Assign Booking',
				'point_1' => 'Please confirm future avaialbility of Driver before doing booking. ',
				'point_2' => 'Driver has to start the scheduled Trip by going to "Your Trip" >> Upcoming section from Driver App.',
			],
			'table' => [
				'company_name' => 'Company Name',
				'booked_by' => 'Booked by',
				'date' => 'Date',
				'driver_name' => 'Driver Name',
				'rider_name' => 'Rider Name',
				'pickup_location' => 'Pickup Location',
				'drop_location' => 'Drop Location',
				'trip_details' => 'Trip Details',
				'status' => 'Status',
			]
		],
		"manage_vehicle_make" => [
			'title' => 'Vehicle Make',
			'add_vehicle_make' => 'Add Vehicle Make',
			'form_title' => 'Add Vehicle Make Form',
			'edit_vehicle_make' => 'Edit Vehicle Make',
			'edit_form_title' => 'Edit Vehicle Make Form',
			'form' => [
				'status' => 'Status',
				'make' => 'Vehicle Make',
			],
			'table' => [
				'id' => 'Id',
				'status' => 'Status',
				'make' => 'Make'
			]
		],
		'manage_vehicle_model' => [
			'title' => 'Vehicle Model',
			'add_vehicle_model' => 'Add Vehicle Model',
			'form_title' => 'Add Vehicle Model Form',
			'edit_vehicle_model' => 'Edit Vehicle Model',
			'edit_form_title' => 'Edit Vehicle Model Form',
			'table' => [
				'id' => 'id',
				'make' => 'Make',
				'model' => 'Model',
				'status' => 'Status',
				'action' => 'Action',
			],
			'form' => [
				'vehicle_make' => 'Vehicle Make',
				'model' => 'Vehicle Model Name',
				'status' => 'Status',
			]
		],
		'manage_vehicle_type' => [
			'title' => 'Vehicle Types',
			'vehicles' => 'Vehicles',
			'vehicle_types' => 'Vehicle Types',
			'add_vehicle_type' => 'Add Vehicle Type',
			'form_title' => 'Add Vehicle Type Form',
			'edit_vehicle_type' => 'Edit Vehicle Type',
			'edit_form_title' => 'Edit Vehicle Type Form',
			'table' => [
				'id' => 'id',
				'vehicle_name' => 'Vehicle Name',
				'description' => 'Description',
				'is_pool' => 'Is For Pool',
				'status' => 'Status',
				'action' => 'Action',
			],
			'form' => [
				'vehicle_name' => 'Vehicle Name',
				'description' => 'Description',
				'vehicle_image' => 'Vehicle image',
				'vehicle_active_image' => 'Vehicle Active image',
				'vehicle_app_icon' => 'Vehicle Map app icon',
				'is_pool' => 'Is For Pool',
				'status' => 'Status',
			]
		],
		'manage_vehicles' => [
			'title' => 'Manage Vehicles',
			'vehicles' => 'Vehicles',
			'add_vehicles' => 'Add Vehicles',
			'edit_vehicles' => 'Edit Vehicles',
			'add_vehicle_form' => 'Add vehicle form',
			'edit_vehicle_form' => 'Edit vehicle form',
			'form' => [
				'company_name' => 'Company Name',
				'driver_name' => 'Driver Name',
				'vehicle_type' => 'Vehicle Type',
				'make' => 'Make',
				'model' => 'Model',
				'status' => 'Status',
				'default' => 'Default',
				'handicap_accessibility_available' => 'Handicap Accessibility Available',
				'child_seat_accessibility_available' => 'Child Seat Accessibility Available',
				'request_form' => 'Request Form',
				'vehicle_number' => 'Vehicle Number',
				'color' => 'Color',
				'year' => 'Year',
				'expire_date' => 'Expire Date',
				'request_form_note' => 'If the driver is male, it will be automatically selected as both.',
				'default_note' => 'If the driver has only one vehicle with active status, it will be automatically selected as default.'
			],
			'table' => [
				'id' => 'Id',
				'company_name' => 'Company Name',
				'driver_name' => 'Driver Name',
				'vehicle_type' => 'Vehicle Type',
				'make' => 'Make/Model',
				'vehicle_number' => 'Vehicle Number',
				'status' => 'Status',
				'action' => 'Action',
			]
		],
		'manage_additional_reasons' => [
			'title' => 'Additional Reasons',
			'add_additional_reason' => 'Add Additional Reason',
			'edit_additional_reason' => 'Edit Additional Reason',
			'add_title' => 'Add Additional Reason Form',
			'edit_title' => 'Edit Additional Reason Form',
			'table' => [
				'id' => 'Id',
				'reason' => 'Reason',
				'status' => 'Status',
				'action' => 'Action'
			],
			'form' => [
				'reason' => 'Reason',
				'status' => 'Status'
			]
		],
		'cancel_reasons' => [
			'title' => 'Cancel Reason',
			'add_cancel_reason' => 'Add Cancel Reason',
			'edit_cancel_reason' => 'Edit Cancel Reason',
			'add_title' => 'Add Cancel Reason Form',
			'edit_title' => 'Edit Cancel Reason Form',
			'translations' => 'Translations',
			'remove' => 'Remove',
			'add_translations' => 'Add Translations',
			'table' => [
				'id' => 'Id',
				'reason' => 'Reason',
				'cancelled_by' => 'Cancelled By',
				'status' => 'Status',
				'action' => 'Action',
			],
			'form' => [
				'language' => 'Language',
				'reason' => 'Reason',
				'cancelled_by' => 'Cancelled By',
				'status' => 'Status'
			]
		],
		'locations' => [
			'title' => 'Locations',
			'add_location' => 'Add Location',
			'edit_location' => 'Edit Location',
			'add_title' => 'Add Location Form',
			'edit_title' => 'Edit Location Form',
			'table' => [
				'id' => 'Id',
				'location_name' => 'Location Name',
				'status' => 'Status',
				'action' => 'Action'
			],
			'form' => [
				'name' => 'Name',
				'status' => 'Status'
			]
		],
		'manage_fares' => [
			'title' => 'Manage Fares',
			'add_manage_fare' => 'Add Manage Fare',
			'edit_manage_fare' => 'Edit Manage Fare',
			'add_title' => 'Add Manage Fare Form',
			'edit_title' => 'Edit Manage Fare Form',
			'peak_fare_details' => 'Peak Fare Details',
			'night_fare_details' => 'Night Fare Details',
			'table' => [
				'id' => 'Id',
				'location_name' => 'Location Name',
				'vehicle_type' => 'Vehicle Type',
				'apply_peak' => 'Apply peak',
				'apply_night' => 'Apply Night',
				'action' => 'Action',
			],
			'form' => [
				'location' => 'Location',
				'vehicle_type' => 'Vehicle Type',
				'base_fare' => 'Base Fare',
				'capacity' => 'Capacity',
				'minimum_fare' => 'Minimum Fare',
				'per_minutes' => 'Per Minutes',
				'per_kilometer' => 'Per Kilometer',
				'waiting_time_limit' => 'Waiting Time Limit (In Minutes)',
				'waiting_charges' => 'Waiting Charges (Per Minute)',
				'schedule_ride_fare' => 'Schedule Ride Fare',
				'currency_code' => 'Currency Code',
				'apply_peak_fare' => 'Apply Peak Fare',
				'apply_night_fare' => 'Apply Night Fare',
				'day' => 'Day',
				'start_time' => 'Start Time',
				'end_time' => 'End Time',
				'peak_fare' => 'Peak Fare',
				'night_fare' => 'Night Fare'
			]
		],
		'manage_trip' => [
			'manage_ride_requests' => 'Manage Ride Requests',
			'ride_requests' => 'Ride Requests',
			'manage_trips' => 'Manage Trips',
			'trips' => 'Trips',
			'request_details' => [
				'request_status' => ' Driver not yet assigned!',
				'vehicle_type' => 'Vehicle Type',
				'rider_name' => 'Rider Name',
				'driver_name' => 'Driver Name',
				'company_name' => 'Company Name',
				'pickup_address' => 'Pickup Address',
				'drop_address' => 'Drop Address',
				'ride_start_time' => 'Ride Start Time',
				'ride_end_time' => 'Ride End Time',
				'ride_status' => 'Ride Status'
			],
			'table' => [
				'id' => 'Id',
				'request_id' => 'Request Id',
				'rider_name' => 'Rider Name',
				'driver_name' => 'Driver Name',
				'earned' => 'Earned',
				'pickup_location' => 'Pickup Location',
				'drop_location' => 'Drop Location',
				'date_and_time' => 'Date and Time',
				'status' => 'Status',
				'amount' => 'Amount',
				'trip_date' => 'Trip Date',
				'company_name' => 'Company Name',
				'vehicle_details' => 'Vehicle Details',
				'payment_mode' => 'Payment Mode',
				'payment_status' => 'Payment Status',
				'action' => 'Action',
				'reason' => 'Reason',
				'comments' => 'Comments',
				'cancelled_by' => 'Cancelled By',
				'cancel_at' => 'Cancel At',
				'time_fare' => 'Time Fare',
				'distance_fare' => 'Distance Fare',
				'base_fare' => 'Base Fare',
				'is_pool' => '2nd Rider Amount(Pool)',
				'tips' => 'Tips',
				'additional_fee' => 'Additional Fee',
				'access_fee' => 'Access Fare',
				'admin_commission' => 'Admin Commission',
				'total_fare' => 'Total Fare',
				'earnings' => 'Earnings',
				'car_name' => 'Car Name',
				'trip_number' => 'Trip Number',
				'driver_rating' => 'Driver Rating',
				'rider_rating' => 'Rider Rating',
				'rider_comments' => 'Rider Comments',
				'driver_comments' => 'Driver Comments',
			]
		],
		'manage_owe_amounts' => [
			'title' => 'Manage :title',
			'owe_amount' => 'Owe Amount',
			'table' => [
				'id' => 'Id',
				'company_id' => 'Company ID',
				'company_name' => 'Company Name',
				'trip_ids' => 'Trip Ids',
				'owe_amount' => 'Owe Amount',
				'remaining_owe_amount' => 'Remaining Owe Amount',
				'action' => 'Action',
				'driver_id' => 'Driver Id',
				'driver_name' => 'Driver Name',
			]
		]
	],
	'home' => [
		'title' => 'Book Rides Anywhere',
		'desc' => 'Enter the pick up and drop location and enjoy the ride affordably.',
		'drivedesc' => 'Start driving with :site_name, with exclusive rewards and earnings. Convenient at its best.',
		'drive_you1' => 'Book  For Your Immediate Cab',
		'goals1' => ' No matter the timing is, the user can book your ride at the convenient cab type either SUV, Sedan or others to start your ride at doorstep. ',
		'siginup' => 'Sign Up',
		'or' => 'Or',
		'siginup_drive' => 'Sign up to drive',
		'siginup_company' => 'Sign up to company',
		'company' => 'Company',
		'company_history' => 'Find everything you need to track your success on the company.',
		'company_signin' => 'COMPANY SIGN IN',
		'company_signup' => 'COMPANY SIGN UP',
		'become_company' => 'BECOME A COMPANY',
		'rider_acnt' => 'with your rider account.',
		'aggrement' => 'By proceeding, I agree that',
		'easy_way' => 'Easiest way around',
		'easy_content' => 'One tap and a car comes directly to you. Hop in—your driver knows exactly where to go. And when you get there, just step out. Payment is completely seamless.',
		'anywhere' => 'Anywhere, anytime',
		'anywhere_content' => 'Daily commute. Errand across town. Early morning flight. Late night drinks. Wherever you’re headed, count on for a ride—no reservations required.',
		'lowcost' => 'Low-cost to luxury',
		'lowcost_content' => 'Economy cars at everyday prices are always available. For special occasions, no occasion at all, or when you just a need a bit more room, call a black car or SUV.',
		'reason' => 'Reasons to ride',
		'drive_you' => 'Drive when you want',
		'you_need' => 'Make what you need',
		'drive_with' => 'Driving with',
		'goals' => ' is flexible and rewarding, helping drivers meet their career and financial goals.',
		'suprt' => 'Support for drivers affected by the immigration ban',
		'provide' => 'We’re providing access to 24/7 legal support for drivers impacted by the ban and financial assistance for drivers stranded abroad.',
		'now_arrive' => 'Now Arriving',
		'safe' => 'Safe and modern cities',
		'helping' => 'Helping cities thrive',
		'city_with' => 'A city with',
		'city_with_content' => 'gives people more ways to make money, has fewer drunk drivers on the road, and provides transportation anywhere, anytime.',
		'safe_ride' => 'Safe rides for everyone',
		'backseat' => 'Whether riding in the backseat or driving up front, every part of the',
		'designed' => 'experience is designed around your safety and security.',
		'fare' => 'fare estimator',
		'how_much' => 'How much does ',
		'cost' => 'cost in your city? Calculate a fare estimate for your next trip. Simply enter a pickup location and destination to get started.',
		'get_started' => 'Get Started',
		'invalid_mobile_no' => 'Invalid mobile number. Please try again.',
		'field_is_required' => 'is required',
	],

	'help' => [
		'welcome' => 'Welcome! How can we help?',
		'search_anything' => 'Search for anything',
		'help_center' => 'Help Center',
		'suggested_helps' => 'Suggested Helps List',
		'no_suggested_helps' => 'No Suggested Helps!',
		'no_results_found' => 'No Results Found',
		'back' => 'Back',
	],

	'footer' => [
		'siginup_ride' => 'Sign Up to Ride',
		'driver' => 'Become A Driver',
		'ride' => 'Ride',
		'drive' => 'Drive',
		'rider_app' => 'Rider App',
		'driver_app' => 'Driver App',
		'safety' => 'Safety',
		'using_cookies' => 'Cookies: :site_name uses cookies to improve user experience. By using our website you consent to our cookies in accordance with our',
	],
	'header' => [
		'profile' => 'Your Profile',
		'profil' => 'Profile',
		'credit_card' => 'Add Credit Card',
		'verify_email' => 'Verify Email',
		'mytrips' => 'My Trips',
		'payment' => 'Payment',
		'logout' => 'Log Out',
		'invoice' => 'Invoice',
		'signin' => 'Sign In',
		'location' => 'Kochi',
		'use_location' => 'We use your location to customize the information you see.',
		'chng_location' => 'CHANGE LOCATION',
		'back' => 'Back',
		'require' => 'Requirements',
		'app' => 'Driver App',
		'area' => 'Not in Kochi? Please enter your location to help us display the correct information for your area.',
		'how_it_works' => 'How it Works',
		'menu' => 'Menu',
		'help' => 'Help',
	],
	'dashboard' => [
		'trip_invoice' => 'Trip Invoices',
		'invoice_no' => 'Invoice Number',
		'trip_date' => 'Trip Date',
		'invoice' => 'Invoice',
		'invoice_issued' => 'Invoice issued by ',
		'behalf' => 'on behalf of:',
		'date' => 'Date',
		'desc' => 'Description',
		'net_amt' => 'Net Amount',
		'payment_mode' => 'Payment Mode',
		'base_fare' => 'Base Fare',
		'distance_fare' => 'Distance Fare',
		'time_fare' => 'Time Fare',
		'total_fare' => 'Total Trip Fare',
		'admin_amt' => 'Admin\'s Amount',
		'owe_amt' => 'Owe Amount',
		'driver_payout' => 'Driver Payout',
		'cash_collect' => 'Cash Collected',
		'total_payout' => 'Total Payout',
		'access_fee' => 'Access Fee',
		'wallet_amt' => 'Wallet Amount',
		'promo_amt' => 'Promo Amount',
		'paid_amt' => 'Paid Amount',
		'payment_methods' => 'Payment Methods',
		'personal_cash' => 'Personal Cash',
		'personal_paytm' => 'Personal Paytm',
		'promotions' => 'Promotions',
		'apply' => 'Apply',
		'no_active' => 'No Active Promotions',
		'gratuity' => 'Gratuity for TAXI',
		'preferred' => 'Your preferred gratuity will be applied to any future TAXI trips that you request through ',
		'taxi' => 'This will apply to TAXI fares only (not Black, SUV, or ',
		'paid' => 'and be paid to your driver. Gratuity only applies in certain countries.',
		'taxi_gratuity' => 'TAXI Gratuity',
		'save' => 'Save',
		'dwnld_invoice' => 'Download invoices for trips made by you and your drivers. Please note that fares are subject to adjustments by ',
		'feedback' => 'based on client feedback. Your invoices will reflect those adjustments.',
		'download' => 'Download',
		'print' => 'Print',
		'pdf' => 'PDF',
		'no_details' => 'No Details Found',
		'schedule_fare' => 'Schedule Fare',
		'peak_fare' => 'Peak Fare',
		'upload_file' => 'UPLOADED',

	],
	'profile' => [
		'general' => 'General Information',
		'location' => 'Location',
		'mobile' => 'Mobile',
		'email' => 'Email Address',
		'profile_photo' => 'Profile Photo',
		'filter' => 'Filter Trips',
		'timeframe' => 'Timeframe',
		'pickup' => 'Pickup',
		'driver' => 'Driver',
		'rider' => 'Rider',
		'fare' => 'Fare',
		'car' => 'Car',
		'inactive_user' => 'Your have successfully submitted to delete your account.',
		'view_detail' => 'View Detail',
		'your_trip' => 'Your Trip',
		'dwnld_invoice' => 'Download Invoice',
		'kilometer' => 'Kilometers',
		'trip_time' => 'Trip Time',
		'rode_with' => 'Rode With',
		'phone' => 'Phone',
		'addr' => 'Address',
		'profile_city' => 'City',
		'state' => 'State',
		'country' => 'Country',
		'profile_postal_code' => 'Postal Code',
		'fare_break' => 'FARE BREAKDOWN',
		'you_rode' => 'You rode with',
		'track_every' => 'Find everything you need to track your success on the road.',
		'driver_signin' => 'Driver sign in',
		'driver_signup' => 'Driver sign Up',
		'trip_history' => 'Manage your payment options, review trip history, and more.',
		'rider_signin' => 'Rider sign in',
		'rider_signup' => 'Rider sign up',
		'name' => 'Name',
		'gender' => 'Gender',
		'male' => 'Male',
		'female' => 'Female',
		'phone_number' 	=> 'Phone Number',
		'change'		=> 'Change',
		'payment_method' => 'Payment Method',
	],

	'drive' => [
		'start_drive_with' => 'Start driving with',
		'works_first' => 'Work that puts you first',
		'drive_you_need' => 'Drive when you want, earn what you need',
		'own_schedule' => 'Set your own schedule',
		'drive_with' => 'You can drive with',
		'anytime' => 'anytime, day or night, 365 days a year. When you drive is always up to you, so it never interferes with the important things in your life.',
		'every_turn' => 'Earn more at every turn',
		'fare_start' => 'Trip fares start with a base amount, then increase with time and distance. And when demand is higher than normal, drivers earn more.',
		'app_lead' => 'Let the app lead the way',
		'tap_go' => 'Just tap and go. You’ll get turn-by-turn directions, tools to help you earn more, and 24/7 support. And if you don’t have a smartphone, we can connect you to one.',
		'hit_road' => 'Hit the road',
		'easy_started' => 'It’s easy to get started',
		'sign_online' => 'Sign up online',
		'about_yourself' => 'Tell us a little about yourself and your car. Vehicle requirements vary by region, so we’ll show you what’s needed for your city.',
		'share_doc' => 'Share some documents',
		'upload_license' => 'Just upload your license, registration, proof of insurance, and the necessary information to start a driver screening.',
		'get_app' => 'Get the app and go',
		'approve_drive' => 'Once you’re approved to drive with',
		'provide_you_need' => 'as an independent contractor, we’ll provide everything you need to be a success on the road.',
		'signup_now' => 'SIGN UP NOW',
		'about_app' => 'About the app',
		'design_drivers' => 'Designed just for drivers',
		'make_money' => 'When you want to make money, just open the app and you’ll start to receive trip requests. You’ll get information about your rider and directions to their location and destination. When the trip is over, you’ll receive another nearby request. And if you\'re ready to get off the road, you can sign off at any time.',
		'safety_screen' => 'Know you’re ready to hit the road. Whether you’re driving your own car or a commercially-licensed vehicle, you must meet the minimum requirements and complete a safety screening online.',
		'rewards' => 'Rewards',
		'drive_seat' => 'You’re in the driver’s seat. So reward yourself with discounts on fuel, vehicle maintenance, cell phone bills, and more. Reduce your daily expenses and take home extra earnings by driving more.',
		'vehicle_solution' => 'Vehicle solutions',
		'need_car' => 'Need a car? We can connect you to partners who offer exclusive vehicle deals that can get you on the road and earning. Many offer no mileage caps and flexible return policies so you can drive and earn as much as you want.',
		'you_with' => 'When you drive with',
		'support' => 'you get 24/7 driver support and insurance coverage. And all riders are verified with their personal information and phone number, so you’ll know who you’re picking up and so will we.',
		'making_money' => 'Start making money',
		'ready_money' => 'Ready to make money? The first step is to sign up online.',
		'support' => 'Support at every turn',
		'we_want' => 'We want every',
		'hassle_free' => 'trip to be hassle-free. So we’re here to help with account setup, fare adjustments, and more whenever you need it.',
		'safety_behind' => 'Safety behind the wheel',
		'out_commitment' => 'Our commitment to drivers',
		'keeping_safe' => 'is dedicated to keeping people safe on the road. Our technology enables us to focus on driver safety before, during, and after every trip.',
		'before_trip' => 'Before the trip',
		'picking_up' => 'Picking up passengers',
		'anonymous_pickup' => 'No anonymous pickups',
		'riders_account' => 'All riders must create an account and provide their name, email address, and phone number before they can request a ride. So when you accept a request, you’ll know who you’re picking up and so will we.',
		'sub_number' => 'Substitute phone numbers',
		'location_around_world' => 'In many locations around the world,',
		'stays_private' => 'uses technology that anonymizes phone numbers to keep contact details confidential. So when you and your rider need to contact each other, your personal information stays private.',
		'on_trip' => 'On Trip',
		'getting_destination' => 'Getting to the destination',
		'app_navigation' => 'In-app navigation',
		'riders_enter' => 'When riders enter their destination, you will automatically receive turn-by-turn directions in the app—so you can focus on getting there safely.',
		'on_the_map' => 'Always on the map',
		'gps_data' => 'GPS data is logged for every trip so we know who you’re driving and where you’re going, which promotes accountability and encourages good behavior.',
		'after_trip' => 'After the Trip',
		'improving' => 'Always improving the',
		'experience' => 'experience',
		'no_change' => 'No change, no hassle',
		'fares_atuo' => 'Fares automatically charge the rider’s payment method on file, so for most trips you can avoid using cash altogether. But if a rider pays in cash, the app automatically issues credit so you’ll never have to make change.',
		'driver_feedback' => 'Driver feedback',
		'rate_your_driver' => 'You rate your rider after every trip. We review those ratings to ensure that everyone you pick up is as respectful as you are. Riders reported to violate our terms of service may be prevented from using ',
		'drive_safely' => 'Drive safely with',
		'information' => 'The information provided on this web page is intended for informational purposes only and may not be applicable in your country, region, or city. It is subject to change and may be updated without notice.',
		'drivers_first' => 'Putting drivers first',
		'exp_around' => 'An experience built around you',
		'control_with' => 'You’re in control with',
		'app_for_drivers' => 'The app for drivers is designed with features that help you decide how, where, and when you earn.',
		'going_online' => 'Going online',
		'always_avail' => 'is always available. So whenever you’re ready to drive, open the app and tap Go Online.',
		'accept_trip_request' => 'Accepting trip requests',
		'receive_trip_request' => 'Once online, you’ll automatically begin to receive trip requests in your area. Your phone will beep and the screen will flash—tap to accept.',
		'turn_by_turn' => 'Turn-by-turn directions',
		'provides_navigation' => 'The app provides navigation to your rider’s pickup location, and we’ll let them know when you’re almost there. Once the trip has begun, you’ll get directions to their destination.',
		'track_earnings' => 'Track your earnings',
		'summaries' => 'After every trip, you’ll see exactly how much you earned and comprehensive summaries of your day’s total. Earnings automatically transfer to your bank account every week, or you can cash out instantly up to 5 times a day.',
		'rating' => 'Ratings system',
		'rider_driver_rate' => 'Ratings are a two-way street. Riders and drivers rate each other after every trip to ensure that only respectful, courteous people are allowed on the',
		'platform' => 'platform.',
		'communication' => 'Communication',
		'feedback_success' => 'Feedback for success',
		'stay_informed' => 'Stay informed',
		'customized_updates' => 'Get customized updates about local events and promotions in your city, and tips on how to deliver the best',
		'rider_comment' => 'Rider comments',
		'rating_section' => 'Use the ratings section to hear what people love about their 5-star trips and find out why riders give low ratings so you can decide how to adjust accordingly.',
		'start_drive_now' => 'Start driving now',
		'start_drive_nowive' => 'Drive with',
		'earn_your_terms' => 'and earn on your own terms.',
		'already_signed_up' => 'Already signed up?',
		'invite_friends' => 'Invite your friends to try',
		'you_earn' => 'and you’ll earn extra when they hit the road.',
		'info_page' => 'The information provided on this web page is intended for informational purposes only and may not be applicable in your country, region, or city. It is subject to change and may be updated without notice.',
		'driver_requirments' => 'Driver requirements',
		'how_to_drive' => 'How to drive with',
		'own_boss' => 'is a great way to be your own boss and earn great money. From a commercial license to a car,',
		'help_you_every' => 'can help you every step of the way.',
		'min_requirments' => 'Minimum requirements',
		'commercial_license' => 'To drive in New York City, you’ll need a commercial license from the NYC TLC (Taxi and Limousine Commission) and a commercially licensed vehicle.',
		'help_you_both' => 'can help you with both.',
		'what_you_need' => 'Here’s what you’ll need:',
		'driver_license' => 'A valid US driver’s license',
		'tlc_license' => 'A TLC driver’s license',
		'tlc_license_vehicle' => 'A TLC-licensed vehicle (you can rent one or register your own)',
		'require_documents' => 'Required documents',
		'addition_documents' => 'In addition to the requirements above, you’ll also need the following documentation:',
		'proof_insurance' => 'Proof of commercial insurance',
		'proof_vehicle_registration' => 'Proof of commercial vehicle registration',
		'vehicle_permit' => 'A TLC-for-hire vehicle permit',
		'ready_make_money' => 'Ready to make money?',
		'first_step' => 'The first step is to sign up',
	],

	'driver_dashboard' => [

		'vehicle_status' 	=> 'Vehicle Status',
		'vehicle_add' 		=> 'Add',

		'add_vehicle' => 'Add Vehicle',
		'make' => 'Make',
		'model' => 'Model',
		'year' => 'Year',
		'license_plate' => 'License plate',
		'vehicle_color' => 'Vehicle Color',
		'reupload' => 'RE-UPLOAD DOCUMENTS',
		'make_year' => '2015',
		'make_company' => 'Tata',
		'make_product' => 'Indica',
		'reg_no' => 'TN22DA0103',
		'type' => 'VIN',
		'upload_documents' => 'Upload Document: Driver\'s License - (Back/Reverse)',
		'select_file' => 'Select File and Upload',
		'contract_carriage' => 'Upload Document: Contract Carriage Permit',
		'back_profile' => 'Back to Profile',
		'driver_license_back' => 'Driver’s License - (Back/Reverse)',
		'upload' => 'Upload',
		'driver_license_front' => 'Driver’s License - (Front)',
		'motor_insurance' => 'Motor Insurance Certificate',
		'reg_certificate' => 'Certificate of registration',
		'carriage_permit' => 'Contract Carriage Permit ',
		'upload_driver_license' => 'Upload Document: Drivers License - (Back/Reverse)',
		'banking_details' => 'Banking Account Details',
		'payment_details' => 'Payments Details are invaild',
		'weekly_payout' => 'Set to receive weekly payout',
		'ifsc' => 'IFSC Code',
		'ifsc_code' => 'KVBL00016',
		'bank' => 'Bank Name',
		'bank_name' => 'KARUR VYSYA BANK',
		'account' => 'Bank Account Number',
		'account_no' => 'xxxxxxxxxxxx40',
		'account_name' => 'Account holder name (exactly as it looks on your bank statement)',
		'driver_address' => 'Address',
		'address' => 'Kk Nagar',
		'driver_city' => 'City',
		'city' => 'Chennai',
		'driver_postal_code' => 'Postal Code',
		'postal_code' => '600078',
		'driver_dob' => 'Date of birth',
		'dob' => '2015-06-10',
		'under_req_age' => 'Under required age',
		'download_invoice_driver' => 'Download invoices for trips made by you and your drivers. Please note that fares are subject to adjustments by  based on client feedback. Your invoices will reflect those adjustments.',
		'client_feedback' => 'based on client feedback. Your invoices will reflect those adjustments.',
		'total_earnings' => 'Total Earnings',
		'pay_period' => 'PAY PERIOD',
		'current_statement' => 'Current Statement',
		'all_statement' => 'See all Statement',
		'completed_trips' => 'Completed Trips',
		'acceptance_rate' => 'Acceptance Rate',
		'cancelled_trips' => 'Cancelled Trips',
		'daily_earnings' => 'Daily Earnings',
		'status' => 'Status',
		'all_trips' => 'All Trips',
		'pickup_time' => 'Pickup Time',
		'vehicle' => 'Vehicle',
		'duration' => 'Duration',
		'distance' => 'Distance(km)',
		'add_photo' => 'Add Photo',
		'manage_documents' => 'Manage Documents',
		'driver_documents' => 'Driver Documents',
		'vehicle_documents' => 'Vehicle Documents',
		'select_upload' => 'Select file and upload',
		'Active'			=> 'Active',
		'Inactive'			=> 'Inactive',
		'Pending'			=> 'Pending',
		'Car_details'		=> 'Car Details',
		'Document_details'	=> 'Document Details',

		'edit' => 'Edit',
		'set_as_default' => 'Set as default',
		'delete' => 'Delete',
		'vehicle_details' => 'Vehicle Details',
		'vehicle_make' => 'Vehicle Make',
		'vehicle_model' => 'Vehicle Model',
		'vehicle_number' => 'Vehicle Number',
		'vehicle_color' => 'Vehicle Color',
		'vehicle_year' => 'Vehicle Year',
		'vehicle_type' => 'Vehicle Type',
		'default_vehicle_inactive_error' => 'Selected vehicle is Inactive. So you can\'t set Default vehicle',
		'default_vehicle_intrip_error' => 'Default vehicle already in trip, so you couldn\'t set this vehicle as default',
		'default_success_msg' => 'Default vehicle has updated successfully',
		'select' => 'Select',

		'handicap' => 'Handicap',
		'child_seat' => 'Child Seat',
		'request_from' => 'Request From',
		'both' => 'Both',
		'yes' => 'Yes',
		'no' => 'No',
		'available' => 'Available',
	],
	'errors' => [
		'unauthorize' => 'Unauthorized action.',
		'content_block' => 'The content you requested cannot be found.',
		'oops' => 'Oops!',
		'cannot_find' => 'We can\'t seem to find the page you\'re looking for.',
		'be_right_back' => 'Be Right Back',
	],
	'ride' => [
		'ride_with_Ridein' => 'Start riding with :site_name',
		'how_works' => 'How :site_name works',
		'request' => 'Request',
		'request_content' => 'Tap each delivery option to see wait time,  sizes and price. Chose a flat fee of $30 Pick up Truck, $40 Flat Bed Truck, $50 Box Truck in your county. Then enter your pickup location and tap request—your driver will arrive in minutes.',
		'delivery' => 'Deliverys',
		'delivery_content' => 'Your driver comes to you. You’ll see your driver’s contact information and vehicle details in the app, so you know you’re getting in the right car.',
		'pay_go' => 'Pay and go',
		'pay_go_content' => 'Hop out and rate your driver when you reach your destination. We automatically charge the credit card on file, so you never need cash.',
		'faq' => 'FAQs',
		'what_expect' => 'What to expect along the way',
		'make_reserve' => 'Can I make a reservation?',
		'make_reserve_content' => 'on-demand service is available in every city we operate in. When you’re ready to ride, use your app to request pickup from a nearby driver. Demand for rides can fluctuate at different times of day and night. A high demand for rides at a certain time can impact how quickly a driver accepts your trip request and heads to your pickup location. If you’re on a tight schedule, we recommend checking the your pickup location’s ETA for different vehicle options about 15-30 minutes before you’re ready to ride. :site_name in some cities now includes the option to schedule an :site_nameX ride. Here’s how :site_name',
		'schedule_ride' => 'Tap the SCHEDULE A RIDE button above the vehicle option slider.',
		'select_date' => 'Select a date and preferred 15-minute window of time when you will be ready for pickup.',
		'select_pickup_location' => 'Enter your pickup location and destination.',
		'review_fare' => 'Review your fare estimate and tap SCHEDULE.',
		'after_confirm' => 'Tap SCHEDULE TRIP to confirm. After confirming, select TRIPS from your app menu, then select UPCOMING to review upcoming scheduled trips or schedule a new trip. If you need to cancel a scheduled trip, tap CANCEL. When the date and time you scheduled a trip for approach, nearby drivers will receive your ride request. The driver who accepts this trip request may arrive at your pickup location at any time within your 15-minute window. We recommend being ready and available for pickup for the full duration of time. A driver who cannot locate you at the pickup location may cancel the ride after 5 minutes. Please note that surge pricing may apply to a scheduled trip. This can impact your trip fare. Check out the link below to see where scheduled rides is available near you.',
		'do_i_need' => 'Do I need to tip?',
		'do_i_need_content' => 'The :site_name app cannot include a tip when billing you for a trip fare. Where available as a vehicle option, :site_name is an exception. In most cities, :site_name is a cashless experience. Tipping is voluntary. Tips are not included in the fare, nor are they expected or required. As a rider, you are not obligated to offer your driver a gratuity in cash. If you decide you would like to tip, your driver is welcome to accept.',
		'cancel_request' => 'Cancelling my request',
		'cancel_request_content' => 'Ride requests should only be made when you’re ready to ride and near the pickup location. This enables drivers to operate efficiently on the :site_name platform. Sometimes you may wish to cancel a ride request after it has been accepted by a driver. While the :site_name app allows you to cancel anytime, a cancellation fee may be charged. This fee is intended to compensate driver-partners for time and effort spent heading toward a pickup location. A ride request can be cancelled free of charge after your initial request. If your driver is running more than 5 minutes behind the provided ETA, you can cancel the ride request without incurring a cancellation fee. On :site_name trips, you may be charged a $2 cancellation fee if you cancel anytime a driver accepts your ride request. I was charged a cancellation fee. We’re happy to review and make adjustments as necessary.',
		'start_riding' => 'Start riding',
		'start_riding_content' => 'You’ve got places to be. Leave your keys at home and request a ride.',
		'already_have_account' => 'Already have an account?',
		'invite' => 'Invite your friends to :site_name give a spin.',
		'always_ride' => 'Always the ride you want',
		'get_whatever' => 'The best way to get wherever you’re going',
		'tap_button' => 'Tap a button, get a ride',
		'tap_button_content' => 'Choose your ride and set your location. You’ll see your driver’s picture and vehicle details, and can track their arrival on the map.',
		'always_on' => 'Always on, always available',
		'always_on_content' => 'No phone calls to make, no pick-ups to schedule. With 24/7 availability, request a ride any time of day, any day of the year.',
		'we_listen' => 'You rate, we listen',
		'we_listen_content' => 'Rate your driver and provide anonymous feedback about your trip. Your input helps us make every ride a 5-star experience.',
		'every_price' => 'There’s a ride for every price',
		'any_occasion' => 'And any occasion',
		'economy' => 'Economy',
		'premium' => 'Premium',
		'accessibility' => 'Accessibility',
		'start_finish' => 'From start to finish, a ride you can trust',
		'your_safety' => 'Your safety is important to us before, during, and after every trip. That’s why we continue to develop technology that helps make millions of rides safer every day.',
		'keep_safe' => 'HOW WE KEEP YOU SAFE',
		'your_first' => 'Your first',
		'min_away' => 'is minutes away',
		'business_travel' => 'Business Travel',
		'trip_seperate' => 'Keep work trips separate',
		'trip_seperate_content' => 'Whether you’re headed to the airport, a meeting across town, or home after a late night at the office,',
		'hard_as' => 'works just as hard as you do.',
		'pool' => 'POOL',
		'share_save' => 'Share your ride and save',
		'pool_content' => 'POOL matches you with riders headed in the same direction. It’s always the cheapest way to',
		'ride_adds' => 'And sharing the ride adds only a few minutes to your trip.',
		'airport' => 'Airports',
		'shuttle' => 'Skip the airport shuttle',
		'shuttle_content' => 'Request a ride on-demand at over 400 airports across the globe. And with multiple vehicle options, there\'s plenty of room for all your luggage.',
		'trip_safety' => 'Trip safety',
		'commitment_riders' => 'Our commitment to riders',
		'people_safe' => 'is dedicated to keeping people safe on the road. Our technology enables us to focus on rider safety before, during, and after every trip. Here\'s how.',
		'getting_safe_ride' => 'Getting a safe ride',
		'safe_pickups' => 'Safe pickups',
		'find_location' => 'app automatically finds your location to provide door-to-door service. That means you stay safe and comfortable wherever you are until your driver arrives.',
		'open_everyone' => 'Open to everyone, everywhere',
		'request_blindly' => 'All ride requests are blindly matched with the closest available driver. So there is no discrimination based on race, gender, or destination.',
		'driver_profile' => 'Driver Profiles',
		'driver_profile_content' => 'When you’re matched with a driver, you’ll see their name, license plate number, photo, and rating—so you know who’s picking you up ahead of time. And even after the trip, you’re able to contact your driver if you left something behind.',
		'destination' => 'Getting to your destination',
		'eta' => 'Share your ETA',
		'eta_content' => 'Once your driver has picked you up, share your ETA with your friends and family so they can follow your route and know when to expect you.',
		'follow_trip' => 'Follow your trip in real-time so you always know where you are. And if you use',
		'follow_trip_content' => 'POOL, you’ll know exactly who’s riding with you.',
		'always_here' => 'Always here for you',
		'anonymous_feedback' => 'Anonymous feedback',
		'anonymous_feedback_content' => 'After every trip, you can rate the driver and provide anonymous feedback about your ride. We review all feedback because our goal is to make every ride a great experience.',
		'support_head' => '24/7 support',
		'support_head_content' => 'Our support team is always ready to respond to any questions you may have about your trip and help you retrieve lost items.',
		'rapid_response' => 'Rapid response',
		'rapid_response_content' => 'Our specially-trained incident response teams are available around the clock to handle any urgent concerns that arise.',
		'work_event' => '“I work events late at night, and with ',
		'feel_safer' => 'I feel safer knowing I don’t have to go wait outside and hope I can flag down a ride.”',
		'feel_safer_name' => 'Brittany,',
		'rider_from' => 'Rider from Portland',
		'app_offline' => 'In the App and Offline',
		'imporving_experience' => 'Improving experiences with technology',
		'sub_phone_number' => 'Substitute phone numbers',
		'use_technology' => 'uses technology that anonymizes phone numbers to keep contact details confidential. So when you and your driver need to contact each other, your personal information stays private.',
		'assisting' => 'Assisting law enforcement',
		'assisting_content' => 'In cases where local law enforcement provides us with valid legal process, we provide them with useful data to help in their investigations.',
		'rider_safety' => 'Rider safety tips',
		'how_keep_safe' => 'How to keep yourself safe',
		'how_keep_safe_content' => 'We worked with law enforcement to create this guide on how to ride safely with',
		'safe_while' => 'It explains what you can do to stay safe while riding.',
		'safer_ride' => 'Get a safe ride with',
	],
	'user' => [
		'disabled' => 'Account Disabled',
		'protect' => 'To help protect your information, we\'ve temporarily disabled your account. Please email us to continue.',
		'email_us' => 'Email Us',
		'vehicle_info' => 'Enter your vehicle information',
		'vehicle_name' => 'Vehicle Name / eg: Toyoto Camry,Honda Accord...',
		'vehicle_number' => 'Vehicle Number / eg: WNF 382',
		'vehicle_type' => 'Choose your vehicle type',
		'continue' => 'Continue',
		'forgot_paswrd' => 'Forgot Password',
		'next' => 'Next',
		'no_account' => 'Don\'t have an account?',
		'reset_paswrd' => 'Please reset your password,',
		'continue_with' => 'Continue with Facebook',
		'continue_with_google' => 'Continue with Google',
		'continue_with_apple' => 'Continue with Apple',
		'need_partner' => 'needs partners like you.',
		'need_partner_content' => 'and earn great money as an independent contractor. Get paid weekly just for helping our community of riders get rides around town. Be your own boss and get paid in fares for driving on your own schedule.',
		'correct' => 'Please correct the following:',
		'create_account' => 'Create a New Account',
		'proceed' => 'By proceeding, I agree that',
		'contact' => 'or its representatives may contact me by email, phone, or SMS (including by automated means) at the email address or number I provide, including for marketing purposes.',
		'money_make' => 'Make good money.',
		'money_make_content' => 'Got a car? Turn it into a money machine. The city is buzzing and :site_name makes it easy for you  to cash in on the action. Plus, you\'ve already got everything you need to get started.',
		'drive_when_want' => 'Drive when you want.',
		'drive_when_want_content' => 'Need something outside the 9 to 5? As an independent contractor with',
		'imp_moments' => 'you’ve got freedom and flexibility to drive whenever you have time. Set your own schedule, so you can be there for all of life’s most important moments.',
		'no_office' => 'No office, no boss.',
		'no_office_content' => 'Whether you’re supporting your family or saving for something big,',
		'freedom' => 'gives you the freedom to get behind the wheel when it makes sense for you. Choose when you drive, where you go, and who you pick up.',
		'safe_reliable' => 'Safe, reliable rides in minutes',
		'promo' => 'Promo Code',
		'clicking_terms' => 'By clicking "Sign Up", you agree to ',
		'terms' => '\'s Terms and Conditions',
		'and' => 'and',
		'privacy' => 'Privacy Policy',
		'submit' => 'SUBMIT',
		'firstname' => 'FirstName',
		'lastname' => 'LastName',
		'email' => 'Email',
		'mobile' => 'Mobile',
		'paswrd' => 'Password',
		'drive_with_Ridein' => 'Drive With',
		'ride_with' => 'Ride With',
		'update' => 'Update',
		'email_address' => 'Email or Mobile number',
		'mobile_no' => 'The Mobile Number should be minimum 6 characters',
		'disabled_account' => 'The user has been disabled',
		'disabled_company_account' => 'The company has been disabled',
		'no_recognize' => 'This mobile number can\'t be recognized by ',
		'no_recognize_email' => 'This email can\'t be recognized by :site',
		'no_paswrd' => 'The password you’ve entered is incorrect.',
		'link' => 'We have sent a link to reset your password to ',
		'mobile_no_exists' => 'Mobile number already exists',
		'email_exists' => 'Email already exists',
		'register_successfully' => 'Registered Successfully',
		'login_failed' => 'Log In Failed. Please Check Your Email/Password.',
		'google_login_failed' => 'Log In Failed.',
		'country_code' => 'Country Code',
		'user_type' => 'User Type',
		'veh_name' => 'Vehicle Name',
		'veh_no' => 'Vehicle Number',
		'veh_type' => 'Vehicle Type',
		'token' => 'Token has Expired.',
		'invalid_token' => 'Invalid Token.',
		'new_paswrd' => 'New Password',
		'cnfrm_paswrd' => 'Confirm Password',
		'pswrd_chnge' => 'Password has Successfully Changed.',
		'profile_image' => 'Profile Image',
		'license_image' => 'Could not upload license Image',
		'update_success' => 'Updated Successfully',
		'update_fail' => 'Could not upload Profile Image',
		'invalid_file_type' => 'Invalid file type. Only  JPG, GIF and PNG types are accepted.',
		'insurance_image' => 'Could not upload Insurance Image',
		'rc_image' => 'Could not upload Rc book Image',
		'permit_image' => 'Could not upload Permit Image',
		'add_success' => 'Added Successfully',
		'rc_book' => 'Rc Book',
		'insurance' => 'Insurance',
		'permit' => 'Permit',
		'begin_trip' => 'Begin Trips',
		'end_trip' => 'End Trip',
		'email_mobile' => 'Enter your Email or Mobile Number',
		'service_not_available_country' => 'Service is not Available for selected country',
		'active_message' => 'Your profile has been activated',
		'pending_message' => 'Please wait until get approval from admin for car or document details',
		'car_details_message1' => 'Please upload your vehicle details',
		'car_details_message2' => 'Please upload your vehicle document details',
		'document_details_message' => 'Please upload your driver document details',
		'inactive_message' => 'Your profile has been deactivated',
		'default_vehicle_delete_msg' => 'Default vehicle can\'t be deleted',
		'delete_success' => 'Deleted Successfully',
		'vehicle_not_activated' => 'Vehicle doesn\'t activated yet',
		'default_vehicle_trip_error' => 'Default vehicle already in trip, so you couldn\'t set this vehicle as default',
	],

	'account' => [
		'mtn_tel' => 'Mtn Number (without country code)',
		'mpesa_tel' => 'Mpesa Number (without country code)',
		'bank_detail' => 'Bank Details',
		'holder_name' 	=> 'Account Holder Name',
		'account_number' => 'Account Number',
		'bank_name' => 'Name of Bank',
		'bank_location' => 'Bank Location',
		'bank_code' => 'BIC/SWIFT Code',
		'payout_methods' => 'Payout Methods',
		'add_payout_method' => 'Add Payout Method',
		'edit_payout_method' => 'Edit Payout Method',
		'additional_owners' => 'Additional Owners',
		'business_name' => 'Business Name',
		'business_tax_id' => 'Business Tax Id',
		'legal_document' => 'Legal Document',
		'additional_document' => 'Additional Document',
		'ssn_last_4' => 'SSN Last 4 Digits',
		'iban_number' => 'IBAN Number',
		'registration_number' => 'Register Number',
		'routing_number' => 'Routing Number',
		'holder_name' => 'Account Holder Name',
		'payout_methods_desc' => 'When you receive a payment for a reservation, we call that payment to you a “payout”. Our secure payment system supports several payout methods, which can be setup and edited here. Your available payout options and currencies differ by country.',
		'method' => 'Method',
		'default' => 'Default',
		'ready' => 'Ready',
		'remove' => 'Remove',
		'set_default' => 'Set default',
		'add_payout_method' => 'Add Payout Method',
		'legal_document_format' => '(JPG or PNG format)',
		'direct_deposit' => 'Direct Deposit',
		'email_id' => 'Email ID',
		'payout_released_desc1' => 'Payouts for trips are released to you after trip is completed, and it takes some additional time for the money to arrive depending on your payout method.',
		'payout_released_desc2' => 'We can send money to people',
		'payout_released_desc3' => 'with these payout methods. Which do you prefer?',
		'payout_method' => 'Payout method',
		'processing_time' => 'Processing time',
		'additional_fees' => 'Additional fees',
		'currency' => 'Currency',
		'business_days' => 'business days',
		'none' => 'None',
		'business_day_processing' => 'Business day processing only weekends and banking holidays may cause delays',
		'address' => 'Address',
		'zone' => 'Zone',
		'city' => 'City',
		'state' => 'State',
		'province' => 'Province',
		'postal_code' => 'Postal Code',
		'country' => 'Country',
		'submit' => 'Submit',
		'next' => 'Next',
		'completed_transactions' => 'Completed Transactions',
		'future_transactions' => 'Future Transactions',
		'future_payout' => 'Future Payout',
		'paid_out' => 'Paid Out',
		'refund' => 'Refund',
		'all_payout_methods' => 'All payout methods',
		'export_to_csv' => 'Export to CSV',
		'all_listings' => 'All listings',
		'date' => 'Date',
		'type' => 'Type',
		'amount' => 'Amount',
		'payout' => 'Payout',
		'transfer_to' => 'Transfer to',
		'pay_to' => 'Pay To',
		'change_your_pwd' => 'Change Your Password',
		'old_pwd' => 'Old Password',
		'update_pwd' => 'Update Password',
		'payout_updated' => 'Payout Method has Updated Successfully.',
		'bank_detail_updated' => 'Bank details has Updated Successfully.',
		'payout_default' => 'Selected Payout in Default Status.',
		'payout_deleted' => 'Selected Payout Method has Deleted Successfully.',
		'payout_already_defaulted' => 'Selected Payout Already in Default Status.',
		'payout_defaulted' => 'Selected Payout Method has Set Defaulted Successfully.',
		'blank_address' => 'Address cannot be blank.',
		'blank_city' => 'City cannot be blank.',
		'blank_post' => 'Postal Code cannot be blank.',
		'blank_country' => 'Country cannot be blank.',
		'blank_holder_name' => 'Holder Name cannot be blank.',
		'account_number_holder_name' => 'Account Number cannot be blank',
		'phone_number' => 'Phone Number',
		'choose_method' => 'Choose Payout Method.',
		'valid_email' => 'Enter Valid Email ID.',
		'loading' => 'Loading',
		'no_transactions' => 'No Transactions',
		'details' => 'Details',
		'options' => 'Options',
		'fill_all_required_fields' => 'Please fill all the required fields',
		'document_id' => 'Document Id',
		'vehicle_id' => 'Vehicle Id',
		'expired_date' => 'Expired Date',
		'document_image' => 'Document Image',
		'invalid_id' => 'Invalid ID',
		'license_no' => 'Vehicle Number',
		'vehicle_type' => 'Vehicle Type',
		'make_id' => 'Make Id',
		'model_id' => 'Model Id',
		'year' => 'Year',
	],

	'email' => [
		'your' => 'Your',
		'payout_information_updated' => 'payout information has been updated',
		'payout_information_deleted' => 'payout information has been deleted',
		'payout_information_changed' => 'Your Default Payout Information Has Been Changed',
		'payout_update' 			 => 'Your :site_name payout information was updated on',
		'payment_information_del' 	 => 'Your :site_name payout information has been deleted',
		'hope_messgae_friends' 		 => 'We hope this message finds you well. Your :site_name payout account information was recently changed on :updated_date To help keep your account secure, we wanted to reach out to confirm that you made this change. Feel free to disregard this message if you updated your payout account information on :updated_date',
		'change_your_account' 		 => 'If you did not make this change to your account, please contact us.',
	],

	//Web Service
	'credentials' => 'Those credentials don\'t look right. Please try again',
	'login_success' => 'Login Success',
	'inactive_admin' => 'Your Account Deactivated..Please Contact Admin',
	'inactive_company' => 'Your Company Deactivated.',
	'offline' => 'Offline',
	'update_success' => 'Updated Successfully',
	'complete_your_trips' => 'Please Complete your trips',
	'facebook_https_error' => 'Facebook Sign up/Log in will work only on Production sites.',

	'invalid_credentials' => 'Invalid credentials',
	'message_send_failed' => 'Message sending Failed,please try again..',
	'otp_sent_success' => 'Otp sent Successfully',
	'already_have_account' => 'Already you have an account,please login...',
	'promo_already_applied' => 'Promo code was already applied',
	'promo_applied_success' => 'Promo Applied Successfully',
	'promo_expired' => 'Promo code is expired',
	'promo_invalid' => 'Promo code is not valid',
	'amount_added_success' => 'Amount Added Successfully',
	'code_required' => 'The code field is required',
	'active' => 'Active',
	'pending' => 'Pending',
	'complete_trips' => 'Please Complete your trips',
	'cancel_reason_required' => 'Cancel Reason field is required',
	'mobile_number_exist' => 'Mobile Number Exist',
	'new_user' => 'New user',
	'enter_registered_number' => 'Please enter registered mobile number',
	'first_name_required' => 'First name field is required',
	'last_name_required' => 'Last name field is required',
	'mobile_num_required' => 'Mobile Number field is required',
	'country_code_required' => 'country Code field is required',
	'email_id_required' => 'Email Id field is required',
	'profile_image_required' => 'Profile image field is required',
	'address_line1_required' => 'Address line 1 field is required',
	'address_line2_required' => 'Address line 2 field is required',
	'city_required' => 'City field is required',
	'state_required' => 'State name field is required',
	'postal_code_required' => 'Postal Code field is required',
	'service_not_available' => 'Service Not Available In Given Location',
	'cars_found' => 'Cars found',
	'no_cars_found' => 'No cars found',
	'success' => 'Success',
	'field_is_required' => 'field is required',
	'document_select' => 'Selected document is invalid.',
	'trip_started' => 'Trip Started',
	'please_complete_your_current_trip' => 'Please Complete your current trip',
	'base_fare' => 'Base fare',
	'toll_command' => 'Toll Fee Command',
	'access_fee' => 'Access fee',
	'total_fare' => 'Total Fare',
	'total_time_fare' => 'Total time fare',
	'wallet_amount' => 'Wallet amount',
	'driver_payout' => 'Driver payout',
	'driver_or_company_commission' => 'Driver or Company Commission',
	'applied_owe_amount' => 'Applied owe amount',
	'owe_amount' => 'Owe amount',
	'cash_collected' => 'Collectable Cash',
	'distance_fare' => 'Distance Fare',
	'schedule_fare' => 'Schedule Fare',
	'promo_amount' => 'Promo Amount',
	'total_km_fare' => 'Total Km fare',
	'time_fare' => 'Time fare',
	'total_trip_fare' => 'Total trip fare',
	'payable_amount'   => 'Payable Amount',
	'peak_fare' => 'Peak Fare',
	'number_does_not_exists' => 'Number does not exist',
	'peak_time_fare' => 'Peak time pricing',
	'normal_fare' => 'Normal Fare',
	'tips' => 'Tips',
	'toll_fee' => 'Toll Fee',
	'subtotal_fare' => 'Sub Total',
	'peak_subtotal_fare' => 'Sub Total',
	'additional_rider_amount' => '2nd Rider Amount',
	'location_unavailable' => 'Location unavailable',
	'location_country' => 'No service',
	'trip_cash_collected' => 'Driver collected cash for trip.',
	'request_accepted' => 'Driver accepted your trip request and driver is on the way.',
	'driver_arrive' => 'Driver have been just arrived to your location.',
	'trip_begined' => 'Your trip from pickup location to drop location is successfully started.',
	'trip_ended' => 'Your trip from pick up location to drop location is ended successfully.',
	'sms_payment_detail' => 'Your trip is completed. ',
	'cash_collected_payment_detail' => 'Total fare is :total_fare. Base fare is :base_fare. Time fare is :time_fare. Distance fare is :distance_fare. ',
	'trip_booked_driver_message' => 'Trip scheduled for you on :date',
	'trip_booked_driver_remainder' => 'Trip scheduled remind for you on :date.',
	'trip_booked_rider_remainder' => 'Trip scheduled remind for you on :date.',
	'trip_booked_user_message' => 'Trip booked successfully on :date. ',
	'trip_booked_driver_detail' => 'Driver name is :first_name and phone number is :phone_number. ',
	'peak_fare_detail' => 'Peak fare is :peak_fare. ',
	'schedule_fare_detail' => 'Schedule fare is :schedule_fare. ',
	'service_fare_detail' => 'Service fare is :service_fare. ',
	'trip_booked_user_remainder' => 'Trip booked successfully on :date. ',
	'trip_booked_vehicle_detail' => 'Vehicle name is :name and number is :number. ',
	'trip_booked_user_remainder' => 'Your trip will start on :date. ',
	'service_fee' 				 => 'Service Fee',
	'waiting_charge'			 => 'Waiting Charge',
	'just_now'				  	 => 'Just now',
	'ago'				  	 	 => 'ago',
	'payment_complete_success'   => 'Payment completed successfully',
	'wallet_add_success'         => 'Wallet amount added successfully',

	'signup' => [
		'car_document' 			=> 'Car Document',
		'photo' 				=> 'Photo',
		'national_id' 			=> 'National ID',
		'license_front' 		=> 'License Front',
		'license_back' 			=> 'License Back',
		'otp' 					=> 'OTP',
		'resend_otp' 			=> 'Resend OTP',
		'send_otp' 				=> 'Send OTP',
		'wrong_otp' 			=> 'Invalid OTP',
		'otp_resended' 			=> 'OTP send to your number',
	],

	'required' => [
		'cancel_reason' 	=> 'Cancel Reason',
		'cancel_reason_id' 	=> 'Cancel Reason Id',
		'user_type' 		=> 'User Type',
		'trip_id' 			=> 'Trip Id',
	],

	'referrals' => [
		'referral_code' 				=> 'Referral Code',
		'enter_valid_referral_code'     => 'Entered Referral Code Not Found',
		'referral'						=> 'Referral',
		'referral_header'				=> 'SignUp & Get Paid :amount For Every Referral Sign-up!',
		'referral_not_available'		=> 'Currently Referrals Not Available.',
		'previous_referrals' 			=> 'Your Referrals',
		'referral_credited' 			=> 'Referral Credited',
		'referral_credited_desc'		=> 'Referral Amount Credited to Your Wallet',
		'rider_name'					=> 'Rider Name',
		'driver_name'					=> 'Driver Name',
		'total_trips'					=> 'Total Trips',
		'trips_remaining'				=> 'Trips Remaining',
		'total_days'					=> 'Total Days',
		'days_remaining'				=> 'Days Remaining',
		'earnable_amount'				=> 'Earnable Amount',
		'status'						=> 'Status',
		'Pending'						=> 'Pending',
		'Expired'						=> 'Expired',
		'Completed'						=> 'Completed',
	],

	'date_time' => [
		'year' 			=> 'year',
		'month' 		=> 'month',
		'week' 			=> 'week',
		'day' 			=> 'day',
		'hour' 			=> 'hour',
		'minute' 		=> 'minute',
		'second' 		=> 'second',
	],

	'api' => [
		'payout_successfully'	=> 'Payout Successfully Completed',
		'positive_integer' 		=> 'Invalid positive integer',
		'saved_cards' 			=> 'Saved Cards',
		'pay'					=> 'Pay',
		'owe_amount_empty'		=> 'Owe amount Empty',
		'referral_amount_empty'	=> 'Referral amount Empty',
		'not_generate_amount'	=> 'Not generate owe amount',
		'invalid'				=> 'Invalid Value',
		'reason_inactive_admin'	=> 'This reason removed,Please Choose another.',
		'trip_already_completed' => 'Trip already Completed.',
		'listed_successfully'	=> 'Listed Successfully',
		'updated_successfully'	=> 'Updated Successfully',
		'invalid_credentials' 	=> 'Invalid Credentials',
		'something_went_wrong' 	=> 'Something Went Wrong',
		'document_required' 	=> 'Document required',
		'payout_details_added' 	=> 'Payout Details Is Added Successfully',
		'no_data_found'			=> 'No Data Found',
		'email_already_exists' 	=> 'Email already exists',
		'toll_reason'			=> 'Toll Reason',
		'success'				=> 'Success',
		'trip_booked'			=> 'Trip Manually Booked',
		'manual_booking_update'	=> 'Manual Booking',
		'trip_fare_details'		=> 'Trip Fare',
		'waiting_charge_apply_after' => ':amount/min Waiting Fee applies after :minutes min of arrival till trip starts.',
		'trip_total_fare'		=> 'Total fare is :currency :total_fare',
		'trip_confimred' => 'Your trip has been confirmed. Soon you will get driver detail.',
		'no_trips_found'		=> 'No Trips Found',
		'your_otp_to_begin_trip' => 'Your one-time password to begin trip is ',
		'please_add_card_details' => 'Please add Card details first',
		'created_successfully'	=> 'Created Successfully',
		'payment_not_completed' => 'Payment not yet Completed',
		'driver_earnings'		=> 'Driver Earnings',
		'trip_earning'			=> 'Trip Earning',
		'total_fare'			=> 'Total Fare',
		'total_fare_tooltip'	=> 'Fare includes time fare,distance fare and etc.,',
		'admin_remaining_amount' => 'Admin Pending Amount',
		'schedule_ride_updated'	=> 'Schedule ride updated sucessfully',
		'schedule_ride_created' => 'Schedule ride send sucessfully',
		'your_otp_is'			=> 'Your OTP number is ',
		'authentication_failed' => 'Authentication Failed',
		'schedule_cancelled' 	=> 'Schedule Cancelled',
		'schedule_remainder' 	=> 'Trip Scheduled Remainder',
		'trip_begin_by_driver' 	=> 'Trip Began by Driver',
		'trip_cancelled_by_driver' 	=> 'Trip Cancelled by Driver',
		'request_accepted' 		=> 'Request Accepted',
		'driver_confirmed' 		=> 'Driver Confirmed',
		'driver_arrived' 		=> 'Driver Arrived',
		'trip_ended_by_driver'	=> 'Trip Ended by Driver',
		'trip_request'			=> 'Trip Request',
		'trip_scheduled'		=> 'Trip Scheduled',
		'invalid_request'		=> 'Invalid Request',
		'bank_transfer'			=> 'Bank Transfer',
		'paypal'				=> 'PayPal',
		'stripe'				=> 'Stripe',
		'change_debit_card'		=> 'Change Debit Card / Credit Card',
		'add_debit_card'		=> 'Add Debit Card / Credit Card',
		'Cash'					=> 'Cash',
		'PayPal'				=> 'PayPal',
		'mtn'					=> 'Mtn',
		'mpesa'					=> 'Mpesa',
		'yo'				     => 'Yo Payment',
		'Card Payment'			=> 'Card Payment',
		'something_went_wrong_try_later'	=> 'Something Went Wrong. Please try again after sometimes',
		'unable_to_disable_default'	=> 'Unable to disable default vehicle',
		'trip_cancelled_by_rider'	=> 'Trip Cancelled by Rider',
	],
];
