<?php

/**
 * Mpesa Payment Service
 *
 * @package     Ridein
 * @subpackage  Services\Payments
 * @category    Mpesa
 * @author      Source monster Team
 * @version     3.3.9
 * @link        https://sourcemonster.in
 */

namespace App\Services\PaymentMethods;

use App\Contracts\PaymentInterface;
use App\Models\Transaction;
use Illuminate\Support\Facades\Config;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;


class MpesaPayment implements PaymentInterface
{

    protected $client;
    public $consumer_key = '';
    public $consumer_secret = '';
    public $business_code = '';
    public $pass_key = '';
    public $callback_url = '';
    public $url = '';
    public $mode = '';

    /**
     * Intialize Stripe with Secret key
     *
     */
    public function __construct()
    {
        $this->client = new Client();
        $this->consumer_key =  payment_gateway('consumer_key', 'Mpesa');
        $this->consumer_secret =  payment_gateway('consumer_secret', 'Mpesa');
        $this->business_code =  payment_gateway('business_shortcode', 'Mpesa');
        $this->pass_key =  payment_gateway('pass_key', 'Mpesa');
        $this->callback_url =  payment_gateway('callback_url', 'Mpesa');
        $this->url =   payment_gateway('mode', 'Mpesa') == 'sandbox'
            ? 'https://sandbox.safaricom.co.ke'
            : 'https://api.safaricom.co.ke';
        $this->mode =  payment_gateway('mode', 'Mpesa');
    }


    public function makePayment($payment_details, $indent_id = '')
    {

        date_default_timezone_set('Africa/Nairobi');
     

        try {
            // Define additional parameters for STK Push
            $onlinePaymentUrl = $this->url . '/mpesa/stkpush/v1/processrequest';
            $accountReference = Str::random(11);
            $transactionDesc = 'Mpesa '.$payment_details['pay_for'];
            $phone_number =  $this->mode == 'sandbox' ? '254708374149' : $payment_details['user_country_code'] . $payment_details['user_phone']; //$payment_details['user_phone'];
            $accessToken = $this->generateAccessToken();


               
                $MpesaSTKPushResponse = $this->initiateMpesaSTKPush(
                $accessToken,
                $onlinePaymentUrl,
                round($payment_details['amount']),
                $phone_number,
                $this->callback_url,
                $accountReference,
                $transactionDesc
            );

 
     
            if ($MpesaSTKPushResponse->status) {
                
                $Transaction = new Transaction();
                $Transaction->user_id = $payment_details['user_id'];
                $Transaction->reference =   $accountReference;
                $Transaction->checkout_request_id =$MpesaSTKPushResponse->data->CheckoutRequestID ?? "";
                $Transaction->merchant_request_id=$MpesaSTKPushResponse->data->MerchantRequestID ?? "";
                $Transaction->amount = round($payment_details['amount']);
                $Transaction->payment_type = $payment_details['payment_type'];
                $Transaction->currency = $payment_details['currency_code'];
                $Transaction->pay_for = $payment_details['pay_for'];
                
                if($payment_details['trip_id']){
                    $Transaction->trip_id = $payment_details['trip_id'];   
                }
                
                if($payment_details['applied_referral_amount']){
                    $Transaction->applied_referral_amount = $payment_details['applied_referral_amount'];   
                }

                $Transaction->status = 'Requested';
                $Transaction->save();
                
                $return_data['status'] = true;
               $return_data['requesting_status'] = true;
               $return_data['status_message'] =  $MpesaSTKPushResponse->data->ResponseDescription;
               $return_data['checkout_request_id'] =$MpesaSTKPushResponse->data->CheckoutRequestID;
               
                         return arrayToObject($return_data);
            }


         $return_data['status']      = false;
         $return_data['status_message'] =$MpesaSTKPushResponse->status_message;
            return arrayToObject($return_data);

        } catch (\Exception $e) {

            \Log::error(json_encode($e));
            return arrayToObject(array(
                'status'         => false,
                'status_message' => $e->getMessage(),
            ));
        }
    }


    public function paymentVerify($data)
    {

        
    }


    public  function initiateMpesaSTKPush($accessToken, $onlinePaymentUrl, $amount, $phoneNumber, $callbackUrl, $accountReference, $transactionDesc)
    {
        
        $businessCode = $this->business_code;
        $passkey = $this->pass_key; //'bfb279f9aa9bdbcf158e97dd71a467cd2e0c893059b10f78e6b72ada1ed2c919';
        $transactionType = 'CustomerPayBillOnline';
        $timestamp = now()->format('YmdHis');
        $password = base64_encode($this->business_code . $this->pass_key . $timestamp);
        
   
         

        $payload = [
            'BusinessShortCode' => (int)$businessCode,
            'Password' => $password,
            'Timestamp' => $timestamp,
            'TransactionType' => $transactionType,
            'Amount' =>(int)$amount,
            'PartyA' => (int)$phoneNumber,
            'PartyB' =>  (int)$businessCode,
            'PhoneNumber' =>(int)$phoneNumber,
            'CallBackURL' => $callbackUrl,
            'AccountReference' => $accountReference,
            'TransactionDesc' => $transactionDesc
        ];
          


        try {
            // Initialize cURL
            
                $response = $this->client->post($onlinePaymentUrl, [
                'headers' => [
                    'Authorization' => "Bearer $accessToken",
                    'Content-Type' => 'application/json',
                ],
                'json' => $payload,
            ]);
 
  

            $statusCode = $response->getStatusCode();  // Get HTTP status code
            $body = json_decode($response->getBody(), true);
    

     
    
            if ($statusCode === 200) {
                return arrayToObject( [
                    'status' => true,
                    'status_message' => 'STK Push request successful.',
                    'data' => $body
                ]);
            } else {
                return arrayToObject([
                    'status' => false,
                    'status_message' => 'Unexpected response from M-Pesa.',
                    'status_code' => $statusCode,
                    'data' => $body
                ]);
            }

   
        } catch (\GuzzleHttp\Exception\RequestException $e) {
            $response = $e->getResponse();
            $statusCode = $response ? $response->getStatusCode() : 500;
            $errorBody = $response ? json_decode($response->getBody()->getContents(), true) : [];
        
            return arrayToObject([
                'status' => false,
                'status_message' => $errorBody['errorMessage']
            ]);
        }

    }


    public function generateAccessToken()
    {
        $token_url = $this->url . '/oauth/v1/generate?grant_type=client_credentials';
        
        try {
        $response = $this->client->request('GET', $token_url, [
            'auth' => [$this->consumer_key, $this->consumer_secret]
        ]);

        return json_decode($response->getBody())->access_token;
            // Process $result as needed
        } catch (RequestException $e) {
           return '';
        }
    }
}
