<!DOCTYPE html>
<html>

<head>
    <title>Confirm Payment</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0" />
</head>

{!! Html::style('css/payment.css') !!}

<body ng-app="paymentApp" class="">

    <main ng-controller="PaymentController">
        <div class="confirm-form" id="theme">
            <div id="checkout_payment">

                @if ($payment_status->status)
                    <p>{{ $payment_status->status_message }} waiting for confirmation.</p>
                    <p class="text-center" id="timer"></p>
                @else
                
          
                    <p> {{ $payment_status->status_message }}</p>
                    <p class="text-center" id="timer"></p>
                @endif
            </div>

        </div>
    </main>
</body>




{!! Html::script('js/jquery-1.11.3.js') !!}
{!! Html::script('js/jquery-ui.js') !!}
{!! Html::script('js/angular.js') !!}
{!! Html::script('js/angular-sanitize.js') !!}

@if($payment_status->status)
<script>
    angular.module('paymentApp', ['ngSanitize'])
        .service('TransactionService', ['$http', function($http) {
            this.checkStatus = function(transactionId) {
                return $http.get('/api/payment/transaction_status/' + transactionId);
            };
        }])
        .controller('PaymentController', function($scope, $http, $window, $interval,TransactionService) {
            var ctrl = this;
            ctrl.transactionId = '{{ $payment_status->checkout_request_id }} '; // Replace with your transaction ID
            ctrl.timeLeft = 120; // 120 seconds countdown

            ctrl.updateTimerDisplay = function() {
                document.getElementById('timer').innerText = 'Time left: ' + ctrl.timeLeft + ' seconds';
            };

            ctrl.checkTransactionStatus = function() {
                TransactionService.checkStatus(ctrl.transactionId).then(function(response) {
                    if (response.data.status && response.data.transaction_status == 'Paid') {
                        $interval.cancel(ctrl.pollingInterval);
                        $interval.cancel(ctrl.timerInterval);
                        $window.location.href = '/api/payment/mpesa_success?status=1';
                    }else if(response.data.transaction_status == 'Failed'){
                           $interval.cancel(ctrl.pollingInterval);
                           $interval.cancel(ctrl.timerInterval);
                      $window.location.href = '/api/payment/mpesa_success?status=0';  
                    }
                });
            };

            // Timer countdown
            ctrl.updateTimerDisplay();
            ctrl.timerInterval = $interval(function() {
                ctrl.timeLeft--;
                if (ctrl.timeLeft <= 0) {
                    $interval.cancel(ctrl.timerInterval);
                    $window.location.href = '/api/payment/mpesa_success?status=0'; 
                }else{
                       ctrl.updateTimerDisplay();
                }
         
            }, 1000);

            // Poll the server every 5 seconds
            ctrl.pollingInterval = $interval(ctrl.checkTransactionStatus, 5000);
        });
</script>

@endif

@stack('scripts')

</html>
