<?php

return [
    'admin' => [
        'dashboard' => 'Tableau de bord',
        'copyright' => 'Droits d\'auteur',
        'all_rights_reserved' => 'Tous droits réservés',
        'manage_admin' => [
            'title' => 'Gérer les administrateurs',
            'admin_users' => 'Utilisateurs administrateurs',
            'role_and_permissions' => 'Rôle et permissions'
        ],
        "manage_company" => 'Gérer l\'entreprise',
        'manage_drivers' => 'Gérer les conducteurs',
        'manage_riders' => 'Gérer les passagers',
        'manage_documents' => 'Gérer les documents',
        'send_messages' => 'Envoyer des messages',
        'manage_emails' => [
            'title' => 'Gérer les Emails',
            'send_mail' => 'Envoyer un e-mail',
            'email_settings' => 'Paramètres de messagerie',
        ],
        'manage_manual_booking' => [
            'title' => 'Gérer les réservations manuelles',
            'manual_booking' => 'Réservation manuelle',
            'view_manual' => 'Afficher les réservations manuelles / planifiées',
        ],
        'vehicle_make' => 'Marque de véhicule',
        'vehicle_model' => 'Modèle de véhicule',
        'additional_reasons' => 'Raisons supplémentaires',
        'manage_cancel_reason' => 'Gérer la raison d\'annulation',
        'manage_locations' => 'Gérer les emplacements',
        'manage_fare' => 'Gérer le tarif',
        'manage_trips' => [
            'title' => 'Gérer les Voyages',
            'manage_ride_requests' => 'Gérer les Demandes de Course',
            'manage_trips' => 'Gérer les Voyages',
            'manage_canceled_trips' => 'Gérer les Voyages Annulés',
            'cancelled_trips' => 'Voyages Annulés',
            'manage_payments' => 'Gérer les Paiements',
            'request_details' => 'Détails de la Demande',
            'ratings' => 'Évaluations',
            'payments' => 'Paiements',
            'ride_requests' => 'Demandes de Course',
            'trips' => 'Voyages',
        ],
        'manage_payouts' => [
            'title' => 'Gérer les Paiements',
            'company_payouts' => 'Paiements de l\'Entreprise',
            'driver_payouts' => 'Paiements du Chauffeur',
            'driver_payouts_title' => 'Gérer le Chauffeur :payout_title',
            'company_payouts_title' => 'Gérer l\'Entreprise :payout_title',
            'table' => [
                'id' => 'ID',
                'driver_id' => 'ID du Chauffeur',
                'driver_name' => 'Nom du Chauffeur',
                'payout_amount' => 'Montant du Paiement',
                'company_id' => 'ID de l\'Entreprise',
                'company_name' => 'Nom de l\'Entreprise',
                'payout_amount' => 'Montant du Paiement',
                'action' => 'Action',
            ]
        ],
        'manage_owe_amount' => 'Gérer le montant dû',
        'manage_statements' => [
            'title' => 'Gérer les Déclarations',
            'overall_statements' => 'Déclarations Générales',
            'drivers_statments' => 'Déclarations des Conducteurs',
            'statements' => 'Déclarations',
            'filter_by' => 'Filtrer Par',
            'search' => 'Rechercher',
            'total_amount_received' => 'Montant Total Reçu',
            'total_earnings' => 'Revenus Totals',
            'completed_rides' => 'Courses Complétées',
            'cancelled_rides' => 'Courses Annulées',
            'drivers' => 'Conducteurs',
            'overall' => 'Total',
            'view_by_rider' => 'Voir Par Passager',
            'from_date' => 'Date de Début',
            'to_date' => 'Date de Fin',
            'today' => 'Aujourd\'hui',
            'weekly' => 'Hebdomadaire',
            'monthly' => 'Mensuel',
            'yearly' => 'Annuel',
            'custom' => 'Personnalisé',
            'view_trip_details' => 'Voir les Détails du Trajet',
            'table' => [
                'driver_id' => 'ID du Conducteur',
                'driver_name' => 'Nom du Conducteur',
                'mobile' => 'Mobile',
                'total_rides' => 'Total des Courses',
                'earnings' => 'Revenus',
                'joined_at' => 'Rejoint le',
                'details' => 'Détails',
                'booking_id' => 'ID de Réservation',
                'company_name' => 'Nom de l\'Entreprise',
                'pickup_location' => 'Lieu de Prise en Charge',
                'drop_location' => 'Lieu de Dépose',
                'trip_details' => 'Détails du Trajet',
                'admin_commission' => 'Commission de l\'Administrateur',
                'admin_payout_status' => 'Statut du Paiement de l\'Administrateur',
                'dated_on' => 'Daté le',
                'status' => 'Statut',
                'earned' => 'Gagné'
            ]
        ],
        'manage_wallet_and_promo' => [
            'title' => 'Gérer le Portefeuille et les Codes Promo',
            'wallet' => 'Portefeuille',
            'manage_wallet_amount' => 'Gérer le Montant du Portefeuille',
            'manage_promo_code' => 'Gérer le Code Promo',
            'add_wallet' => 'Ajouter un Portefeuille',
            'add_wallet_amount' => 'Ajouter le Montant du Portefeuille',
            'add_title' => 'Formulaire d\'Ajout de Portefeuille',
            'edit_wallet' => 'Modifier le Montant du Portefeuille',
            'edit_title' => 'Formulaire de Modification de Portefeuille',
            'rider' => 'Passager',
            'promo_code' => 'Code Promo',
            'add_promo_code' => 'Ajouter un Code Promo',
            'add_promo_code_form' => 'Formulaire d\'Ajout de Code Promo',
            'edit_promo_code' => 'Modifier le Code Promo',
            'edit_promo_code_form' => 'Formulaire de Modification de Code Promo',
            'table' => [
                'id' => 'ID',
                'user_id' => 'ID de l\'Utilisateur',
                'first_name' => 'Prénom',
                'last_name' => 'Nom de Famille',
                'wallet_amount' => 'Montant du Portefeuille',
                'currency_code' => 'Code de Devise',
                'action' => 'Action',
                'code' => 'Code',
                'original_amount' => 'Montant d\'Origine',
                'expire_date' => 'Date d\'Expiration',
                'status' => 'Statut',
            ],
            'form' => [
                'username' => 'Nom d\'Utilisateur',
                'amount' => 'Montant',
                'currency_code' => 'Code de Devise',
                'promo_code' => 'Code Promo',
                'expire_date' => 'Date d\'Expiration',
                'status' => 'Statut',
            ]
        ],
        'referrals' => [
            'title' => 'Références',
            'drivers' => 'Chauffeurs',
            'riders' => 'Passagers',
            'referral' => 'Référence',
            'view_referral_details' => 'Voir les Détails de la Référence',
            'details' => 'Détails',
            'table' => [
                'id' => 'ID',
                'name' => 'Nom',
                'driver_name' => 'Nom du Chauffeur',
                'referral_name' => 'Nom de la Référence',
                'currency_code' => 'Code de Devise',
                'earned_amount' => 'Montant Gagné',
                'pending_amount' => 'Montant en Attente',
                'action' => 'Action',
                'trips' => 'Trajets',
                'remaining_trips' => 'Trajets Restants',
                'remaining_days' => 'Jours Restants',
                'amount' => 'Montant',
                'status' => 'Statut',
            ]
        ],
        'manage_map' => [
            'title' => 'Gérer la Carte',
            'map_view' => 'Vue de la Carte',
            'heat_map' => 'Carte de Chaleur',
            'map' => 'Carte',
            'user' => 'Utilisateur',
            'unavailable_driver' => 'Chauffeur Indisponible',
            'available_driver' => 'Chauffeur Disponible',
            'unactivated_driver' => 'Chauffeur Non Activé',
        ],

        'manage_mobile_app_version' => [
            'title' => 'Gérer la Version de l\'Application Mobile',
            'subtitle' => 'Version de l\'Application Mobile',
            'edit_mobile_app_version_form' => 'Formulaire de Modification de la Version de l\'Application Mobile',
            'add_mobile_app_version_form' => 'Formulaire d\'Ajout de la Version de l\'Application Mobile',
            'table' => [
                'id' => 'ID',
                'version' => 'Version',
                'device_type' => 'Type de Dispositif',
                'user_type' => 'Type d\'Utilisateur',
                'force_update' => 'Mise à Jour Forcée',
                'created_at' => 'Créé Le',
                'updated_at' => 'Mis à Jour Le',
                'action' => 'Action',
            ],
            'form' => [
                'version' => 'Version',
                'device_type' => 'Type de Dispositif',
                'user_type' => 'Type d\'Utilisateur',
                'force_update' => 'Mise à Jour Forcée',
            ]
        ],
        'api_credentials' => [
            'title' => 'Identifiants API',
            'form_title' => 'Formulaire d\'Identifiants API',
            'form' => [
                'google_map_key' => 'Clé Google Map',
                'google_map_server_key' => 'Clé de Serveur Google Map',
                'twillo_sid' => 'Twillo SID',
                'twillo_token' => 'Jeton Twillo',
                'twillo_from_number' => 'Numéro d\'Envoi Twillo',
                'twillo_service_sid' => 'Twillo Service SID',
                'apple_service_id' => 'ID de Service Apple',
                'apple_team_id' => 'ID de l\'Équipe Apple',
                'apple_key_id' => 'ID de Clé Apple',
                'apple_key_file' => 'Fichier de Clé Apple',
                'firebase_database_url' => 'URL de la Base de Données Firebase',
                'firebase_service_account' => 'Fichier de Compte de Service Firebase (JSON)'
            ]
        ],
        'payment_gateway' => [
            'title' => 'Passerelle de Paiement',
            'form_title' => 'Formulaire de Passerelle de Paiement',
            'tabs' => [
                'paypal' => 'Paypal',
                'stripe' => 'Stripe',
                'paytm' => 'Paytm',
                'razorpay' => 'RazorPay',
                'flutterwave' => 'FlutterWave',
                'redsys' => 'Redsys',
                'braintree' => 'Braintree',
                'payout_methods' => 'Méthodes de paiement',
            ],
            'form' => [
                'is_paypal_enabled' => 'PayPal est-il Activé',
                'paypal_mode' => 'Mode PayPal',
                'paypal_id' => 'ID PayPal',
                'paypal_client_id' => 'ID Client PayPal',
                'paypal_secret' => 'Secret PayPal',
                'paypal_access_token' => 'Jeton d\'Accès PayPal',
                'is_stripe_enabled' => 'Stripe est-il Activé',
                'stripe_key' => 'Clé Stripe',
                'stripe_secret' => 'Secret Stripe',
                'stripe_api_version' => 'Version API Stripe',
                'is_paytm_enabled' => 'Paytm est-il Activé',
                'paytm_mode' => 'Mode Paytm',
                'paytm_merchant_id' => 'ID du Commerçant Paytm',
                'paytm_merchant_key' => 'Clé du Commerçant Paytm',
                'paytm_merchant_website' => 'Site Web du Commerçant Paytm',
                'paytm_merchant_channel' => 'Canal du Commerçant Paytm',
                'paytm_industry_type' => 'Type d\'Industrie Paytm',
                'is_razorpay_enabled' => 'Razorpay est-il Activé',
                'razorpay_mode' => 'Mode Razorpay',
                'razorpay_key' => 'Clé Razorpay',
                'razorpay_secret' => 'Secret Razorpay',
                'is_flutterwave_enabled' => 'Flutterwave est-il Activé',
                'flutterwave_key' => 'Clé Flutterwave',
                'flutterwave_secret' => 'Secret Flutterwave',
                'flutterwave_hash' => 'Hash Flutterwave',
                'is_redsys_enabled' => 'Redsys est-il Activé',
                'redsys_mode' => 'Mode Redsys',
                'redsys_merchant_mode' => 'Code Commerçant Redsys',
                'redsys_key' => 'Clé Redsys',
                'redsys_terminal' => 'Terminal Redsys',
                'redsys_url_notification' => 'URL de Notification Redsys',
                'redsys_url_ok' => 'URL Ok Redsys',
                'redsys_url_ko' => 'URL Ko Redsys',
                'redsys_tradename' => 'Nom Commercial Redsys',
                'is_braintree_enabled' => 'Braintree est-il Activé',
                'payment_mode' => 'Mode de Paiement',
                'braintree_merchant_id' => 'ID du Commerçant Braintree',
                'Braintree_merchant_account_id' => 'ID du Compte du Commerçant Braintree',
                'braintree_public_key' => 'Clé Publique Braintree',
                'braintree_private_key' => 'Clé Privée Braintree',
                'braintree_tokenization_key' => 'Clé de Tokenisation Braintree',
                'web_payment' => 'Paiement Web',
                'payout_methods' => 'Méthodes de Paiement'
            ]
        ],
        'mange_fees' => [
            'title' => 'Gérer les Frais',
            'fees' => 'Frais',
            'fees_form' => 'Formulaire de Frais',
            'form' => [
                'rider_service_fee' => 'Frais de Service du Passager',
                'driver_peak_fare' => 'Tarif de Pointe du Conducteur',
                'is_pool' => 'Montant du 2ème Passager',
                'is_pool_small' => 'Pour les Trajets Partagés',
                'driver_service_fee' => 'Frais de Service du Conducteur',
                'apply_trip_additional_fee' => 'Appliquer des Frais Additionnels au Trajet'
            ]
        ],
        'manage_referral_settings' => [
            'title' => 'Gérer les Paramètres de Référencement',
            'referral_settings' => 'Paramètres de Référencement',
            'form_title' => 'Formulaire de Gestion des Paramètres de Référencement des Conducteurs',
            'form' => [
                'number_of_trips' => 'Nombre de Trajets',
                'driver_days' => 'Période (En jours)',
                'currency_code' => 'Code de la Devise',
                'driver_amount' => 'Montant par Trajets',
                'referral_amount' => 'Montant de Référencement',
                'time_frame' => 'Période'
            ]
        ],
        'manage_metas' => [
            'title' => 'Gérer les Métas',
            'metas' => 'Métas',
            'edit_meta' => 'Modifier les Métas',
            'edit_meta_form' => 'Formulaire de Modification des Métas',
            'table' => [
                'id' => 'Id',
                'url' => 'Url',
                'title' => 'Titre',
                'description' => 'Description',
                'keywords' => 'Mots-clés',
                'action' => 'Action'
            ],
            'form' => [
                'page_url' => 'URL de la Page',
                'page_title' => 'Titre de la Page',
                'meta_description' => 'Description des Métas',
                'keywords' => 'Mots-clés'
            ]
        ],
        'manage_country' => [
            'title' => 'Gérer les Pays',
            'country' => 'Pays',
            'add_country' => 'Ajouter un Pays',
            'add_country_form' => 'Formulaire d\'Ajout de Pays',
            'edit_country' => 'Modifier le Pays',
            'edit_country_form' => 'Formulaire de Modification de Pays',
            'table' => [
                'id' => 'ID',
                'short_name' => 'Nom Court',
                'long_name' => 'Nom Long',
                'iso3' => 'Iso3',
                'num_code' => 'Code Numérique',
                'phone_code' => 'Code Téléphonique',
                'action' => 'Action',
            ],
            'form' => [
                'short_name' => 'Nom Court',
                'long_name' => 'Nom Long',
                'iso3' => 'Iso3',
                'num_code' => 'Code Numérique',
                'phone_code' => 'Code Téléphonique',
            ]
        ],
        'manage_currency' => [
            'title' => 'Gérer les Devises',
            'currency' => 'Devise',
            'add_currency' => 'Ajouter une Devise',
            'add_currency_form' => 'Formulaire d\'Ajout de Devise',
            'edit_currency' => 'Modifier la Devise',
            'edit_currency_form' => 'Formulaire de Modification de Devise',
            'table' => [
                'id' => 'ID',
                'name' => 'Nom',
                'code' => 'Code',
                'rate' => 'Taux',
                'status' => 'Statut',
                'action' => 'Action',
            ],
            'form' => [
                'name' => 'Nom',
                'code' => 'Code',
                'rate' => 'Taux',
                'symbol' => 'Symbole',
                'status' => 'Statut',
            ]
        ],
        'manage_language' => [
            'title' => 'Gérer les Langues',
            'language' => 'Langue',
            'add_language' => 'Ajouter une Langue',
            'add_language_form' => 'Formulaire d\'Ajout de Langue',
            'edit_language' => 'Modifier la Langue',
            'edit_language_form' => 'Formulaire de Modification de Langue',
            'table' => [
                'id' => 'ID',
                'name' => 'Nom',
                'value' => 'Valeur',
                'status' => 'Statut',
                'action' => 'Action',
            ],
            'form' => [
                'name' => 'Nom',
                'value' => 'Valeur',
                'status' => 'Statut',
            ]
        ],
        'manage_static_pages' => [
            'title' => 'Gérer les Pages Statiques',
            'static_page' => 'Pages Statiques',
            'page' => 'Page',
            'add_page' => 'Ajouter une Page',
            'add_page_form' => 'Formulaire d\'Ajout de Page',
            'edit_page' => 'Modifier la Page',
            'edit_page_form' => 'Formulaire de Modification de Page',
            'translations' => 'Traductions',
            'add_translation' => 'Ajouter une Traduction',
            'table' => [
                'id' => 'Id',
                'name' => 'Nom',
                'url' => 'Url',
                'status' => 'Statut',
                'updated_at' => 'Mis à Jour',
                'action' => 'Action',
            ],
            'form' => [
                'name' => 'Nom',
                'content' => 'Contenu',
                'footer' => 'Pied de page',
                'status' => 'Statut',
                'language' => 'Langue',
                'question' => 'Question',
                'answer' => 'Réponse'
            ]
        ],
        'manage_help' => [
            'title' => 'Gérer l\'Aide',
            'help' => 'Aide',
            'category' => 'Catégories',
            'subcategory' => 'Sous-catégories',
            'help_category' => 'Catégorie d\'Aide',
            'add_help' => 'Ajouter une Aide',
            'add_help_form' => 'Formulaire d\'Ajout d\'Aide',
            'edit_help' => 'Modifier l\'Aide',
            'edit_help_form' => 'Formulaire de Modification d\'Aide',
            'help_sub_category' => 'Sous-catégorie d\'Aide',
            'add_help_category' => 'Ajouter une Catégorie d\'Aide',
            'add_help_category_form' => 'Formulaire d\'Ajout de Catégorie d\'Aide',
            'edit_help_category_form' => 'Formulaire de Modification de Catégorie d\'Aide',
            'add_help_sub_category' => 'Ajouter une Sous-catégorie d\'Aide',
            'add_help_sub_category_form' => 'Formulaire d\'Ajout de Sous-catégorie d\'Aide',
            'edit_help_sub_category' => 'Modifier une Sous-catégorie d\'Aide',
            'edit_help_sub_category_form' => 'Formulaire de Modification de Sous-catégorie d\'Aide',
            'translations' => 'Traductions',
            'add_translation' => 'Ajouter une Traduction',
            'table' => [
                'id' => "Id",
                'category' => 'Catégorie',
                'subcategory' => 'Sous-catégorie',
                'question' => 'Question',
                'suggested' => 'Suggéré',
                'answer' => 'Réponse',
                'status' => 'Statut',
                'action' => 'Action',
                'name' => 'Nom',
                'description' => 'Description',
                'suggested' => 'Suggéré',
            ],
            'form' => [
                'language' => 'Langue',
                'category' => 'Catégorie',
                'subcategory' => 'Sous-catégorie',
                'question' => 'Question',
                'answer' => 'Réponse',
                'name' => 'Nom',
                'description' => 'Description',
                'suggested' => 'Suggéré',
                'status' => 'Statut',
            ]
        ],
        'join_us_links' => [
            'title' => 'Liens pour Nous Rejoindre',
            'join_us' => 'Nous Rejoindre',
            'join_us_form' => 'Formulaire de Nous Rejoindre',
            'form' => [
                'facebook' => 'Facebook',
                'instagram' => 'Instagram',
                'twitter' => 'Twitter',
                'linkedin' => 'LinkedIn',
                'pinterest' => 'Pinterest',
                'youtube' => 'YouTube',
                'app_store_rider' => 'Lien de l\'App Store pour le Passager',
                'app_store_driver' => 'Lien de l\'App Store pour le Conducteur',
                'play_store_rider' => 'Lien du Play Store pour le Passager',
                'play_store_driver' => 'Lien du Play Store pour le Conducteur'
            ]
        ],
        'manage_support' => [
            'title' => 'Gérer le Support',
            'support' => 'Support',
            'add_support' => 'Ajouter un Support',
            'add_support_form' => 'Formulaire d\'Ajout de Support',
            'edit_support' => 'Modifier le Support',
            'edit_support_form' => 'Formulaire de Modification de Support',
            'note' => 'Note* : Veuillez le remplir avec le code du pays.(Exemple-911234567890).',
            'table' => [
                'id' => 'Id',
                'name' => "Nom",
                'link' => 'Lien',
                'status' => 'Statut',
                'action' => 'Action',
            ],
            'form' => [
                'name' => "Nom",
                'link' => 'Lien',
                'status' => 'Statut',
                'image' => 'Image',
                'number' => 'Numéro'
            ]
        ],
        'site_setting' => [
            'title' => 'Paramètres du Site',
            'site_settings_form' => 'Formulaire de Paramètres du Site',
            'pool' => 'Voyage en Groupe Uniquement',
            'note' => 'Note : Cette devise doit être la même que votre devise Braintree',
            'form' => [
                'site_name' => 'Nom du Site',
                'version' => 'Version',
                'header_logo' => 'Logo de l\'En-tête',
                'header_white_logo' => 'Logo Blanc de l\'En-tête',
                'favicon' => 'Favicon',
                'timezones' => 'Fuseaux Horaires',
                'default_currency' => 'Devise par Défaut',
                'payment_currency' => 'Devise de Paiement',
                'trip_default_payment_method' => 'Méthode de Paiement par Défaut pour le Voyage',
                'driver_kilometer' => 'Kilomètre du Conducteur',
                'pickup_kilometer' => 'Kilomètre de Prise en Charge',
                'drop_kilometer' => 'Kilomètre de Dépôt',
                'head_code' => 'Ajouter un code à <head> (pour les codes de suivi comme Google Analytics)',
                'default_language' => 'Langue par Défaut',
                'country_code' => 'Code du Pays',
                'manual_booking_contact_number' => 'Numéro de Contact pour Réservation Manuelle',
                'heat_map' => 'Carte de Chaleur',
                'heat_map_hours' => 'Heures de la carte thermique',
                'update_location_interval' => 'Intervalle de Mise à Jour de la Position',
                'otp_verification' => 'Vérification OTP',
                'covid_feature' => 'Fonctionnalité COVID',
                'driver_request_seconds' => 'Secondes de Demande du Conducteur',
                'driver_request_limit' => 'Limite de Demande du Conducteur',
                'pay_to_admin_driver_limit' => 'Limite de Paiement à l\'Administrateur pour le Conducteur (Montant Fixe)*',
                'copyright_year' => 'Année de Copyright',
                'copyright_url' => 'URL de Copyright',
                'copyright_name' => 'Nom de Copyright',
            ]
        ],
        'control_panel' => 'Panneau de configuration',
        'home' => 'Accueil',
        'fields_are_mandatory' => 'Les champs sont obligatoires',
        'submit' => 'Soumettre',
        'cancel' => 'Annuler',
        'add' => 'Ajouter',
        "edit" => 'Modifier',
        'reset' => 'Réinitialiser',
        'dashboard_page' => [
            'dashboard' => 'Tableau de bord',
            'total_earnings' => 'Gains totaux',
            'total_drivers' => 'Total des conducteurs',
            'total_riders' => 'Total des passagers',
            'total_trips' => 'Total des trajets',
            'today_earnings' => 'Gains aujourd\'hui',
            'today_drivers' => 'Conducteurs aujourd\'hui',
            'today_riders' => 'Passagers aujourd\'hui',
            'today_trips' => 'Trajets aujourd\'hui',
            'sales_graph' => 'Graphique des ventes',
            'calender' => 'Calendrier',
            'recent_ride_requests' => 'Demandes de trajet récentes',
            'table' => [
                'group_id' => 'ID de groupe',
                'rider_name' => 'Nom du passager',
                'dated_on' => 'Daté du',
                'status' => 'Statut',
                'driver_name' => 'Nom du conducteur',
                'group_id' => 'ID de groupe',
            ]
        ],
        'manage_admin_page' => [
            'admin_users' => 'Utilisateurs Administrateurs',
            'add_admin_user' => 'Ajouter un Utilisateur Administrateur',
            'add_admin_user_form' => 'Formulaire pour Ajouter un Utilisateur Administrateur',
            "edit_admin_user" => "Modifier l’utilisateur administrateur",
            "edit_admin_user_form" => "Formulaire de modification de l’utilisateur administrateur",
            'add_role' => 'Ajouter un Rôle',
            'add_role_form' => 'Formulaire pour Ajouter un Rôle',
            'edit_role' => "Modifier le rôle",
            'edit_role_form' => "Formulaire de modification du rôle",
            'roles' => 'Rôles',
            'table' => [
                'id' => 'ID',
                'username' => "Nom d'utilisateur",
                'email' => 'Adresse électronique',
                'status' => 'Statut',
                'action' => 'Action',
                'name' => 'Nom',
                'display_name' => 'Nom d’Affichage',
                'description' => 'Description',
            ],
            'form' => [
                'name' => 'Nom',
                'username' => "Nom d'utilisateur",
                'email' => 'Adresse électronique',
                'password' => 'Mot de passe',
                'country_code' => 'Code du pays',
                'mobile_number' => 'Numéro de mobile (pour des fins de SOS)',
                'role' => 'Rôle',
                'status' => 'Statut',
                'display_name' => 'Nom d’Affichage',
                'description' => 'Description',
                'permissions' => 'Permissions',

            ]
        ],
        "manage_company_page" => [
            'title' => 'Gérer l\'entreprise',
            'add_company' => 'Ajouter une entreprise',
            'add_company_form' => 'Formulaire d\'ajout d\'entreprise',
            'edit_company' => 'Modifier l\'entreprise',
            'edit_company_form' => 'Formulaire de modification de l\'entreprise',
            'companies' => 'Entreprises',
            'form' => [
                'name' => 'Nom',
                'vat_number' => 'Numéro de TVA',
                'email' => 'Email',
                'password' => 'Mot de passe',
                'country_code' => 'Code du pays',
                'mobile_number' => 'Numéro de mobile',
                'status' => 'Statut',
                'address_line' => 'Adresse',
                'city' => 'Ville',
                'state' => 'État',
                'postal_code' => 'Code postal',
                'profile' => 'Profil',
                'company_commission' => 'Commission de l\'entreprise'
            ],
            'table' => [
                'name' => 'Nom',
                'drivers' => 'Chauffeurs',
                'email' => 'Email',
                'mobile_number' => 'Numéro de mobile',
                'status' => 'Statut',
                'action' => 'Action'
            ]
        ],
        "manage_drivers_page" => [
            'title' => 'Gérer les chauffeurs',
            'add_driver' => 'Ajouter un chauffeur',
            'add_driver_form' => 'Formulaire d\'ajout de chauffeur',
            'edit_driver' => 'Modifier le chauffeur',
            'edit_driver_form' => 'Formulaire de modification de chauffeur',
            'table' => [
                'id' => 'Id',
                'first_name' => 'Prénom',
                'last_name' => 'Nom de famille',
                'company_name' => 'Nom de l\'entreprise',
                'email' => 'Email',
                'gender' => 'Genre',
                'status' => 'Statut',
                'mobile_number' => 'Numéro de mobile',
                'device_type' => 'Type d\'appareil',
                'created_at' => 'Créé le',
                'action' => 'Action',
            ],
            'form' => [
                'first_name' => 'Prénom',
                'last_name' => 'Nom de famille',
                'password' => 'Mot de passe',
                'country_code' => 'Code du pays',
                'company_name' => 'Nom de l\'entreprise',
                'email' => 'Email',
                'gender' => 'Genre',
                'status' => 'Statut',
                'mobile_number' => 'Numéro de mobile',
                'device_type' => 'Type d\'appareil',
                'address_line1' => 'Adresse ligne 1',
                'address_line2' => 'Adresse ligne 2',
                'city' => 'Ville',
                'state' => 'État',
                'postal_code' => 'Code postal',
                'expire_date' => 'Date d\'expiration',
                'account_holder_name' => 'Nom du titulaire du compte',
                'account_number' => 'Numéro de compte',
                'name_of_bank' => 'Nom de la banque',
                'bank_location' => 'Emplacement de la banque',
                'code' => 'Code BIC/SWIFT',
            ]
        ],
        "manage_riders_page" => [
            'title' => 'Gérer les Coureurs',
            'riders' => 'Coureurs',
            'add_rider' => 'Ajouter un Coureur',
            'add_rider_form' => 'Formulaire d\'Ajout de Coureur',
            'edit_rider' => 'Modifier le Coureur',
            'edit_rider_form' => 'Formulaire de Modification de Coureur',
            'table' => [
                'id' => 'Id',
                'first_name' => 'Prénom',
                'last_name' => 'Nom de Famille',
                'email' => 'Email',
                'gender' => 'Genre',
                'status' => 'Statut',
                'mobile_number' => 'Numéro de Téléphone',
                'device_type' => 'Type d\'Appareil',
                'created_at' => 'Créé le',
                'action' => 'Action',
            ],
            'form' => [
                'first_name' => 'Prénom',
                'last_name' => 'Nom de Famille',
                'password' => 'Mot de Passe',
                'country_code' => 'Code du Pays',
                'email' => 'Email',
                'gender' => 'Genre',
                'status' => 'Statut',
                'mobile_number' => 'Numéro de Téléphone',
                'device_type' => 'Type d\'Appareil',
                'home_location' => 'Localisation du Domicile',
                'work_location' => 'Localisation du Travail'
            ]
        ],
        "manage_documents_page" => [
            'title' => 'Documents',
            'add_documents' => 'Ajouter des Documents',
            'add_documents_form' => 'Formulaire :add de Documents',
            'edit_documents' => 'Modifier les Documents',
            'edit_documents_form' => 'Formulaire de :edit de Documents',
            'table' => [
                'id' => 'Id',
                'document_for' => 'Document Pour',
                'country' => 'Pays',
                'document_name' => 'Nom du Document',
                'status' => 'Statut',
                'action' => 'Action',
            ],
            'form' => [
                'language' => 'Langue',
                'document_for' => 'Document Pour',
                'country' => 'Pays',
                'document_name' => 'Nom du Document',
                'status' => 'Statut',
                'expire_on_date' => 'Date d\'Expiration',
            ]
        ],
        'manage_send_message_page' => [
            'title' => 'Envoyer un Message',
            'send_message_form' => 'Formulaire d\'Envoi de Message',
            'all' => 'Tous',
            'specific_users' => 'Utilisateurs spécifiques',
            'sms' => 'SMS',
            'push_notification' => 'Notification push',
            'all_driver' => 'Conducteur',
            'all_rider' => 'Passager',
            'all_company' => 'Entreprise',
            'all_type' => 'Passager & Conducteur & Entreprise',

            'form' => [
                'to' => 'À',
                'user_type' => 'Type d\'Utilisateur',
                'message_type' => 'Type de Message',
                'message' => 'Message',
            ]
        ],
        'manage_emails_page' => [
            'send_email' => 'Envoyer un Email',
            'send_email_form' => 'Formulaire d\'Envoi d\'Email',
            'notes' => 'Remarque : L\'email sera envoyé uniquement aux utilisateurs enregistrés.',
            'email_settings' => 'Paramètres de l\'Email',
            'email_settings_form' => 'Formulaire de Paramètres de l\'Email',
            'form' => [
                'email_to' => 'Email À',
                'email_address' => 'Adresse Email',
                'subject' => 'Sujet',
                'message' => 'Message (la salutation sera ajoutée automatiquement)',
                'host' => 'Hôte',
                'driver' => 'Pilote',
                'port' => 'Port',
                'from_address' => 'Adresse de l\'Expéditeur',
                'form_name' => 'Nom du Formulaire',
                'encryption' => 'Cryptage',
                'username' => 'Nom d\'Utilisateur',
                'password' => 'Mot de Passe',
            ]
        ],
        'manage_manual_booking_page' => [
            'title' => 'Réservation Manuelle',
            'heading' => 'Dispatch Taxi Manuel',
            'select_driver_availability' => 'Sélectionner la Disponibilité du Conducteur',
            'map_zoom_level' => 'Niveau de Zoom de la Carte',
            'auto_assign_driver' => 'Attribuer Automatiquement un Conducteur',
            'fare_estimation' => 'Estimation du Tarif',
            'minimum_fare' => 'Tarif Minimum',
            'base_fare' => 'Tarif de Base',
            'distance' => 'Distance',
            'time' => 'Temps',
            'minutes' => 'Minutes',
            'peak_price' => 'Tarif de Pointe',
            'total_fare' => 'Tarif Total',
            'notes' => 'Notes',
            'reason' => 'Raison',
            'manual_auto_booking' => [
                'title' => 'Réservation Auto Manuelle',
                'point_1' => 'L\'administrateur peut ajouter / modifier la réservation de trajet ultérieurement sur cette page.',
                'point_2' => 'La disponibilité actuelle du conducteur n\'est pas connectée à la réservation en cours.',
                'point_3' => 'Ajouter une réservation à partir d\'ici n\'enverra pas de demande au conducteur immédiatement.',
                'point_4' => 'En cas de sélection de l\'option "Attribuer Automatiquement un Conducteur", le conducteur recevra une demande automatique 5 minutes avant l\'heure réelle de la réservation.',
                'point_5' => 'En cas de non-sélection de l\'option "Attribuer Automatiquement un Conducteur", le conducteur recevra une confirmation de réservation ainsi qu\'un SMS de rappel 30 minutes avant l\'heure réelle de la réservation.',
                'point_6' => 'Le conducteur doit commencer le trajet programmé en allant à "Votre Trajet" >> section à venir de l\'application du conducteur.',
                'point_7' => 'En cas de "Attribuer Automatiquement un Conducteur", l\'algorithme compétitif sera suivi.'
            ],
            'manual_assign_booking' => [
                'title' => 'Attribuer Manuellement une Réservation',
                'point_1' => 'Veuillez confirmer la disponibilité future du conducteur avant de faire la réservation.',
                'point_2' => 'Le conducteur doit commencer le trajet programmé en allant à "Votre Trajet" >> section à venir de l\'application du conducteur.',
            ],
            'manage_bookings' => 'Gérer les Réservations',
            'cancel_reason' => 'Raison d\'Annulation',
            'booking_cancel' => 'Annuler Réservation',
            'booking_cancel_reason' => 'Raison d\'Annulation de Réservation',
            'cancel_by' => 'Annuler par',
            'cancelled_by' => 'Annulé par',
            'cancel' => 'Annuler',
            'trip_cancelled' => 'Voyage annulé',
            'immediate_request' => 'Demande immédiate',
            'table' => [
                'company_name' => 'Nom de l\'entreprise',
                'booked_by' => 'Réservé par',
                'date' => 'Date',
                'driver_name' => 'Nom du Conducteur',
                'rider_name' => 'Nom du Passager',
                'pickup_location' => 'Lieu de Prise en Charge',
                'drop_location' => 'Lieu de Dépose',
                'trip_details' => 'Détails du Trajet',
                'status' => 'Statut',
            ]

        ],
        'manage_vehicle_make' => [
            'title' => 'Marque de Véhicule',
            'add_vehicle_make' => 'Ajouter Marque de Véhicule',
            'form_title' => 'Formulaire d\'Ajout de Marque de Véhicule',
            'edit_vehicle_make' => 'Modifier Marque de Véhicule',
            'edit_form_title' => 'Formulaire de Modification de Marque de Véhicule',

            'form' => [
                'status' => 'Statut',
                'make' => 'Marque de Véhicule',
            ],
            'table' => [
                'id' => 'Id',
                'status' => 'Statut',
                'make' => 'Marque',
            ]
        ],
        'manage_vehicle_model' => [
            'title' => 'Modèle de Véhicule',
            'add_vehicle_model' => 'Ajouter Modèle de Véhicule',
            'form_title' => 'Formulaire d\'ajout de Modèle de Véhicule',
            'edit_vehicle_model' => 'Modifier Modèle de Véhicule',
            'edit_form_title' => 'Formulaire de Modification de Modèle de Véhicule',
            'table' => [
                'id' => 'ID',
                'make' => 'Marque',
                'model' => 'Modèle',
                'status' => 'Statut',
                'action' => 'Action',
            ],
            'form' => [
                'vehicle_make' => 'Marque du Véhicule',
                'model' => 'Nom du Modèle du Véhicule',
                'status' => 'Statut',
            ]
        ],
        'manage_vehicle_type' => [
            'title' => 'Types de Véhicules',
            'vehicles' => 'Véhicules',
            'vehicle_types' => 'Types de Véhicules',
            'add_vehicle_type' => 'Ajouter Type de Véhicule',
            'form_title' => 'Formulaire d\'ajout de Type de Véhicule',
            'edit_vehicle_type' => 'Modifier Type de Véhicule',
            'edit_form_title' => 'Formulaire de Modification de Type de Véhicule',
            'table' => [
                'id' => 'ID',
                'vehicle_name' => 'Nom du Véhicule',
                'description' => 'Description',
                'is_pool' => 'Pour la Piscine',
                'status' => 'Statut',
                'action' => 'Action',
            ],
            'form' => [
                'vehicle_name' => 'Nom du Véhicule',
                'description' => 'Description',
                'vehicle_image' => 'Image du Véhicule',
                'vehicle_active_image' => 'Image Active du Véhicule',
                'vehicle_app_icon' => 'Icône de l\'application du Véhicule',
                'is_pool' => 'Pour la Piscine',
                'status' => 'Statut',
            ]
        ],
        'manage_vehicles' => [
            'title' => 'Gérer les Véhicules',
            'vehicles' => 'Véhicules',
            'add_vehicles' => 'Ajouter des Véhicules',
            'edit_vehicles' => 'Modifier les Véhicules',
            'add_vehicle_form' => 'Formulaire d\'ajout de Véhicule',
            'edit_vehicle_form' => 'Formulaire de Modification de Véhicule',
            'form' => [
                'company_name' => 'Nom de l\'Entreprise',
                'driver_name' => 'Nom du Conducteur',
                'vehicle_type' => 'Type de Véhicule',
                'make' => 'Marque',
                'model' => 'Modèle',
                'status' => 'Statut',
                'default' => 'Par Défaut',
                'handicap_accessibility_available' => 'Accessibilité Handicap Disponible',
                'child_seat_accessibility_available' => 'Accessibilité Siège Enfant Disponible',
                'request_form' => 'Formulaire de Demande',
                'vehicle_number' => 'Numéro du Véhicule',
                'color' => 'Couleur',
                'year' => 'Année',
                'expire_date' => 'Date d\'Expiration',
                'request_form_note' => 'Si le conducteur est un homme, il sera automatiquement sélectionné comme les deux.',
                'default_note' => 'Si le conducteur n\'a qu\'un seul véhicule avec un statut actif, il sera automatiquement sélectionné par défaut.'
            ],
            'table' => [
                'id' => 'ID',
                'company_name' => 'Nom de l\'Entreprise',
                'driver_name' => 'Nom du Conducteur',
                'vehicle_type' => 'Type de Véhicule',
                'make' => 'Marque/Modèle',
                'vehicle_number' => 'Numéro du Véhicule',
                'status' => 'Statut',
                'action' => 'Action',
            ]
        ],
        'manage_additional_reasons' => [
            'title' => 'Raisons Additionnelles',
            'add_additional_reason' => 'Ajouter une Raison Additionnelle',
            'edit_additional_reason' => 'Modifier une Raison Additionnelle',
            'add_title' => 'Formulaire d\'ajout de Raison Additionnelle',
            'edit_title' => 'Formulaire de Modification de Raison Additionnelle',
            'table' => [
                'id' => 'ID',
                'reason' => 'Raison',
                'status' => 'Statut',
                'action' => 'Action'
            ],
            'form' => [
                'reason' => 'Raison',
                'status' => 'Statut'
            ]
        ],
        'cancel_reasons' => [
            'title' => 'Raison d\'Annulation',
            'add_cancel_reason' => 'Ajouter une Raison d\'Annulation',
            'edit_cancel_reason' => 'Modifier une Raison d\'Annulation',
            'add_title' => 'Formulaire d\'ajout de Raison d\'Annulation',
            'edit_title' => 'Formulaire de Modification de Raison d\'Annulation',
            'translations' => 'Traductions',
            'remove' => 'Supprimer',
            'add_translations' => 'Ajouter des Traductions',
            'table' => [
                'id' => 'ID',
                'reason' => 'Raison',
                'cancelled_by' => 'Annulé par',
                'status' => 'Statut',
                'action' => 'Action',
            ],
            'form' => [
                'language' => 'Langue',
                'reason' => 'Raison',
                'cancelled_by' => 'Annulé par',
                'status' => 'Statut'
            ]
        ],
        'locations' => [
            'title' => 'Emplacements',
            'add_location' => 'Ajouter un Emplacement',
            'edit_location' => 'Modifier l\'Emplacement',
            'add_title' => 'Formulaire d\'Ajout d\'Emplacement',
            'edit_title' => 'Formulaire de Modification d\'Emplacement',
            'table' => [
                'id' => 'ID',
                'location_name' => 'Nom de l\'Emplacement',
                'status' => 'Statut',
                'action' => 'Action'
            ],
            'form' => [
                'name' => 'Nom',
                'status' => 'Statut'
            ]
        ],
        'manage_fares' => [
            'title' => 'Gérer les Tarifs',
            'add_manage_fare' => 'Ajouter un Tarif',
            'edit_manage_fare' => 'Modifier le Tarif',
            'add_title' => 'Formulaire d\'Ajout de Tarif',
            'edit_title' => 'Formulaire de Modification de Tarif',
            'peak_fare_details' => 'Détails du Tarif de Pointe',
            'night_fare_details' => 'Détails du Tarif de Nuit',
            'table' => [
                'id' => 'ID',
                'location_name' => 'Nom de l\'Emplacement',
                'vehicle_type' => 'Type de Véhicule',
                'apply_peak' => 'Appliquer Pointe',
                'apply_night' => 'Appliquer Nuit',
                'action' => 'Action',
            ],
            'form' => [
                'location' => 'Emplacement',
                'vehicle_type' => 'Type de Véhicule',
                'base_fare' => 'Tarif de Base',
                'capacity' => 'Capacité',
                'minimum_fare' => 'Tarif Minimum',
                'per_minutes' => 'Par Minute',
                'per_kilometer' => 'Par Kilomètre',
                'waiting_time_limit' => 'Limite de Temps d\'Attente (En Minutes)',
                'waiting_charges' => 'Frais d\'Attente (Par Minute)',
                'schedule_ride_fare' => 'Tarif de Course Programmée',
                'currency_code' => 'Code de Devise',
                'apply_peak_fare' => 'Appliquer le Tarif de Pointe',
                'apply_night_fare' => 'Appliquer le Tarif de Nuit',
                'day' => 'Jour',
                'start_time' => 'Heure de Début',
                'end_time' => 'Heure de Fin',
                'peak_fare' => 'Tarif de Pointe',
                'night_fare' => 'Tarif de Nuit'
            ]
        ],
        'manage_trip' => [
            'manage_ride_requests' => 'Gérer les Demandes de Course',
            'ride_requests' => 'Demandes de Course',
            'manage_trips' => 'Gérer les Voyages',
            'trips' => 'Voyages',
            'request_details' => [
                'request_status' => 'Chauffeur non encore attribué!',
                'vehicle_type' => 'Type de Véhicule',
                'rider_name' => 'Nom du Passager',
                'driver_name' => 'Nom du Chauffeur',
                'company_name' => 'Nom de l\'Entreprise',
                'pickup_address' => 'Adresse de Prise en Charge',
                'drop_address' => 'Adresse de Dépose',
                'ride_start_time' => 'Heure de Début du Trajet',
                'ride_end_time' => 'Heure de Fin du Trajet',
                'ride_status' => 'Statut du Trajet'
            ],
            'table' => [
                'id' => 'ID',
                'request_id' => 'ID de Demande',
                'rider_name' => 'Nom du Passager',
                'driver_name' => 'Nom du Chauffeur',
                'earned' => 'Gagné',
                'pickup_location' => 'Lieu de Prise en Charge',
                'drop_location' => 'Lieu de Dépose',
                'date_and_time' => 'Date et Heure',
                'status' => 'Statut',
                'amount' => 'Montant',
                'trip_date' => 'Date du Voyage',
                'company_name' => 'Nom de l\'Entreprise',
                'vehicle_details' => 'Détails du Véhicule',
                'payment_mode' => 'Mode de Paiement',
                'payment_status' => 'Statut de Paiement',
                'action' => 'Action',
                'reason' => 'Raison',
                'comments' => 'Commentaires',
                'cancelled_by' => 'Annulé Par',
                'cancel_at' => 'Annulé À',
                'time_fare' => 'Tarif Horaire',
                'distance_fare' => 'Tarif de Distance',
                'base_fare' => 'Tarif de Base',
                'is_pool' => 'Montant du Deuxième Passager (Partage)',
                'tips' => 'Pourboires',
                'additional_fee' => 'Frais Supplémentaires',
                'access_fee' => 'Frais d\'Accès',
                'admin_commission' => 'Commission Administrative',
                'total_fare' => 'Tarif Total',
                'earnings' => 'Gains',
                'car_name' => 'Nom de la Voiture',
                'trip_number' => 'Numéro de Trajet',
                'driver_rating' => 'Évaluation du Chauffeur',
                'rider_rating' => 'Évaluation du Passager',
                'rider_comments' => 'Commentaires du Passager',
                'driver_comments' => 'Commentaires du Chauffeur',
            ]
        ],
        'manage_owe_amounts' => [
            'title' => 'Gérer le Montant Dû',
            'owe_amount' => 'Montant Dû',
            'table' => [
                'id' => 'Id',
                'company_id' => 'ID de l\'Entreprise',
                'company_name' => 'Nom de l\'Entreprise',
                'trip_ids' => 'IDs des Trajets',
                'owe_amount' => 'Montant Dû',
                'remaining_owe_amount' => 'Montant Restant Dû',
                'action' => 'Action',
                'driver_id' => 'ID du Conducteur',
                'driver_name' => 'Nom du Conducteur',
            ]
        ]



    ],
    'home' => [
        'title' => 'Réservez des trajets partout',
        'desc' => 'Entrez le lieu de prise en charge et de dépose et profitez du trajet à un prix abordable.',
        'drivedesc' => 'Commencez à conduire avec :site_name, avec des récompenses et des gains exclusifs. Pratique au maximum.',
        'drive_you1' => 'Réservez votre taxi immédiat',
        'goals1' => "Quel que soit le moment, l'utilisateur peut réserver son trajet avec le type de taxi souhaité, que ce soit SUV, berline ou autre, pour commencer le trajet à domicile.",
        "siginup" => "S\'inscrire",
        'or' => 'Ou',
        'siginup_drive' => 'Inscrivez-vous pour conduire',
        'siginup_company' => 'Inscrivez-vous pour l\'entreprise',
        'company' => 'Entreprise',
        'company_history' => 'Trouvez tout ce dont vous avez besoin pour suivre votre succès au sein de l\'entreprise.',
        'company_signin' => 'CONNEXION ENTREPRISE',
        'company_signup' => 'INSCRIPTION ENTREPRISE',
        'become_company' => 'DEVENEZ UNE ENTREPRISE',
        'rider_acnt' => 'avec votre compte passager.',
        'aggrement' => 'En continuant, j\'accepte que',
        'easy_way' => 'Le moyen le plus simple',
        'easy_content' => 'Un clic et une voiture vient directement à vous. Montez – votre chauffeur sait exactement où aller. Et quand vous y arrivez, descendez simplement. Le paiement est complètement transparent.',
        'anywhere' => 'Partout, à tout moment',
        'anywhere_content' => 'Trajets quotidiens. Courses en ville. Vol tôt le matin. Sorties tardives. Où que vous alliez, comptez sur nous pour un trajet – pas de réservation nécessaire.',
        'lowcost' => 'De bon marché à luxe',
        'lowcost_content' => 'Des voitures économiques à des prix abordables sont toujours disponibles. Pour les occasions spéciales, ou lorsque vous avez juste besoin de plus d\'espace, appelez une voiture noire ou un SUV.',
        'reason' => 'Raisons de rouler',
        'drive_you' => 'Conduisez quand vous voulez',
        'you_need' => 'Gagnez ce dont vous avez besoin',
        'drive_with' => 'Conduire avec',
        'goals' => ' est flexible et gratifiant, aidant les conducteurs à atteindre leurs objectifs professionnels et financiers.',
        'suprt' => 'Soutien pour les conducteurs affectés par l\'interdiction d\'immigration',
        'provide' => 'Nous offrons un accès à une assistance juridique 24/7 pour les conducteurs touchés par l\'interdiction et une assistance financière pour les conducteurs bloqués à l\'étranger.',
        'now_arrive' => 'Arrivée maintenant',
        'safe' => 'Villes sûres et modernes',
        'helping' => 'Aider les villes à prospérer',
        'city_with' => 'Une ville avec',
        'city_with_content' => 'offre plus de moyens de gagner de l\'argent, a moins de conducteurs ivres sur la route, et fournit un transport partout, à tout moment.',
        'safe_ride' => 'Trajets sûrs pour tous',
        'backseat' => 'Que ce soit en tant que passager à l\'arrière ou conducteur à l\'avant, chaque partie de l\'expérience',
        'designed' => 'est conçue autour de votre sécurité et de votre protection.',
        'fare' => 'estimation du tarif',
        'how_much' => 'Combien coûte ',
        'cost' => 'dans votre ville ? Calculez une estimation du tarif pour votre prochain trajet. Entrez simplement un lieu de prise en charge et une destination pour commencer.',
        'get_started' => 'Commencer',
        'invalid_mobile_no' => 'Numéro de mobile invalide. Veuillez réessayer.',
        'field_is_required' => 'est requis',
    ],

    'help' => [
        'welcome' => 'Bienvenue ! Comment pouvons-nous vous aider ?',
        'search_anything' => 'Recherchez n\'importe quoi',
        'help_center' => 'Centre d\'aide',
        'suggested_helps' => 'Liste d\'aides suggérées',
        'no_suggested_helps' => 'Aucune aide suggérée !',
        'no_results_found' => 'Aucun résultat trouvé',
        'back' => 'Retour',
    ],
    'footer' => [
        'siginup_ride' => 'Inscrivez-vous pour rouler',
        'driver' => 'Devenez chauffeur',
        'ride' => 'Rouler',
        'drive' => 'Conduire',
        'rider_app' => 'Application Passager',
        'driver_app' => 'Application Chauffeur',
        'safety' => 'Sécurité',
        'using_cookies' => 'Cookies : :site_name utilise des cookies pour améliorer l\'expérience utilisateur. En utilisant notre site web, vous consentez à nos cookies conformément à notre',
    ],
    'header' => [
        'profile' => 'Votre profil',
        'profil' => 'Profil',
        'credit_card' => 'Ajouter une carte de crédit',
        'verify_email' => 'Vérifier l\'email',
        'mytrips' => 'Mes trajets',
        'payment' => 'Paiement',
        'logout' => 'Déconnexion',
        'invoice' => 'Facture',
        'signin' => 'Connexion',
        'location' => 'Kochi',
        'use_location' => 'Nous utilisons votre emplacement pour personnaliser les informations que vous voyez.',
        'chng_location' => 'CHANGER D\'EMPLACEMENT',
        'back' => 'Retour',
        'require' => 'Exigences',
        'app' => 'Application Chauffeur',
        'area' => 'Pas à Kochi ? Veuillez entrer votre emplacement pour nous aider à afficher les informations correctes pour votre région.',
        'how_it_works' => 'Comment ça marche',
        'menu' => 'Menu',
        'help' => 'Aide',
    ],
    'dashboard' => [
        'trip_invoice' => 'Factures de trajet',
        'invoice_no' => 'Numéro de facture',
        'trip_date' => 'Date du trajet',
        'invoice' => 'Facture',
        'invoice_issued' => 'Facture émise par',
        'behalf' => 'au nom de :',
        'date' => 'Date',
        'desc' => 'Description',
        'net_amt' => 'Montant net',
        'payment_mode' => 'Mode de paiement',
        'base_fare' => 'Tarif de base',
        'distance_fare' => 'Tarif distance',
        'time_fare' => 'Tarif temps',
        'total_fare' => 'Tarif total du trajet',
        'admin_amt' => 'Montant de l\'administrateur',
        'owe_amt' => 'Montant dû',
        'driver_payout' => 'Paiement du chauffeur',
        'cash_collect' => 'Argent collecté',
        'total_payout' => 'Paiement total',
        'access_fee' => 'Frais d\'accès',
        'wallet_amt' => 'Montant du portefeuille',
        'promo_amt' => 'Montant promo',
        'paid_amt' => 'Montant payé',
        'payment_methods' => 'Méthodes de paiement',
        'personal_cash' => 'Argent personnel',
        'personal_paytm' => 'Paytm personnel',
        'promotions' => 'Promotions',
        'apply' => 'Appliquer',
        'no_active' => 'Aucune promotion active',
        'gratuity' => 'Gratuité pour TAXI',
        'preferred' => 'Votre pourboire préféré sera appliqué à tout futur trajet en TAXI que vous demandez via',
        'taxi' => 'Cela s\'appliquera uniquement aux tarifs TAXI (pas Black, SUV, ou',
        'paid' => 'et sera payé à votre chauffeur. La gratuité ne s\'applique que dans certains pays.',
        'taxi_gratuity' => 'Pourboire TAXI',
        'save' => 'Enregistrer',
        'dwnld_invoice' => 'Télécharger les factures pour les trajets effectués par vous et vos chauffeurs. Veuillez noter que les tarifs sont sujets à ajustements par',
        'feedback' => 'basé sur les retours des clients. Vos factures refléteront ces ajustements.',
        'download' => 'Télécharger',
        'print' => 'Imprimer',
        'pdf' => 'PDF',
        'no_details' => 'Aucun détail trouvé',
        'schedule_fare' => 'Tarif planifié',
        'peak_fare' => 'Tarif de pointe',
        'upload_file' => 'TÉLÉCHARGÉ',
    ],
    'profile' => [
        'general' => 'Informations générales',
        'location' => 'Emplacement',
        'mobile' => 'Mobile',
        'email' => 'Adresse e-mail',
        'profile_photo' => 'Photo de profil',
        'filter' => 'Filtrer les trajets',
        'timeframe' => 'Période',
        'pickup' => 'Prise en charge',
        'driver' => 'Chauffeur',
        'rider' => 'Passager',
        'fare' => 'Tarif',
        'car' => 'Voiture',
        'inactive_user' => 'Vous avez soumis avec succès la demande de suppression de votre compte.',
        'view_detail' => 'Voir le détail',
        'your_trip' => 'Votre trajet',
        'dwnld_invoice' => 'Télécharger la facture',
        'kilometer' => 'Kilomètres',
        'trip_time' => 'Temps de trajet',
        'rode_with' => 'A roulé avec',
        'phone' => 'Téléphone',
        'addr' => 'Adresse',
        'profile_city' => 'Ville',
        'state' => 'État',
        'country' => 'Pays',
        'profile_postal_code' => 'Code postal',
        'fare_break' => 'DÉTAIL DU TARIF',
        'you_rode' => 'Vous avez roulé avec',
        'track_every' => 'Trouvez tout ce dont vous avez besoin pour suivre votre succès sur la route.',
        'driver_signin' => 'Connexion chauffeur',
        'driver_signup' => 'Inscription chauffeur',
        'trip_history' => 'Gérez vos options de paiement, consultez l\'historique des trajets, et plus encore.',
        'rider_signin' => 'Connexion passager',
        'rider_signup' => 'Inscription passager',
        'name' => 'Nom',
        'gender' => 'Sexe',
        'male' => 'Homme',
        'female' => 'Femme',
        'phone_number' => 'Numéro de téléphone',
        'change' => 'Changer',
        'payment_method' => 'Méthode de paiement',
    ],
    "drive" => [
        "start_drive_with" => "Commencez à conduire avec",
        "works_first" => "Un travail qui vous met en premier",
        "drive_you_need" => "Conduisez quand vous le souhaitez, gagnez ce dont vous avez besoin",
        "own_schedule" => "Définissez votre propre emploi du temps",
        "drive_with" => "Vous pouvez conduire avec",
        "anytime" => "à tout moment, jour ou nuit, 365 jours par an. Quand vous conduisez, c'est toujours à vous de décider, donc cela n'interfère jamais avec les choses importantes de votre vie.",
        "every_turn" => "Gagnez plus à chaque virage",
        "fare_start" => "Les tarifs des trajets commencent avec un montant de base, puis augmentent en fonction du temps et de la distance. Et lorsque la demande est plus élevée que d'habitude, les conducteurs gagnent plus.",
        "app_lead" => "Laissez l'application vous guider",
        "tap_go" => "Appuyez simplement et partez. Vous recevrez des instructions étape par étape, des outils pour vous aider à gagner plus, et une assistance 24/7. Et si vous n'avez pas de smartphone, nous pouvons vous en fournir un.",
        "hit_road" => "Prenez la route",
        "easy_started" => "C'est facile de commencer",
        "sign_online" => "Inscrivez-vous en ligne",
        "about_yourself" => "Dites-nous un peu sur vous et votre voiture. Les exigences des véhicules varient selon les régions, nous vous montrerons donc ce qui est nécessaire pour votre ville.",
        "share_doc" => "Partagez quelques documents",
        "upload_license" => "Il suffit de télécharger votre permis, votre enregistrement, votre preuve d'assurance et les informations nécessaires pour commencer un contrôle de conducteur.",
        "get_app" => "Obtenez l'application et partez",
        "approve_drive" => "Une fois approuvé pour conduire avec",
        "provide_you_need" => "en tant que contractant indépendant, nous vous fournirons tout ce dont vous avez besoin pour réussir sur la route.",
        "signup_now" => "INSCRIVEZ-VOUS MAINTENANT",
        "about_app" => "À propos de l'application",
        "design_drivers" => "Conçue spécialement pour les conducteurs",
        "make_money" => "Quand vous voulez gagner de l'argent, il vous suffit d'ouvrir l'application et vous commencerez à recevoir des demandes de trajet. Vous recevrez des informations sur votre passager et des indications vers leur emplacement et destination. Lorsque le trajet est terminé, vous recevrez une autre demande à proximité. Et si vous êtes prêt à quitter la route, vous pouvez vous déconnecter à tout moment.",
        "safety_screen" => "Sachez que vous êtes prêt à prendre la route. Que vous conduisiez votre propre voiture ou un véhicule commercialement licencié, vous devez répondre aux exigences minimales et compléter un contrôle de sécurité en ligne.",
        "rewards" => "Récompenses",
        "drive_seat" => "Vous êtes aux commandes. Alors récompensez-vous avec des réductions sur le carburant, l'entretien du véhicule, les factures de téléphone portable, et plus encore. Réduisez vos dépenses quotidiennes et ramenez des gains supplémentaires en conduisant plus.",
        "vehicle_solution" => "Solutions de véhicule",
        "need_car" => "Besoin d'une voiture ? Nous pouvons vous mettre en contact avec des partenaires qui offrent des offres exclusives sur les véhicules qui peuvent vous mettre sur la route et vous permettre de gagner. Beaucoup offrent des politiques de retour flexibles et sans limitation de kilométrage afin que vous puissiez conduire et gagner autant que vous le souhaitez.",
        "you_with" => "Quand vous conduisez avec",
        "support" => "vous obtenez une assistance 24/7 et une couverture d'assurance. Et tous les passagers sont vérifiés avec leurs informations personnelles et leur numéro de téléphone, donc vous saurez qui vous prenez en charge et nous aussi.",
        "making_money" => "Commencez à gagner de l'argent",
        "ready_money" => "Prêt à gagner de l'argent ? La première étape est de vous inscrire en ligne.",
        "support" => "Soutien à chaque étape",
        "we_want" => "Nous voulons que chaque",
        "hassle_free" => "trajet soit sans tracas. Nous sommes donc là pour vous aider avec la configuration de votre compte, les ajustements de tarifs, et plus encore quand vous en avez besoin.",
        "safety_behind" => "Sécurité au volant",
        "out_commitment" => "Notre engagement envers les conducteurs",
        "keeping_safe" => "est dédié à garder les gens en sécurité sur la route. Notre technologie nous permet de nous concentrer sur la sécurité des conducteurs avant, pendant et après chaque trajet.",
        "before_trip" => "Avant le trajet",
        "picking_up" => "Prendre des passagers",
        "anonymous_pickup" => "Pas de prises en charge anonymes",
        "riders_account" => "Tous les passagers doivent créer un compte et fournir leur nom, adresse e-mail et numéro de téléphone avant de pouvoir demander un trajet. Ainsi, lorsque vous acceptez une demande, vous saurez qui vous prenez en charge et nous aussi.",
        "sub_number" => "Numéros de téléphone substitutifs",
        "location_around_world" => "Dans de nombreux endroits à travers le monde,",
        "stays_private" => "utilise une technologie qui anonymise les numéros de téléphone pour garder les coordonnées confidentielles. Ainsi, lorsque vous et votre passager avez besoin de vous contacter, vos informations personnelles restent privées.",
        "on_trip" => "Pendant le trajet",
        "getting_destination" => "Se rendre à la destination",
        "app_navigation" => "Navigation intégrée à l'application",
        "riders_enter" => "Lorsque les passagers saisissent leur destination, vous recevrez automatiquement des instructions étape par étape dans l'application - pour que vous puissiez vous concentrer sur le trajet en toute sécurité.",
        "on_the_map" => "Toujours sur la carte",
        "gps_data" => "Les données GPS sont enregistrées pour chaque trajet afin que nous sachions qui vous conduisez et où vous allez, ce qui favorise la responsabilité et encourage un bon comportement.",
        "after_trip" => "Après le trajet",
        "improving" => "Toujours améliorer l'expérience",
        "experience" => "",
        "no_change" => "Pas de monnaie, pas de tracas",
        "fares_atuo" => "Les tarifs sont automatiquement facturés sur le mode de paiement enregistré du passager, donc pour la plupart des trajets, vous pouvez éviter d'utiliser des espèces. Mais si un passager paie en espèces, l'application émet automatiquement un crédit pour que vous n'ayez jamais à faire de la monnaie.",
        "driver_feedback" => "Commentaires des conducteurs",
        "rate_your_driver" => "Vous évaluez votre passager après chaque trajet. Nous examinons ces évaluations pour nous assurer que tous ceux que vous prenez en charge sont aussi respectueux que vous. Les passagers signalés pour avoir enfreint nos conditions de service peuvent être empêchés d'utiliser",
        "drive_safely" => "Conduisez en toute sécurité avec",
        "information" => "Les informations fournies sur cette page Web sont destinées à des fins informatives uniquement et peuvent ne pas être applicables dans votre pays, région ou ville. Elles sont susceptibles de changer et peuvent être mises à jour sans préavis.",
        "drivers_first" => "Mettre les conducteurs en premier",
        "exp_around" => "Une expérience construite autour de vous",
        "control_with" => "Vous êtes aux commandes avec",
        "app_for_drivers" => "L'application pour les conducteurs est conçue avec des fonctionnalités qui vous aident à décider comment, où et quand vous gagnez.",
        "going_online" => "Aller en ligne",
        "always_avail" => "est toujours disponible. Donc, chaque fois que vous êtes prêt à conduire, ouvrez l'application et appuyez sur Go Online.",
        "accept_trip_request" => "Accepter les demandes de trajet",
        "receive_trip_request" => "Une fois en ligne, vous commencerez automatiquement à recevoir des demandes de trajet dans votre région. Votre téléphone émettra un bip et l'écran clignotera - appuyez pour accepter.",
        "turn_by_turn" => "Directions étape par étape",
        "provides_navigation" => "L'application fournit la navigation vers le lieu de prise en charge de votre passager, et nous les informerons lorsque vous serez presque arrivé. Une fois le trajet commencé, vous recevrez des indications vers leur destination.",
        "track_earnings" => "Suivez vos gains",
        "summaries" => "Après chaque trajet, vous verrez exactement combien vous avez gagné et des résumés complets de votre total de la journée. Les gains sont automatiquement transférés sur votre compte bancaire chaque semaine, ou vous pouvez retirer instantanément jusqu'à 5 fois par jour.",
        "rating" => "Système de notation",
        "rider_driver_rate" => "Les évaluations sont une voie à double sens. Les passagers et les conducteurs s'évaluent après chaque trajet pour s'assurer que seules les personnes respectueuses et courtoises sont autorisées sur la plateforme.",
        "platform" => "",
        "communication" => "Communication",
        "feedback_success" => "Commentaires pour réussir",
        "stay_informed" => "Restez informé",
        "customized_updates" => "Recevez des mises à jour personnalisées sur les événements locaux et les promotions dans votre ville, et des conseils sur comment offrir la meilleure",
        "rider_comment" => "Commentaires des passagers",
        "rating_section" => "Utilisez la section des évaluations pour savoir ce que les gens aiment dans leurs trajets 5 étoiles et découvrir pourquoi les passagers donnent des notes basses afin que vous puissiez décider comment ajuster en conséquence.",
        "start_drive_now" => "Commencez à conduire maintenant",
        "start_drive_nowive" => "Conduisez avec",
        "earn_your_terms" => "et gagnez selon vos propres termes.",
        "already_signed_up" => "Déjà inscrit?",
        "invite_friends" => "Invitez vos amis à essayer",
        "you_earn" => "et vous gagnerez plus lorsqu'ils prendront la route.",
        "info_page" => "Les informations fournies sur cette page Web sont destinées à des fins informatives uniquement et peuvent ne pas être applicables dans votre pays, région ou ville. Elles sont susceptibles de changer et peuvent être mises à jour sans préavis.",
        "driver_requirments" => "Exigences pour les conducteurs",
        "how_to_drive" => "Comment conduire avec",
        "own_boss" => "est un excellent moyen d'être votre propre patron et de gagner beaucoup d'argent. Du permis de conduire commercial à la voiture,",
        "help_you_every" => "peut vous aider à chaque étape.",
        "min_requirments" => "Exigences minimales",
        "commercial_license" => "Pour conduire à New York, vous aurez besoin d'un permis de conduire commercial de la NYC TLC (Taxi and Limousine Commission) et d'un véhicule commercialement licencié.",
        "help_you_both" => "peut vous aider avec les deux.",
        "what_you_need" => "Voici ce dont vous aurez besoin:",
        "driver_license" => "Un permis de conduire américain valide",
        "tlc_license" => "Un permis de conduire TLC",
        "tlc_license_vehicle" => "Un véhicule licencié par la TLC (vous pouvez en louer un ou enregistrer le vôtre)",
        "require_documents" => "Documents requis",
        "addition_documents" => "En plus des exigences ci-dessus, vous aurez également besoin des documents suivants:",
        "proof_insurance" => "Preuve d'assurance commerciale",
        "proof_vehicle_registration" => "Preuve d'immatriculation commerciale du véhicule",
        "vehicle_permit" => "Un permis de véhicule de location TLC",
        "ready_make_money" => "Prêt à gagner de l'argent?",
        "first_step" => "La première étape est de vous inscrire"
    ],
    "driver_dashboard" => [
        "vehicle_status" => "Statut du véhicule",
        "vehicle_add" => "Ajouter",

        "add_vehicle" => "Ajouter un véhicule",
        "make" => "Marque",
        "model" => "Modèle",
        "year" => "Année",
        "license_plate" => "Plaque d'immatriculation",
        "vehicle_color" => "Couleur du véhicule",
        "reupload" => "RE-TÉLÉCHARGER LES DOCUMENTS",
        "make_year" => "2015",
        "make_company" => "Tata",
        "make_product" => "Indica",
        "reg_no" => "TN22DA0103",
        "type" => "VIN",
        "upload_documents" => "Télécharger le document: Permis de conduire - (Arrière/Inverse)",
        "select_file" => "Sélectionner le fichier et télécharger",
        "contract_carriage" => "Télécharger le document: Permis de transport de marchandises",
        "back_profile" => "Retour au profil",
        "driver_license_back" => "Permis de conduire - (Arrière/Inverse)",
        "upload" => "Télécharger",
        "driver_license_front" => "Permis de conduire - (Avant)",
        "motor_insurance" => "Certificat d'assurance automobile",
        "reg_certificate" => "Certificat d'immatriculation",
        "carriage_permit" => "Permis de transport de marchandises",
        "upload_driver_license" => "Télécharger le document: Permis de conduire - (Arrière/Inverse)",
        "banking_details" => "Détails du compte bancaire",
        "payment_details" => "Détails de paiement invalides",
        "weekly_payout" => "Défini pour recevoir un paiement hebdomadaire",
        "ifsc" => "Code IFSC",
        "ifsc_code" => "KVBL00016",
        "bank" => "Nom de la banque",
        "bank_name" => "KARUR VYSYA BANK",
        "account" => "Numéro de compte bancaire",
        "account_no" => "xxxxxxxxxxxx40",
        "account_name" => "Nom du titulaire du compte (exactement comme sur votre relevé bancaire)",
        "driver_address" => "Adresse",
        "address" => "Kk Nagar",
        "driver_city" => "Ville",
        "city" => "Chennai",
        "driver_postal_code" => "Code postal",
        "postal_code" => "600078",
        "driver_dob" => "Date de naissance",
        "dob" => "2015-06-10",
        "under_req_age" => "Sous l'âge requis",
        "download_invoice_driver" => "Téléchargez les factures pour les trajets effectués par vous et vos chauffeurs. Veuillez noter que les tarifs sont sujets à des ajustements par  en fonction des retours clients. Vos factures refléteront ces ajustements.",
        "client_feedback" => "en fonction des retours clients. Vos factures refléteront ces ajustements.",
        "total_earnings" => "Gains totaux",
        "pay_period" => "PÉRIODE DE PAIEMENT",
        "current_statement" => "Déclaration actuelle",
        "all_statement" => "Voir toutes les déclarations",
        "completed_trips" => "Trajets terminés",
        "acceptance_rate" => "Taux d'acceptation",
        "cancelled_trips" => "Trajets annulés",
        "daily_earnings" => "Gains quotidiens",
        "status" => "Statut",
        "all_trips" => "Tous les trajets",
        "pickup_time" => "Heure de prise en charge",
        "vehicle" => "Véhicule",
        "duration" => "Durée",
        "distance" => "Distance(km)",
        "add_photo" => "Ajouter une photo",
        "manage_documents" => "Gérer les documents",
        "driver_documents" => "Documents du conducteur",
        "vehicle_documents" => "Documents du véhicule",
        "select_upload" => "Sélectionner le fichier et télécharger",
        "Active" => "Actif",
        "Inactive" => "Inactif",
        "Pending" => "En attente",
        "Car_details" => "Détails de la voiture",
        "Document_details" => "Détails du document",

        "edit" => "Modifier",
        "set_as_default" => "Définir comme par défaut",
        "delete" => "Supprimer",
        "vehicle_details" => "Détails du véhicule",
        "vehicle_make" => "Marque du véhicule",
        "vehicle_model" => "Modèle du véhicule",
        "vehicle_number" => "Numéro de véhicule",
        "vehicle_color" => "Couleur du véhicule",
        "vehicle_year" => "Année du véhicule",
        "vehicle_type" => "Type de véhicule",
        "default_vehicle_inactive_error" => "Le véhicule sélectionné est inactif. Vous ne pouvez donc pas le définir comme véhicule par défaut",
        "default_vehicle_intrip_error" => "Le véhicule par défaut est déjà en cours de trajet, vous ne pouvez donc pas définir ce véhicule comme par défaut",
        "default_success_msg" => "Le véhicule par défaut a été mis à jour avec succès",
        "select" => "Sélectionner",

        "handicap" => "Handicap",
        "child_seat" => "Siège enfant",
        "request_from" => "Demande de",
        "both" => "Les deux",
        "yes" => "Oui",
        "no" => "Non",
        "available" => "Disponible"
    ],
    "errors" => [
        "unauthorize" => "Action non autorisée.",
        "content_block" => "Le contenu que vous avez demandé est introuvable.",
        "oops" => "Oups !",
        "cannot_find" => "Nous ne trouvons pas la page que vous recherchez.",
        "be_right_back" => "De retour bientôt"
    ],
    'ride' => [
        'ride_with_Ridein' => 'Commencez à voyager avec :site_name',
        'how_works' => 'Comment :site_name fonctionne',
        'request' => 'Demande',
        'request_content' => 'Appuyez sur chaque option de livraison pour voir le temps d\'attente, les tailles et les prix. Choisissez un tarif fixe de 30 $ Pick-up Truck, 40 $ Flat Bed Truck, 50 $ Box Truck dans votre comté. Ensuite, entrez votre lieu de prise en charge et appuyez sur demande — votre chauffeur arrivera en quelques minutes.',
        'delivery' => 'Livraisons',
        'delivery_content' => 'Votre chauffeur vient à vous. Vous verrez les informations de contact de votre chauffeur et les détails du véhicule dans l\'application, donc vous savez que vous montez dans la bonne voiture.',
        'pay_go' => 'Payer et partir',
        'pay_go_content' => 'Descendez et évaluez votre chauffeur lorsque vous atteignez votre destination. Nous débitons automatiquement la carte de crédit enregistrée, donc vous n\'avez jamais besoin d\'argent liquide.',
        'faq' => 'FAQ',
        'what_expect' => 'À quoi s\'attendre en chemin',
        'make_reserve' => 'Puis-je faire une réservation?',
        'make_reserve_content' => 'Le service à la demande est disponible dans chaque ville où nous opérons. Lorsque vous êtes prêt à voyager, utilisez votre application pour demander une prise en charge par un chauffeur à proximité. La demande de trajets peut fluctuer à différents moments de la journée et de la nuit. Une forte demande de trajets à un certain moment peut avoir un impact sur la rapidité avec laquelle un chauffeur accepte votre demande de trajet et se dirige vers votre lieu de prise en charge. Si vous êtes pressé, nous vous recommandons de vérifier l\'ETA de votre lieu de prise en charge pour différentes options de véhicules environ 15 à 30 minutes avant d\'être prêt à voyager. :site_name dans certaines villes inclut désormais l\'option de planifier un trajet :site_nameX. Voici comment :site_name',
        'schedule_ride' => 'Appuyez sur le bouton PLANIFIER UN TRAJET ci-dessus le curseur des options de véhicules.',
        'select_date' => 'Sélectionnez une date et une fenêtre de 15 minutes préférées lorsque vous serez prêt à être pris en charge.',
        'select_pickup_location' => 'Entrez votre lieu de prise en charge et votre destination.',
        'review_fare' => 'Consultez votre estimation de tarif et appuyez sur PLANIFIER.',
        'after_confirm' => 'Appuyez sur PLANIFIER LE TRAJET pour confirmer. Après confirmation, sélectionnez TRAJETS dans le menu de votre application, puis sélectionnez À VENIR pour consulter les trajets planifiés à venir ou planifier un nouveau trajet. Si vous devez annuler un trajet planifié, appuyez sur ANNULER. Lorsque la date et l\'heure pour lesquelles vous avez planifié un trajet approchent, les chauffeurs à proximité recevront votre demande de trajet. Le chauffeur qui accepte cette demande de trajet peut arriver à votre lieu de prise en charge à tout moment dans votre fenêtre de 15 minutes. Nous vous recommandons d\'être prêt et disponible pour la prise en charge pendant toute la durée du trajet. Un chauffeur qui ne peut pas vous localiser à l\'emplacement de prise en charge peut annuler le trajet après 5 minutes. Veuillez noter que des tarifs de pointe peuvent s\'appliquer à un trajet planifié. Cela peut avoir un impact sur le tarif de votre trajet. Consultez le lien ci-dessous pour voir où les trajets planifiés sont disponibles près de chez vous.',
        'do_i_need' => 'Ai-je besoin de donner un pourboire?',
        'do_i_need_content' => 'L\'application :site_name ne peut pas inclure un pourboire lors de la facturation du tarif d\'un trajet. Là où disponible en tant qu\'option de véhicule, :site_name est une exception. Dans la plupart des villes, :site_name est une expérience sans argent liquide. Donner un pourboire est volontaire. Les pourboires ne sont pas inclus dans le tarif, ils ne sont pas non plus attendus ou requis. En tant que passager, vous n\'êtes pas obligé d\'offrir un pourboire à votre chauffeur en espèces. Si vous décidez que vous souhaitez donner un pourboire, votre chauffeur est autorisé à l\'accepter.',
        'cancel_request' => 'Annulation de ma demande',
        'cancel_request_content' => 'Les demandes de trajet doivent être faites uniquement lorsque vous êtes prêt à voyager et près du lieu de prise en charge. Cela permet aux chauffeurs de fonctionner efficacement sur la plateforme :site_name. Parfois, vous pouvez souhaiter annuler une demande de trajet après qu\'elle a été acceptée par un chauffeur. Bien que l\'application :site_name vous permette d\'annuler à tout moment, des frais d\'annulation peuvent être facturés. Ces frais sont destinés à compenser les chauffeurs pour le temps et les efforts consacrés à se rendre à un lieu de prise en charge. Une demande de trajet peut être annulée gratuitement après votre demande initiale. Si votre chauffeur a plus de 5 minutes de retard par rapport à l\'ETA fournie, vous pouvez annuler la demande de trajet sans encourir de frais d\'annulation. Sur les trajets :site_name, des frais d\'annulation de 2 $ peuvent vous être facturés si vous annulez à tout moment une fois qu\'un chauffeur a accepté votre demande de trajet. J\'ai été facturé des frais d\'annulation. Nous sommes heureux de revoir et d\'apporter des ajustements si nécessaire.',
        'start_riding' => 'Commencez à rouler',
        'start_riding_content' => 'Vous avez des endroits où aller. Laissez vos clés à la maison et demandez un trajet.',
        'already_have_account' => 'Vous avez déjà un compte?',
        'invite' => 'Invitez vos amis à faire un tour avec :site_name.',
        'always_ride' => 'Toujours la course que vous voulez',
        'get_whatever' => 'Le meilleur moyen d\'aller où que vous alliez',
        'tap_button' => 'Appuyez sur un bouton, obtenez un trajet',
        'tap_button_content' => 'Choisissez votre trajet et définissez votre emplacement. Vous verrez la photo de votre chauffeur et les détails du véhicule, et pourrez suivre son arrivée sur la carte.',
        'always_on' => 'Toujours actif, toujours disponible',
        'always_on_content' => 'Pas d\'appels à passer, pas de prise de rendez-vous à planifier. Avec une disponibilité 24/7, demandez un trajet à tout moment, jour et nuit, toute l\'année.',
        'we_listen' => 'Vous notez, nous écoutons',
        'we_listen_content' => 'Évaluez votre chauffeur et donnez des retours anonymes sur votre trajet. Votre avis nous aide à rendre chaque trajet une expérience 5 étoiles.',
        'every_price' => 'Il y a un trajet pour chaque prix',
        'any_occasion' => 'Et pour toute occasion',
        'economy' => 'Économique',
        'premium' => 'Premium',
        'accessibility' => 'Accessibilité',
        'start_finish' => 'Du début à la fin, un trajet sur lequel vous pouvez compter',
        'your_safety' => 'Votre sécurité est importante pour nous avant, pendant et après chaque trajet. C\'est pourquoi nous continuons à développer une technologie qui rend des millions de trajets plus sûrs chaque jour.',
        'keep_safe' => 'COMMENT NOUS VOUS GARDONS EN SÉCURITÉ',
        'your_first' => 'Votre premier',
        'min_away' => 'est à quelques minutes',
        'business_travel' => 'Voyage d\'affaires',
        'trip_seperate' => 'Gardez les trajets professionnels séparés',
        'trip_seperate_content' => 'Que vous vous dirigiez vers l\'aéroport, une réunion en ville ou chez vous après une soirée tardive au bureau,',
        'hard_as' => 'travaille aussi dur que vous.',
        'pool' => 'POOL',
        'share_save' => 'Partagez votre trajet et économisez',
        'pool_content' => 'POOL vous met en correspondance avec des passagers se dirigeant dans la même direction. C\'est toujours le moyen le moins cher de',
        'ride_adds' => 'Et partager le trajet n\'ajoute que quelques minutes à votre trajet.',
        'airport' => 'Aéroports',
        'shuttle' => 'Évitez la navette aéroportuaire',
        'shuttle_content' => 'Demandez un trajet à la demande dans plus de 400 aéroports à travers le monde. Et avec plusieurs options de véhicules, il y a beaucoup de place pour tous vos bagages.',
        'trip_safety' => 'Sécurité du trajet',
        'commitment_riders' => 'Notre engagement envers les passagers',
        'people_safe' => 'est dédié à maintenir la sécurité des personnes sur la route. Notre technologie nous permet de nous concentrer sur la sécurité des passagers avant, pendant et après chaque trajet. Voici comment.',
        'getting_safe_ride' => 'Obtenir un trajet sûr',
        'safe_pickups' => 'Prises en charge sécurisées',
        'find_location' => 'L\'application trouve automatiquement votre emplacement pour fournir un service de porte à porte. Cela signifie que vous restez en sécurité et à l\'aise où que vous soyez jusqu\'à l\'arrivée de votre chauffeur.',
        'open_everyone' => 'Ouvert à tous, partout',
        'request_blindly' => 'Toutes les demandes de trajet sont anonymement attribuées au chauffeur le plus proche disponible. Il n\'y a donc aucune discrimination basée sur la race, le genre ou la destination.',
        'driver_profile' => 'Profils des chauffeurs',
        'driver_profile_content' => 'Lorsque vous êtes associé à un chauffeur, vous verrez leur nom, leur numéro de plaque d\'immatriculation, leur photo et leur évaluation, vous saurez donc qui viendra vous chercher à l\'avance. Et même après le trajet, vous pouvez contacter votre chauffeur si vous avez oublié quelque chose.',
        'destination' => 'Atteindre votre destination',
        'eta' => 'Partagez votre ETA',
        'eta_content' => 'Une fois que votre chauffeur vous a pris en charge, partagez votre ETA avec vos amis et votre famille afin qu\'ils puissent suivre votre itinéraire et savoir quand vous attendre.',
        'follow_trip' => 'Suivez votre trajet en temps réel pour savoir toujours où vous êtes. Et si vous utilisez',
        'follow_trip_content' => 'POOL, vous saurez exactement qui vous accompagne.',
        'always_here' => 'Toujours là pour vous',
        'anonymous_feedback' => 'Retours anonymes',
        'anonymous_feedback_content' => 'Après chaque trajet, vous pouvez évaluer le chauffeur et donner des retours anonymes sur votre trajet. Nous examinons tous les retours car notre objectif est de faire de chaque trajet une excellente expérience.',
        'support_head' => 'Support 24/7',
        'support_head_content' => 'Notre équipe de support est toujours prête à répondre à toutes vos questions sur votre trajet et à vous aider à récupérer des objets perdus.',
        'rapid_response' => 'Réponse rapide',
        'rapid_response_content' => 'Nos équipes d\'intervention spécialement formées sont disponibles 24h/24 pour gérer toute préoccupation urgente qui survient.',
        'work_event' => '« Je travaille à des événements tard dans la nuit, et avec ',
        'feel_safer' => 'Je me sens plus en sécurité en sachant que je n\'ai pas à attendre dehors en espérant pouvoir héler un trajet. »',
        'feel_safer_name' => 'Brittany,',
        'rider_from' => 'Passager de Portland',
        'app_offline' => 'Dans l\'application et hors ligne',
        'imporving_experience' => 'Amélioration des expériences avec la technologie',
        'sub_phone_number' => 'Numéros de téléphone substituts',
        'assisting' => "Assistance aux forces de l'ordre",
        'assisting_content' => "Dans les cas où les forces de l'ordre locales nous fournissent un processus juridique valide, nous leur fournissons des données utiles pour les aider dans leurs enquêtes.",
        'rider_safety' => 'Conseils de sécurité pour les motards',
        'how_keep_safe' => 'Comment assurer votre sécurité',
        'how_keep_safe_content' => "Nous avons collaboré avec les forces de l'ordre pour créer ce guide sur la conduite en toute sécurité avec",
        'safe_while' => 'Il explique ce que vous pouvez faire pour rester en sécurité en conduisant.',
        'safer_ride' => 'Voyagez en toute sécurité avec',
    ],
    'api' => [
        'driver_confirmed' => 'Chauffeur Confirmé',
        'trip_confimred' => 'Votre voyage a été confirmé. Vous recevrez bientôt les détails du chauffeur.',

    ]
];
