<?php

/**
 * Mtn Payment Service
 *
 * @package     Ridein
 * @subpackage  Services\Payments
 * @category    Paynow
 * @author      Sourcemonster Team
 * @version     3.3.3
 * @link        https://sourcemonster.in
 */

namespace App\Services\PaymentMethods;

use App\Contracts\PaymentInterface;
use App\Models\Currency;
use App\Models\Transaction;
use Bmatovu\MtnMomo\Exceptions\CollectionRequestException;
use Bmatovu\MtnMomo\Products\Collection;
use Exception;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Paynow\Payments\Paynow;

class PaynowPayment implements PaymentInterface
{


    private $integration_id;
    private $integration_key;
    private $merchant_email;
    private $mode;

    /**
     * Intialize Stripe with Secret key
     *
     */
    public function __construct()
    {
        $this->integration_id =  payment_gateway('integration_id', 'Paynow');
        $this->integration_key = payment_gateway('integration_key', 'Paynow');
        $this->mode = payment_gateway('mode', 'Paynow');
        $this->merchant_email = payment_gateway('merchant_email', 'Paynow');
    }


    public function makePayment($payment_data, $indent_id = '')
    {
        try {

            $success_url = route('payment.verify', ['payment_type' => 'Paynow']);

            $faild_url = route('payment.verify', ['payment_type' => 'Paynow']);


            if ($this->mode == 'sandbox') {
                $email = $this->merchant_email;
            } elseif ($this->mode == 'live') { /// live payment
                $email = $payment_data['user_email'];
            }

            $referenceId = $this->generateReferenceId();

            $paynow = new Paynow($this->integration_id, $this->integration_key, $success_url, $faild_url);
            $payment = $paynow->createPayment($referenceId, $email);
            $payment->add(ucfirst($payment_data['pay_for']), $payment_data['amount']);
            $response = $paynow->send($payment);



            if ($response->success()) {
                $return_data['status'] = true;
                $return_data['status_message'] = 'payment successful';
                $return_data['payment_link'] = $response->redirectUrl();
                $return_data['poll_url'] = $response->pollUrl();
             //   Session::set('pollUrl', $return_data['poll_url']);

                return arrayToObject($return_data);
            } else {
                return arrayToObject(array(
                    'status'         => false,
                    'status_message' => 'payment failed.',

                ));
            }
        } catch (\Exception $e) {
            Log::error(json_encode($e));
            return arrayToObject(array(
                'status'         => false,
                'status_message' => $e->getMessage(),
            ));
        }
    }




    public function paymentVerify($requestData)
    {
        $return_data['status']  = false;
        $return_data['status_message']  = "Payment Failed!";
        try {

            $success_url = route('payment.verify', ['payment_type' => 'Paynow']);

            $faild_url = route('payment.verify', ['payment_type' => 'Paynow']);
            //you can decode the token by this PHP code:
            $paynow = new Paynow($this->integration_id, $this->integration_key, $success_url, $faild_url);
            $pollUrl = Session::get('pollUrl');
       
            $status = $paynow->pollTransaction($pollUrl);
            $result = $status->paid();
            if ($result) {
                Session::forget('pollUrl');
                $return_data['status'] = true;
                $return_data['transaction_id'] = $status->reference();
                $return_data['status_message']  = "Payment Successfully!";
            }

            return arrayToObject($return_data);
        } catch (Exception $e) {
            return arrayToObject(array(
                'status'         => false,
                'status_message' => $e->getMessage(),
            ));
        }
    }
    /**
     * Génère un UUID (Universally Unique Identifier) de version 4.
     *
     * @return string UUID généré
     */
    private function generateReferenceId()
    {
        return \Ramsey\Uuid\Uuid::uuid4()->toString();
    }
}
