<?php

return [
    'admin' => [
        'dashboard' => 'डैशबोर्ड',
        'copyright' => 'कॉपीराइट',
        'all_rights_reserved' => 'सभी अधिकार सुरक्षित हैं',
        'manage_admin' => [
            'title' => 'प्रशासक प्रबंधन',
            'admin_users' => 'प्रशासक उपयोगकर्ता',
            'role_and_permissions' => 'भूमिका और अनुमतियाँ'
        ],
        'manage_company' => 'कंपनी प्रबंधन',
        'manage_drivers' => 'ड्राइवर प्रबंधन',
        'manage_riders' => 'राइडर प्रबंधन',
        'manage_documents' => 'दस्तावेज़ प्रबंधन',
        'send_messages' => 'संदेश भेजें',
        'manage_emails' => [
            'title' => 'ईमेल प्रबंधन',
            'send_mail' => 'मेल भेजें',
            'email_settings' => 'ईमेल सेटिंग्स',
        ],
        'manage_manual_booking' => [
            'title' => 'मैन्युअल बुकिंग प्रबंधन',
            'manual_booking' => 'मैन्युअल बुकिंग',
            'view_manual' => 'मैन्युअल/अनुसूचित बुकिंग देखें',
        ],
        'vehicle_make' => 'वाहन निर्माता',
        'vehicle_model' => 'वाहन मॉडल',
        'additional_reasons' => 'अतिरिक्त कारण',
        'manage_cancel_reason' => 'रद्द करने के कारण प्रबंधित करें',
        'manage_locations' => 'स्थान प्रबंधित करें',
        'manage_fare' => 'किराया प्रबंधित करें',
        'manage_trips' => [
            'title' => 'यात्राओं का प्रबंधन',
            'manage_ride_requests' => 'सवारी अनुरोधों का प्रबंधन करें',
            'manage_trips' => 'यात्राओं का प्रबंधन',
            'manage_canceled_trips' => 'रद्द की गई यात्राओं का प्रबंधन करें',
            'cancelled_trips' => 'रद्द की गई यात्राएं',
            'manage_payments' => 'भुगतानों का प्रबंधन करें',
            'request_details' => 'अनुरोध विवरण',
            'ratings' => 'रेटिंग्स',
            'payments' => 'भुगतान',
            'ride_requests' => 'सवारी अनुरोध',
            'trips' => 'यात्राएं',
        ],
        'manage_payouts' => [
            'title' => 'भुगतान प्रबंधन करें',
            'company_payouts' => 'कंपनी भुगतान',
            'driver_payouts' => 'ड्राइवर भुगतान',
            'driver_payouts_title' => 'ड्राइवर :payout_title का प्रबंधन करें',
            'company_payouts_title' => 'कंपनी :payout_title का प्रबंधन करें',
            'table' => [
                'id' => 'पहचान',
                'driver_id' => 'ड्राइवर आईडी',
                'driver_name' => 'ड्राइवर का नाम',
                'payout_amount' => 'भुगतान राशि',
                'company_id' => 'कंपनी आईडी',
                'company_name' => 'कंपनी का नाम',
                'payout_amount' => 'भुगतान राशि',
                'action' => 'कार्य',
            ]
        ],
        'manage_owe_amount' => 'कर्ज राशि प्रबंधित करें',
        'manage_statements' => [
            'title' => 'विवरण प्रबंधित करें',
            'overall_statements' => 'कुल विवरण',
            'drivers_statments' => 'चालक विवरण',
            'statements' => 'विवरण',
            'filter_by' => 'द्वारा फ़िल्टर करें',
            'search' => 'खोजें',
            'total_amount_received' => 'कुल प्राप्त राशि',
            'total_earnings' => 'कुल आय',
            'completed_rides' => 'पूर्ण राइड्स',
            'cancelled_rides' => 'रद्द की गई राइड्स',
            'drivers' => 'चालक',
            'overall' => 'कुल मिलाकर',
            'view_by_rider' => 'राइडर द्वारा देखें',
            'from_date' => 'तिथि से',
            'to_date' => 'तिथि तक',
            'today' => 'आज',
            'weekly' => 'साप्ताहिक',
            'monthly' => 'मासिक',
            'yearly' => 'वार्षिक',
            'custom' => 'कस्टम',
            'view_trip_details' => 'ट्रिप विवरण देखें',
            'table' => [
                'driver_id' => 'चालक आईडी',
                'driver_name' => 'चालक का नाम',
                'mobile' => 'मोबाइल',
                'total_rides' => 'कुल राइड्स',
                'earnings' => 'आय',
                'joined_at' => 'शामिल हुआ',
                'details' => 'विवरण',
                'booking_id' => 'बुकिंग आईडी',
                'company_name' => 'कंपनी का नाम',
                'pickup_location' => 'पिकअप स्थान',
                'drop_location' => 'ड्रॉप स्थान',
                'trip_details' => 'ट्रिप विवरण',
                'admin_commission' => 'प्रशासनिक कमीशन',
                'admin_payout_status' => 'प्रशासनिक भुगतान स्थिति',
                'dated_on' => 'तिथि',
                'status' => 'स्थिति',
                'earned' => 'कमाया'
            ]
        ],
        'manage_wallet_and_promo' => [
            'title' => 'मैनेज वॉलेट और प्रोमो',
            'wallet' => 'वॉलेट',
            'manage_wallet_amount' => 'वॉलेट राशि का प्रबंधन',
            'manage_promo_code' => 'प्रोमो कोड प्रबंधन',
            'add_wallet' => 'वॉलेट जोड़ें',
            'add_wallet_amount' => 'वॉलेट राशि जोड़ें',
            'add_title' => 'वॉलेट जोड़ने का फ़ॉर्म',
            'edit_wallet' => 'वॉलेट राशि संपादित करें',
            'edit_title' => 'वॉलेट संपादन फ़ॉर्म',
            'rider' => 'राइडर',
            'promo_code' => 'प्रोमो कोड',
            'add_promo_code' => 'प्रोमो कोड जोड़ें',
            'add_promo_code_form' => 'प्रोमो कोड जोड़ने का फ़ॉर्म',
            'edit_promo_code' => 'प्रोमो कोड संपादित करें',
            'edit_promo_code_form' => 'प्रोमो कोड संपादन फ़ॉर्म',
            'table' => [
                'id' => 'आईडी',
                'user_id' => 'उपयोगकर्ता आईडी',
                'first_name' => 'पहला नाम',
                'last_name' => 'उपनाम',
                'wallet_amount' => 'वॉलेट राशि',
                'currency_code' => 'मुद्रा कोड',
                'action' => 'कार्रवाई',
                'code' => 'कोड',
                'original_amount' => 'मूल राशि',
                'expire_date' => 'समाप्ति तिथि',
                'status' => 'स्थिति',
            ],
            'form' => [
                'username' => 'उपयोगकर्ता नाम',
                'amount' => 'राशि',
                'currency_code' => 'मुद्रा कोड',
                'promo_code' => 'प्रोमो कोड',
                'expire_date' => 'समाप्ति तिथि',
                'status' => 'स्थिति',
            ]
        ],
        'referrals' => [
            'title' => 'रेफरल्स',
            'drivers' => 'ड्राइवर्स',
            'riders' => 'राइडर्स',
            'referral' => 'रेफरल',
            'view_referral_details' => 'रेफरल विवरण देखें',
            'details' => 'विवरण',
            'table' => [
                'id' => 'आईडी',
                'name' => 'नाम',
                'driver_name' => 'ड्राइवर का नाम',
                'referral_name' => 'रेफरल का नाम',
                'currency_code' => 'मुद्रा कोड',
                'earned_amount' => 'कमाया गया राशि',
                'pending_amount' => 'बकाया राशि',
                'action' => 'कार्रवाई',
                'trips' => 'यात्राएँ',
                'remaining_trips' => 'शेष यात्राएँ',
                'remaining_days' => 'शेष दिन',
                'amount' => 'राशि',
                'status' => 'स्थिति',
            ]
        ],
        'manage_map' => [
            'title' => 'मैनेज मानचित्र',
            'map_view' => 'मानचित्र दृश्य',
            'heat_map' => 'तापमान मानचित्र',
            'map' => 'मानचित्र',
            'user' => 'उपयोगकर्ता',
            'unavailable_driver' => 'अनुपलब्ध चालक',
            'available_driver' => 'उपलब्ध चालक',
            'unactivated_driver' => 'निष्क्रिय चालक',
        ],
        'manage_mobile_app_version' => [
            'title' => 'मोबाइल ऐप संस्करण प्रबंधन',
            'subtitle' => 'मोबाइल ऐप संस्करण',
            'edit_mobile_app_version_form' => 'मोबाइल ऐप संस्करण संपादित करें फ़ॉर्म',
            'add_mobile_app_version_form' => 'मोबाइल ऐप संस्करण जोड़ें फ़ॉर्म',
            'table' => [
                'id' => 'आईडी',
                'version' => 'संस्करण',
                'device_type' => 'डिवाइस प्रकार',
                'user_type' => 'उपयोगकर्ता प्रकार',
                'force_update' => 'बल प्रतिष्ठान',
                'created_at' => 'निर्मित किया गया',
                'updated_at' => 'अद्यतित किया गया',
                'action' => 'कार्रवाई',
            ],
            'form' => [
                'version' => 'संस्करण',
                'device_type' => 'डिवाइस प्रकार',
                'user_type' => 'उपयोगकर्ता प्रकार',
                'force_update' => 'बल प्रतिष्ठान',
            ]
        ],
        'api_credentials' => [
            'title' => 'API क्रेडेंशियल्स',
            'form_title' => 'API क्रेडेंशियल्स फॉर्म',
            'form' => [
                'google_map_key' => 'गूगल मैप की',
                'google_map_server_key' => 'गूगल मैप सर्वर की',
                'twillo_sid' => 'Twillo SID',
                'twillo_token' => 'Twillo टोकन',
                'twillo_from_number' => 'Twillo से नंबर',
                'twillo_service_sid' => 'Twillo सेवा SID',
                'apple_service_id' => 'Apple सेवा आईडी',
                'apple_team_id' => 'Apple टीम आईडी',
                'apple_key_id' => 'Apple की आईडी',
                'apple_key_file' => 'Apple की फाइल',
                'firebase_database_url' => 'Firebase डेटाबेस URL',
                'firebase_service_account' => 'Firebase सेवा खाता फाइल (JSON)'
            ]
        ],
        'payment_gateway' => [
            'title' => 'पेमेंट गेटवे',
            'form_title' => 'पेमेंट गेटवे फॉर्म',
            'tabs' => [
                'paypal' => 'पेपैल',
                'stripe' => 'स्ट्राइप',
                'paytm' => 'पेटीएम',
                'razorpay' => 'रेज़रपे',
                'flutterwave' => 'फ्लटरवेव',
                'redsys' => 'रेडसिस',
                'braintree' => 'ब्रेंट्री',
                'payout_methods' => 'भुगतान पद्धतियाँ',
            ],
            'form' => [
                'is_paypal_enabled' => 'क्या पेपैल सक्षम है',
                'paypal_mode' => 'पेपैल मोड',
                'paypal_id' => 'पेपैल आईडी',
                'paypal_client_id' => 'पेपैल क्लाइंट आईडी',
                'paypal_secret' => 'पेपैल सीक्रेट',
                'paypal_access_token' => 'पेपैल एक्सेस टोकन',
                'is_stripe_enabled' => 'क्या स्ट्राइप सक्षम है',
                'stripe_key' => 'स्ट्राइप की',
                'stripe_secret' => 'स्ट्राइप सीक्रेट',
                'stripe_api_version' => 'स्ट्राइप एपीआई संस्करण',
                'is_paytm_enabled' => 'क्या पेटीएम सक्षम है',
                'paytm_mode' => 'पेटीएम मोड',
                'paytm_merchant_id' => 'पेटीएम व्यापारी आईडी',
                'paytm_merchant_key' => 'पेटीएम व्यापारी की',
                'paytm_merchant_website' => 'पेटीएम व्यापारी वेबसाइट',
                'paytm_merchant_channel' => 'पेटीएम व्यापारी चैनल',
                'paytm_industry_type' => 'पेटीएम उद्योग प्रकार',
                'is_razorpay_enabled' => 'क्या रेजरपे सक्षम है',
                'razorpay_mode' => 'रेजरपे मोड',
                'razorpay_key' => 'रेजरपे की',
                'razorpay_secret' => 'रेजरपे सीक्रेट',
                'is_flutterwave_enabled' => 'क्या फ्लटरवेव सक्षम है',
                'flutterwave_key' => 'फ्लटरवेव की',
                'flutterwave_secret' => 'फ्लटरवेव सीक्रेट',
                'flutterwave_hash' => 'फ्लटरवेव हैश',
                'is_redsys_enabled' => 'क्या रेडसिस सक्षम है',
                'redsys_mode' => 'रेडसिस मोड',
                'redsys_merchant_mode' => 'रेडसिस व्यापारी कोड',
                'redsys_key' => 'रेडसिस की',
                'redsys_terminal' => 'रेडसिस टर्मिनल',
                'redsys_url_notification' => 'रेडसिस यूआरएल अधिसूचना',
                'redsys_url_ok' => 'रेडसिस यूआरएल ओके',
                'redsys_url_ko' => 'रेडसिस यूआरएल को',
                'redsys_tradename' => 'रेडसिस ट्रेडनेम',
                'is_braintree_enabled' => 'क्या ब्रेंट्री सक्षम है',
                'payment_mode' => 'भुगतान मोड',
                'braintree_merchant_id' => 'ब्रेंट्री व्यापारी आईडी',
                'Braintree_merchant_account_id' => 'ब्रेंट्री व्यापारी खाता आईडी',
                'braintree_public_key' => 'ब्रेंट्री सार्वजनिक कुंजी',
                'braintree_private_key' => 'ब्रेंट्री निजी कुंजी',
                'braintree_tokenization_key' => 'ब्रेंट्री टोकनाइजेशन कुंजी',
                'web_payment' => 'वेब भुगतान',
                'payout_methods' => 'भुगतान विधियाँ'
            ]
        ],
        'mange_fees' => [
            'title' => 'फीस प्रबंधित करें',
            'fees' => 'फीस',
            'fees_form' => 'फीस फॉर्म',
            'form' => [
                'rider_service_fee' => 'राइडर सेवा शुल्क',
                'driver_peak_fare' => 'चालक पीक किराया',
                'is_pool' => 'दूसरे सवार की राशि',
                'is_pool_small' => 'पूल ट्रिप्स के लिए',
                'driver_service_fee' => 'ड्राइवर सेवा शुल्क',
                'apply_trip_additional_fee' => 'यात्रा अतिरिक्त शुल्क लागू करें'
            ]
        ],
        'manage_referral_settings' => [
            'title' => 'रेफरल सेटिंग्स प्रबंधित करें',
            'referral_settings' => 'रेफरल सेटिंग्स',
            'form_title' => 'ड्राइवर रेफरल सेटिंग्स फॉर्म प्रबंधित करें',
            'form' => [
                'number_of_trips' => 'यात्राओं की संख्या',
                'driver_days' => 'समय सीमा (दिनों में)',
                'currency_code' => 'मुद्रा कोड',
                'driver_amount' => 'यात्राओं के लिए राशि',
                'referral_amount' => 'रेफरल राशि',
                'time_frame' => 'समय सीमा'
            ]
        ],
        'manage_metas' => [
            'title' => 'मेटा प्रबंधित करें',
            'metas' => 'मेटा',
            'edit_meta' => 'मेटा संपादित करें',
            'edit_meta_form' => 'मेटा संपादन फॉर्म',
            'table' => [
                'id' => 'पहचान',
                'url' => 'यूआरएल',
                'title' => 'शीर्षक',
                'description' => 'विवरण',
                'keywords' => 'किवर्डस',
                'action' => 'कार्रवाई'
            ],
            'form' => [
                'page_url' => 'पृष्ठ यूआरएल',
                'page_title' => 'पृष्ठ शीर्षक',
                'meta_description' => 'मेटा विवरण',
                'keywords' => 'किवर्डस'
            ]
        ],
        'manage_country' => [
            'title' => 'देश प्रबंधन',
            'country' => 'देश',
            'add_country' => 'देश जोड़ें',
            'add_country_form' => 'देश जोड़ने का फॉर्म',
            'edit_country' => 'देश संपादित करें',
            'edit_country_form' => 'देश संपादित करने का फॉर्म',
            'table' => [
                'id' => 'आईडी',
                'short_name' => 'संक्षिप्त नाम',
                'long_name' => 'लंबा नाम',
                'iso3' => 'Iso3',
                'num_code' => 'संख्या कोड',
                'phone_code' => 'फोन कोड',
                'action' => 'कार्रवाई',
            ],
            'form' => [
                'short_name' => 'संक्षिप्त नाम',
                'long_name' => 'लंबा नाम',
                'iso3' => 'Iso3',
                'num_code' => 'संख्या कोड',
                'phone_code' => 'फोन कोड',
            ]
        ],
        'manage_currency' => [
            'title' => 'मुद्रा प्रबंधन',
            'currency' => 'मुद्रा',
            'add_currency' => 'मुद्रा जोड़ें',
            'add_currency_form' => 'मुद्रा जोड़ने का फॉर्म',
            'edit_currency' => 'मुद्रा संपादित करें',
            'edit_currency_form' => 'मुद्रा संपादित करने का फॉर्म',
            'table' => [
                'id' => 'आईडी',
                'name' => 'नाम',
                'code' => 'कोड',
                'rate' => 'दर',
                'status' => 'स्थिति',
                'action' => 'कार्रवाई',
            ],
            'form' => [
                'name' => 'नाम',
                'code' => 'कोड',
                'rate' => 'दर',
                'symbol' => 'प्रतीक',
                'status' => 'स्थिति',
            ]
        ],
        'manage_language' => [
            'title' => 'भाषा प्रबंधन',
            'language' => 'भाषा',
            'add_language' => 'भाषा जोड़ें',
            'add_language_form' => 'भाषा जोड़ने का फॉर्म',
            'edit_language' => 'भाषा संपादित करें',
            'edit_language_form' => 'भाषा संपादित करने का फॉर्म',
            'table' => [
                'id' => 'आईडी',
                'name' => 'नाम',
                'value' => 'मूल्य',
                'status' => 'स्थिति',
                'action' => 'कार्रवाई',
            ],
            'form' => [
                'name' => 'नाम',
                'value' => 'मूल्य',
                'status' => 'स्थिति',
            ]
        ],
        'manage_static_pages' => [
            'title' => 'स्थिर पृष्ठ प्रबंधित करें',
            'static_page' => 'स्थिर पृष्ठ',
            'page' => 'पृष्ठ',
            'add_page' => 'पृष्ठ जोड़ें',
            'add_page_form' => 'पृष्ठ जोड़ें फॉर्म',
            'edit_page' => 'पृष्ठ संपादित करें',
            'edit_page_form' => 'पृष्ठ संपादित करें फॉर्म',
            'translations' => 'अनुवाद',
            'add_translation' => 'अनुवाद जोड़ें',
            'table' => [
                'id' => 'आईडी',
                'name' => 'नाम',
                'url' => 'यूआरएल',
                'status' => 'स्थिति',
                'updated_at' => 'पर अपडेट किया गया',
                'action' => 'क्रिया',
            ],
            'form' => [
                'name' => 'नाम',
                'content' => 'सामग्री',
                'footer' => 'फुटर',
                'status' => 'स्थिति',
                'language' => 'भाषा',
                'question' => 'प्रश्न',
                'answer' => 'उत्तर'
            ]
        ],
        'manage_help' => [
            'title' => 'सहायता प्रबंधित करें',
            'help' => 'सहायता',
            'category' => 'श्रेणियाँ',
            'subcategory' => 'उपश्रेणियाँ',
            'help_category' => 'सहायता श्रेणी',
            'add_help' => 'सहायता जोड़ें',
            'add_help_form' => 'सहायता जोड़ें फॉर्म',
            'edit_help' => 'सहायता संपादित करें',
            'edit_help_form' => 'सहायता संपादित करें फॉर्म',
            'help_sub_category' => 'सहायता उप श्रेणी',
            'add_help_category' => 'सहायता श्रेणी जोड़ें',
            'add_help_category_form' => 'सहायता श्रेणी जोड़ें फॉर्म',
            'edit_help_category_form' => 'सहायता श्रेणी संपादित करें फॉर्म',
            'add_help_sub_category' => 'सहायता उप श्रेणी जोड़ें',
            'add_help_sub_category_form' => 'सहायता उप श्रेणी जोड़ें फॉर्म',
            'edit_help_sub_category' => 'सहायता उप श्रेणी संपादित करें',
            'edit_help_sub_category_form' => 'सहायता उप श्रेणी संपादित करें फॉर्म',
            'translations' => 'अनुवाद',
            'add_translation' => 'अनुवाद जोड़ें',
            'table' => [
                'id' => "आईडी",
                'category' => 'श्रेणी',
                'subcategory' => 'उपश्रेणी',
                'question' => 'प्रश्न',
                'suggested' => 'सुझाव',
                'answer' => 'उत्तर',
                'status' => 'स्थिति',
                'action' => 'क्रिया',
                'name' => 'नाम',
                'description' => 'विवरण',
                'suggested' => 'सुझाव',
            ],
            'form' => [
                'language' => 'भाषा',
                'category' => 'श्रेणी',
                'subcategory' => 'उपश्रेणी',
                'question' => 'प्रश्न',
                'answer' => 'उत्तर',
                'name' => 'नाम',
                'description' => 'विवरण',
                'suggested' => 'सुझाव',
                'status' => 'स्थिति',
            ]
        ],
        'join_us_links' => [
            'title' => 'हमसे जुड़ें लिंक्स',
            'join_us' => 'हमसे जुड़ें',
            'join_us_form' => 'हमसे जुड़ें फॉर्म',
            'form' => [
                'facebook' => 'फेसबुक',
                'instagram' => 'इंस्टाग्राम',
                'twitter' => 'ट्विटर',
                'linkedin' => 'लिंक्डइन',
                'pinterest' => 'पिंटरेस्ट',
                'youtube' => 'यूट्यूब',
                'app_store_rider' => 'राइडर के लिए ऐप स्टोर लिंक',
                'app_store_driver' => 'ड्राइवर के लिए ऐप स्टोर लिंक',
                'play_store_rider' => 'राइडर के लिए प्ले स्टोर लिंक',
                'play_store_driver' => 'ड्राइवर के लिए प्ले स्टोर लिंक'
            ]
        ],
        'manage_support' => [
            'title' => 'सपोर्ट प्रबंधित करें',
            'support' => 'सपोर्ट',
            'add_support' => 'सपोर्ट जोड़ें',
            'add_support_form' => 'सपोर्ट जोड़ें फॉर्म',
            'edit_support' => 'सपोर्ट संपादित करें',
            'edit_support_form' => 'सपोर्ट संपादित करें फॉर्म',
            'note' => 'नोट* : कृपया देश कोड के साथ भरें।(उदाहरण-911234567890).',
            'table' => [
                'id' => 'आईडी',
                'name' => "नाम",
                'link' => 'लिंक',
                'status' => 'स्थिति',
                'action' => 'क्रिया',
            ],
            'form' => [
                'name' => "नाम",
                'link' => 'लिंक',
                'status' => 'स्थिति',
                'image' => 'छवि',
                'number' => 'नंबर'
            ]
        ],
        'site_setting' => [
            'title' => 'साइट सेटिंग्स',
            'site_settings_form' => 'साइट सेटिंग्स फॉर्म',
            'pool' => 'केवल पूल यात्रा',
            'note' => 'नोट : यह मुद्रा आपके Braintree मुद्रा के समान होनी चाहिए',
            'form' => [
                'site_name' => 'साइट का नाम',
                'version' => 'संस्करण',
                'header_logo' => 'हेडर लोगो',
                'header_white_logo' => 'सफेद हेडर लोगो',
                'favicon' => 'फेविकॉन',
                'timezones' => 'समय क्षेत्र',
                'default_currency' => 'डिफ़ॉल्ट मुद्रा',
                'payment_currency' => 'भुगतान मुद्रा',
                'trip_default_payment_method' => 'ट्रिप डिफ़ॉल्ट भुगतान विधि',
                'driver_kilometer' => 'ड्राइवर किलोमीटर',
                'pickup_kilometer' => 'पिकअप किलोमीटर',
                'drop_kilometer' => 'ड्रॉप किलोमीटर',
                'head_code' => '<head> में कोड जोड़ें (जैसे कि Google Analytics के लिए ट्रैकिंग कोड)',
                'default_language' => 'डिफ़ॉल्ट भाषा',
                'country_code' => 'देश कोड',
                'manual_booking_contact_number' => 'मैन्युअल बुकिंग संपर्क नंबर',
                'heat_map' => 'हीट मैप',
                'heat_map_hours' => 'हीट मैप घंटे',
                'update_location_interval' => 'स्थान अपडेट अंतराल',
                'otp_verification' => 'ओटीपी सत्यापन',
                'covid_feature' => 'कोविड फीचर',
                'driver_request_seconds' => 'ड्राइवर अनुरोध सेकंड',
                'driver_request_limit' => 'ड्राइवर अनुरोध सीमा',
                'pay_to_admin_driver_limit' => 'एडमिन को भुगतान ड्राइवर सीमा (स्थिर राशि)*',
                'copyright_year' => 'कॉपीराइट वर्ष',
                'copyright_url' => 'कॉपीराइट यूआरएल',
                'copyright_name' => 'कॉपीराइट नाम',
            ]
        ],
        'control_panel' => 'नियंत्रण कक्ष',
        'home' => 'होम',
        'fields_are_mandatory' => 'फ़ील्ड अनिवार्य हैं',
        'submit' => 'सबमिट करें',
        'cancel' => 'रद्द करें',
        'add' => 'जोड़ें',
        'edit' => 'संपादित करें',
        'reset' => 'रीसेट',
        'dashboard_page' => [
            'dashboard' => 'डैशबोर्ड',
            'total_earnings' => 'कुल कमाई',
            'total_drivers' => 'कुल ड्राइवर',
            'total_riders' => 'कुल राइडर',
            'total_trips' => 'कुल यात्राएं',
            'today_earnings' => 'आज की कमाई',
            'today_drivers' => 'आज के ड्राइवर',
            'today_riders' => 'आज के राइडर',
            'today_trips' => 'आज की यात्राएं',
            'sales_graph' => 'बिक्री ग्राफ',
            'calender' => 'कैलेंडर',
            'recent_ride_requests' => 'हाल की सवारी अनुरोध',
            'table' => [
                'group_id' => 'समूह आईडी',
                'rider_name' => 'राइडर का नाम',
                'dated_on' => 'दिनांक',
                'status' => 'स्थिति',
                'driver_name' => 'ड्राइवर का नाम',
            ],
        ],
        'manage_admin_page' => [
            'admin_users' => 'प्रशासक उपयोगकर्ता',
            'add_admin_user' => 'प्रशासक उपयोगकर्ता जोड़ें',
            'add_admin_user_form' => 'प्रशासक उपयोगकर्ता फॉर्म जोड़ें',
            'edit_admin_user' => 'प्रशासक उपयोगकर्ता संपादित करें',
            'edit_admin_user_form' => 'प्रशासक उपयोगकर्ता फॉर्म संपादित करें',
            'add_role' => 'भूमिका जोड़ें',
            'add_role_form' => 'भूमिका फॉर्म जोड़ें',
            'edit_role' => 'भूमिका संपादित करें',
            'edit_role_form' => 'भूमिका फॉर्म संपादित करें',
            'roles' => 'भूमिकाएँ',
            'table' => [
                'id' => 'आईडी',
                'username' => 'उपयोगकर्ता नाम',
                'email' => 'ईमेल',
                'status' => 'स्थिति',
                'action' => 'क्रिया',
                'name' => 'नाम',
                'display_name' => 'प्रदर्शित नाम',
                'description' => 'विवरण',
            ],
            'form' => [
                'name' => 'नाम',
                'username' => 'उपयोगकर्ता नाम',
                'email' => 'ईमेल पता',
                'password' => 'पासवर्ड',
                'country_code' => 'देश कोड',
                'mobile_number' => 'मोबाइल नंबर (SOS उद्देश्य के लिए)',
                'role' => 'भूमिका',
                'status' => 'स्थिति',
                'display_name' => 'प्रदर्शित नाम',
                'description' => 'विवरण',
                'permissions' => 'अनुमतियाँ',
            ]
        ],
        'manage_company_page' => [
            'title' => 'कंपनी प्रबंधन',
            'add_company' => 'कंपनी जोड़ें',
            'add_company_form' => 'कंपनी फॉर्म जोड़ें',
            'edit_company' => 'कंपनी संपादित करें',
            'edit_company_form' => 'कंपनी फॉर्म संपादित करें',
            'companies' => 'कंपनियाँ',
            'form' => [
                'id' => 'आईडी',
                'name' => 'नाम',
                'vat_number' => 'वैट नंबर',
                'email' => 'ईमेल',
                'password' => 'पासवर्ड',
                'country_code' => 'देश कोड',
                'mobile_number' => 'मोबाइल नंबर',
                'status' => 'स्थिति',
                'address_line' => 'पता पंक्ति',
                'city' => 'शहर',
                'state' => 'राज्य',
                'postal_code' => 'पोस्टल कोड',
                'profile' => 'प्रोफाइल',
                'company_commission' => 'कंपनी कमीशन'
            ],
            'table' => [
                'id' => 'आईडी',
                'name' => 'नाम',
                'drivers' => 'ड्राइवर',
                'email' => 'ईमेल',
                'mobile_number' => 'मोबाइल नंबर',
                'status' => 'स्थिति',
                'action' => 'क्रिया'
            ]
        ],
        'manage_drivers_page' => [
            'title' => 'ड्राइवर प्रबंधन',
            'drivers' => 'ड्राइवर',
            'add_driver' => 'ड्राइवर जोड़ें',
            'add_driver_form' => 'ड्राइवर फॉर्म जोड़ें',
            'edit_driver' => 'ड्राइवर संपादित करें',
            'edit_driver_form' => 'ड्राइवर फॉर्म संपादित करें',
            'table' => [
                'id' => 'आईडी',
                'first_name' => 'प्रथम नाम',
                'last_name' => 'अंतिम नाम',
                'company_name' => 'कंपनी का नाम',
                'email' => 'ईमेल',
                'gender' => 'लिंग',
                'status' => 'स्थिति',
                'mobile_number' => 'मोबाइल नंबर',
                'device_type' => 'डिवाइस प्रकार',
                'created_at' => 'बनाया गया',
                'action' => 'क्रिया',
            ],
            'form' => [
                'first_name' => 'प्रथम नाम',
                'last_name' => 'अंतिम नाम',
                'password' => 'पासवर्ड',
                'country_code' => 'देश कोड',
                'company_name' => 'कंपनी का नाम',
                'email' => 'ईमेल',
                'gender' => 'लिंग',
                'status' => 'स्थिति',
                'mobile_number' => 'मोबाइल नंबर',
                'device_type' => 'डिवाइस प्रकार',
                'address_line1' => 'पता पंक्ति 1',
                'address_line2' => 'पता पंक्ति 2',
                'city' => 'शहर',
                'state' => 'राज्य',
                'postal_code' => 'पोस्टल कोड',
                'expire_date' => 'समाप्ति तिथि',
                'account_holder_name' => 'खाता धारक का नाम',
                'account_number' => 'खाता संख्या',
                'name_of_bank' => 'बैंक का नाम',
                'bank_location' => 'बैंक स्थान',
                'code' => 'बीआईसी/स्विफ्ट कोड',
            ]
        ],
        'manage_riders_page' => [
            'title' => 'राइडर प्रबंधन',
            'riders' => 'राइडर',
            'add_rider' => 'राइडर जोड़ें',
            'add_rider_form' => 'राइडर फॉर्म जोड़ें',
            'edit_rider' => 'राइडर संपादित करें',
            'edit_rider_form' => 'राइडर फॉर्म संपादित करें',
            'table' => [
                'id' => 'आईडी',
                'first_name' => 'प्रथम नाम',
                'last_name' => 'अंतिम नाम',
                'email' => 'ईमेल',
                'gender' => 'लिंग',
                'status' => 'स्थिति',
                'mobile_number' => 'मोबाइल नंबर',
                'device_type' => 'डिवाइस प्रकार',
                'created_at' => 'बनाया गया',
                'action' => 'क्रिया',
            ],
            'form' => [
                'first_name' => 'प्रथम नाम',
                'last_name' => 'अंतिम नाम',
                'password' => 'पासवर्ड',
                'country_code' => 'देश कोड',
                'email' => 'ईमेल',
                'gender' => 'लिंग',
                'status' => 'स्थिति',
                'mobile_number' => 'मोबाइल नंबर',
                'device_type' => 'डिवाइस प्रकार',
                'home_location' => 'घर का स्थान',
                'office_location' => 'कार्यालय का स्थान'
            ]
        ],
        'manage_documents_page' => [
            'title' => 'दस्तावेज़',
            'add_documents' => 'दस्तावेज़ जोड़ें',
            'add_documents_form' => 'दस्तावेज़ फॉर्म जोड़ें',
            'edit_documents' => 'दस्तावेज़ संपादित करें',
            'edit_documents_form' => 'दस्तावेज़ फॉर्म संपादित करें',
            'table' => [
                'id' => 'आईडी',
                'document_for' => 'के लिए दस्तावेज़',
                'country' => 'देश',
                'document_name' => 'दस्तावेज़ का नाम',
                'status' => 'स्थिति',
                'action' => 'क्रिया',
            ],
            'form' => [
                'language' => 'भाषा',
                'document_for' => 'के लिए दस्तावेज़',
                'country' => 'देश',
                'document_name' => 'दस्तावेज़ का नाम',
                'status' => 'स्थिति',
                'expire_on_date' => 'समाप्ति तिथि',
            ]
        ],
        'manage_send_message_page' => [
            'title' => 'संदेश भेजें',
            'send_message_form' => 'संदेश भेजें फॉर्म',
            'all' => 'सभी',
            'specific_users' => 'विशिष्ट उपयोगकर्ता',
            'sms' => 'एसएमएस',
            'push_notification' => 'पुश सूचना',
            'all_driver' => 'चालक',
            'all_rider' => 'सवार',
            'all_company' => 'कंपनी',
            'all_type' => 'सवार & चालक & कंपनी',

            'form' => [
                'to' => 'प्राप्तकर्ता',
                'user_type' => 'उपयोगकर्ता प्रकार',
                'message_type' => 'संदेश प्रकार',
                'message' => 'संदेश',
            ]
        ],
        'manage_emails_page' => [
            'send_email' => 'ईमेल भेजें',
            'send_email_form' => 'ईमेल भेजें फॉर्म',
            'notes' => 'नोट: ईमेल केवल पंजीकृत उपयोगकर्ताओं को भेजा जाएगा।',
            'email_settings' => 'ईमेल सेटिंग्स',
            'email_settings_form' => 'ईमेल सेटिंग्स फॉर्म',
            'form' => [
                'email_to' => 'प्राप्तकर्ता ईमेल',
                'email_address' => 'ईमेल पता',
                'subject' => 'विषय',
                'message' => 'संदेश (अभिवादन स्वचालित रूप से जोड़ा जाएगा)',
                'host' => 'होस्ट',
                'driver' => 'ड्राइवर',
                'port' => 'पोर्ट',
                'from_address' => 'प्रेषक पता',
                'form_name' => 'प्रपत्र नाम',
                'encryption' => 'एन्क्रिप्शन',
                'username' => 'उपयोगकर्ता नाम',
                'password' => 'पासवर्ड',
            ]
        ],
        'manage_manual_booking_page' => [
            'title' => 'मैनुअल बुकिंग',
            'heading' => 'मैनुअल टैक्सी डिस्पैच',
            'select_driver_availability' => 'ड्राइवर उपलब्धता चुनें',
            'map_zoom_level' => 'नक्शा ज़ूम स्तर',
            'auto_assign_driver' => 'स्वचालित ड्राइवर असाइन करें',
            'fare_estimation' => 'किराया अनुमान',
            'minimum_fare' => 'न्यूनतम किराया',
            'base_fare' => 'बेस किराया',
            'distance' => 'दूरी',
            'time' => 'समय',
            'minutes' => 'मिनट',
            'peak_price' => 'पीक कीमत',
            'total_fare' => 'कुल किराया',
            'notes' => 'नोट्स',
            'reason' => 'कारण',
            'manual_auto_booking' => [
                'title' => 'मैनुअल ऑटो बुकिंग',
                'point_1' => 'प्रशासक इस पृष्ठ पर बाद में सवारी जोड़/संपादित कर सकते हैं।',
                'point_2' => 'ड्राइवर की वर्तमान उपलब्धता बुकिंग से संबंधित नहीं है।',
                'point_3' => 'यहाँ से बुकिंग जोड़ने से ड्राइवर को तुरंत अनुरोध नहीं भेजा जाएगा।',
                'point_4' => '"स्वचालित ड्राइवर असाइन करें" विकल्प चयनित होने पर, ड्राइवर को वास्तविक बुकिंग समय से 5 मिनट पहले स्वचालित अनुरोध प्राप्त होगा।',
                'point_5' => '"स्वचालित ड्राइवर असाइन करें" विकल्प चयनित नहीं होने पर, ड्राइवर को वास्तविक बुकिंग समय से 30 मिनट पहले बुकिंग पुष्टि एसएमएस और रिमाइंडर एसएमएस मिलेगा।',
                'point_6' => 'ड्राइवर को अनुसूचित यात्रा शुरू करनी होगी "आपकी यात्रा" >> आगामी अनुभाग में जाकर ड्राइवर ऐप से।',
                'point_7' => 'स्वचालित ड्राइवर असाइन होने पर, प्रतियोगी एल्गोरिदम का पालन किया जाएगा।'
            ],
            'manual_assign_booking' => [
                'title' => 'मैनुअल असाइन बुकिंग',
                'point_1' => 'कृपया बुकिंग करने से पहले ड्राइवर की भविष्य की उपलब्धता की पुष्टि करें।',
                'point_2' => 'ड्राइवर को अनुसूचित यात्रा शुरू करनी होगी "आपकी यात्रा" >> आगामी अनुभाग में जाकर ड्राइवर ऐप से।',
            ],
            'manage_bookings' => 'बुकिंग प्रबंधित करें',
            'cancel_reason' => 'रद्द करने का कारण',
            'booking_cancel' => 'बुकिंग रद्द करें',
            'booking_cancel_reason' => 'बुकिंग रद्द करने का कारण',
            'cancel_by' => 'द्वारा रद्द',
            'cancelled_by' => 'द्वारा रद्द किया गया',
            'cancel' => 'रद्द करें',
            'trip_cancelled' => 'यात्रा रद्द की गई',
            'immediate_request' => 'तत्काल अनुरोध',

            'table' => [
                'company_name' => 'कंपनी का नाम',
                'booked_by' => 'द्वारा बुक किया गया',
                'date' => 'तारीख',
                'driver_name' => 'चालक का नाम',
                'rider_name' => 'सवार का नाम',
                'pickup_location' => 'पिकअप स्थान',
                'drop_location' => 'ड्रॉप स्थान',
                'trip_details' => 'यात्रा विवरण',
                'status' => 'स्थिति',
            ]

        ],
        'manage_vehicle_make' => [
            'title' => 'वाहन निर्माता',
            'add_vehicle_make' => 'वाहन निर्माता जोड़ें',
            'form_title' => 'वाहन निर्माता जोड़ने का फॉर्म',
            'edit_vehicle_make' => 'वाहन निर्माता संपादित करें',
            'edit_form_title' => 'वाहन निर्माता संपादन फॉर्म',

            'form' => [
                'status' => 'स्थिति',
                'make' => 'वाहन निर्माता',
            ],
            'table' => [
                'id' => 'आईडी',
                'status' => 'स्थिति',
                'make' => 'निर्माता',
            ]
        ],
        'manage_vehicle_model' => [
            'title' => 'वाहन मॉडल',
            'add_vehicle_model' => 'वाहन मॉडल जोड़ें',
            'form_title' => 'वाहन मॉडल जोड़ने का फ़ॉर्म',
            'edit_vehicle_model' => 'वाहन मॉडल संपादित करें',
            'edit_form_title' => 'वाहन मॉडल संपादन फ़ॉर्म',
            'table' => [
                'id' => 'आईडी',
                'make' => 'निर्माता',
                'model' => 'मॉडल',
                'status' => 'स्थिति',
                'action' => 'क्रिया',
            ],
            'form' => [
                'vehicle_make' => 'वाहन निर्माता',
                'model' => 'वाहन मॉडल का नाम',
                'status' => 'स्थिति',
            ]
        ],
        'manage_vehicle_type' => [
            'title' => 'वाहन प्रकार',
            'vehicles' => 'वाहन',
            'vehicle_types' => 'वाहन प्रकार',
            'add_vehicle_type' => 'वाहन प्रकार जोड़ें',
            'form_title' => 'वाहन प्रकार जोड़ने का फ़ॉर्म',
            'edit_vehicle_type' => 'वाहन प्रकार संपादित करें',
            'edit_form_title' => 'वाहन प्रकार संपादन फ़ॉर्म',
            'table' => [
                'id' => 'आईडी',
                'vehicle_name' => 'वाहन का नाम',
                'description' => 'विवरण',
                'is_pool' => 'पूल के लिए है',
                'status' => 'स्थिति',
                'action' => 'क्रिया',
            ],
            'form' => [
                'vehicle_name' => 'वाहन का नाम',
                'description' => 'विवरण',
                'vehicle_image' => 'वाहन की छवि',
                'vehicle_active_image' => 'सक्रिय वाहन की छवि',
                'vehicle_app_icon' => 'वाहन ऐप आइकन',
                'is_pool' => 'पूल के लिए है',
                'status' => 'स्थिति',
            ]
        ],
        'manage_vehicles' => [
            'title' => 'वाहनों का प्रबंधन',
            'vehicles' => 'वाहन',
            'add_vehicles' => 'वाहन जोड़ें',
            'edit_vehicles' => 'वाहन संपादित करें',
            'add_vehicle_form' => 'वाहन जोड़ने का फॉर्म',
            'edit_vehicle_form' => 'वाहन संपादन फॉर्म',
            'form' => [
                'company_name' => 'कंपनी का नाम',
                'driver_name' => 'चालक का नाम',
                'vehicle_type' => 'वाहन का प्रकार',
                'make' => 'निर्माता',
                'model' => 'मॉडल',
                'status' => 'स्थिति',
                'default' => 'डिफ़ॉल्ट',
                'handicap_accessibility_available' => 'विकलांगता पहुँच उपलब्ध है',
                'child_seat_accessibility_available' => 'बच्चे की सीट पहुँच उपलब्ध है',
                'request_form' => 'अनुरोध फॉर्म',
                'vehicle_number' => 'वाहन संख्या',
                'color' => 'रंग',
                'year' => 'वर्ष',
                'expire_date' => 'समाप्ति तिथि',
                'request_form_note' => 'यदि चालक पुरुष है, तो इसे स्वचालित रूप से दोनों के रूप में चुना जाएगा।',
                'default_note' => 'यदि चालक के पास केवल एक सक्रिय स्थिति वाला वाहन है, तो इसे स्वचालित रूप से डिफ़ॉल्ट के रूप में चुना जाएगा।'
            ],
            'table' => [
                'id' => 'आईडी',
                'company_name' => 'कंपनी का नाम',
                'driver_name' => 'चालक का नाम',
                'vehicle_type' => 'वाहन का प्रकार',
                'make' => 'निर्माता/मॉडल',
                'vehicle_number' => 'वाहन संख्या',
                'status' => 'स्थिति',
                'action' => 'क्रिया',
            ]
        ],
        'manage_additional_reasons' => [
            'title' => 'अतिरिक्त कारण',
            'add_additional_reason' => 'अतिरिक्त कारण जोड़ें',
            'edit_additional_reason' => 'अतिरिक्त कारण संपादित करें',
            'add_title' => 'अतिरिक्त कारण जोड़ने का फॉर्म',
            'edit_title' => 'अतिरिक्त कारण संपादन फॉर्म',
            'table' => [
                'id' => 'आईडी',
                'reason' => 'कारण',
                'status' => 'स्थिति',
                'action' => 'क्रिया'
            ],
            'form' => [
                'reason' => 'कारण',
                'status' => 'स्थिति'
            ]
        ],
        'cancel_reasons' => [
            'title' => 'रद्द करने का कारण',
            'add_cancel_reason' => 'रद्द करने का कारण जोड़ें',
            'edit_cancel_reason' => 'रद्द करने का कारण संपादित करें',
            'add_title' => 'रद्द करने का कारण जोड़ने का फॉर्म',
            'edit_title' => 'रद्द करने का कारण संपादन फॉर्म',
            'translations' => 'अनुवाद',
            'remove' => 'हटाएं',
            'add_translations' => 'अनुवाद जोड़ें',
            'table' => [
                'id' => 'आईडी',
                'reason' => 'कारण',
                'cancelled_by' => 'द्वारा रद्द',
                'status' => 'स्थिति',
                'action' => 'क्रिया',
            ],
            'form' => [
                'language' => 'भाषा',
                'reason' => 'कारण',
                'cancelled_by' => 'द्वारा रद्द',
                'status' => 'स्थिति'
            ]
        ],
        'locations' => [
            'title' => 'स्थान',
            'add_location' => 'स्थान जोड़ें',
            'edit_location' => 'स्थान संपादित करें',
            'add_title' => 'स्थान जोड़ने का फॉर्म',
            'edit_title' => 'स्थान संपादित करने का फॉर्म',
            'table' => [
                'id' => 'आईडी',
                'location_name' => 'स्थान का नाम',
                'status' => 'स्थिति',
                'action' => 'क्रिया'
            ],
            'form' => [
                'name' => 'नाम',
                'status' => 'स्थिति'
            ]
        ],
        'manage_fares' => [
            'title' => 'किराए प्रबंधित करें',
            'add_manage_fare' => 'किराया जोड़ें',
            'edit_manage_fare' => 'किराया संपादित करें',
            'add_title' => 'किराया जोड़ने का फॉर्म',
            'edit_title' => 'किराया संपादित करने का फॉर्म',
            'peak_fare_details' => 'पीक किराया विवरण',
            'night_fare_details' => 'रात्रि किराया विवरण',
            'table' => [
                'id' => 'आईडी',
                'location_name' => 'स्थान का नाम',
                'vehicle_type' => 'वाहन का प्रकार',
                'apply_peak' => 'पीक लागू करें',
                'apply_night' => 'रात्रि लागू करें',
                'action' => 'क्रिया',
            ],
            'form' => [
                'location' => 'स्थान',
                'vehicle_type' => 'वाहन का प्रकार',
                'base_fare' => 'बेस किराया',
                'capacity' => 'क्षमता',
                'minimum_fare' => 'न्यूनतम किराया',
                'per_minutes' => 'प्रति मिनट',
                'per_kilometer' => 'प्रति किलोमीटर',
                'waiting_time_limit' => 'प्रतीक्षा समय सीमा (मिनट में)',
                'waiting_charges' => 'प्रतीक्षा शुल्क (प्रति मिनट)',
                'schedule_ride_fare' => 'अनुसूचित सवारी किराया',
                'currency_code' => 'मुद्रा कोड',
                'apply_peak_fare' => 'पीक किराया लागू करें',
                'apply_night_fare' => 'रात्रि किराया लागू करें',
                'day' => 'दिन',
                'start_time' => 'प्रारंभ समय',
                'end_time' => 'समाप्ति समय',
                'peak_fare' => 'पीक किराया',
                'night_fare' => 'रात्रि किराया'
            ]
        ],
        'manage_trip' => [
            'manage_ride_requests' => 'सवारी अनुरोधों का प्रबंधन करें',
            'ride_requests' => 'सवारी अनुरोध',
            'manage_trips' => 'यात्राओं का प्रबंधन',
            'trips' => 'यात्राएं',
            'request_details' => [
                'request_status' => 'ड्राइवर अभी तक असाइन नहीं किया गया है!',
                'vehicle_type' => 'वाहन का प्रकार',
                'rider_name' => 'सवार का नाम',
                'driver_name' => 'चालक का नाम',
                'company_name' => 'कंपनी का नाम',
                'pickup_address' => 'पिकअप पता',
                'drop_address' => 'ड्रॉप पता',
                'ride_start_time' => 'यात्रा प्रारंभ समय',
                'ride_end_time' => 'यात्रा समाप्ति समय',
                'ride_status' => 'यात्रा की स्थिति'
            ],
            'table' => [
                'id' => 'पहचान',
                'request_id' => 'अनुरोध पहचान',
                'rider_name' => 'सवार का नाम',
                'driver_name' => 'चालक का नाम',
                'earned' => 'कमा लिया',
                'pickup_location' => 'पिकअप स्थान',
                'drop_location' => 'ड्रॉप स्थान',
                'date_and_time' => 'तिथि और समय',
                'status' => 'स्थिति',
                'amount' => 'राशि',
                'trip_date' => 'यात्रा की तारीख',
                'company_name' => 'कंपनी का नाम',
                'vehicle_details' => 'वाहन का विवरण',
                'payment_mode' => 'भुगतान मोड',
                'payment_status' => 'भुगतान की स्थिति',
                'action' => 'कार्य',
                'reason' => 'कारण',
                'comments' => 'टिप्पणियाँ',
                'cancelled_by' => 'द्वारा रद्द किया गया',
                'cancel_at' => 'पर रद्द',
                'time_fare' => 'समय किराया',
                'distance_fare' => 'दूरी किराया',
                'base_fare' => 'मूल किराया',
                'is_pool' => 'दूसरे सवार की राशि (पूल)',
                'tips' => 'टिप्स',
                'additional_fee' => 'अतिरिक्त शुल्क',
                'access_fee' => 'पहुंच किराया',
                'admin_commission' => 'प्रशासनिक कमीशन',
                'total_fare' => 'कुल किराया',
                'earnings' => 'कमाई',
                'car_name' => 'कार का नाम',
                'trip_number' => 'यात्रा संख्या',
                'driver_rating' => 'ड्राइवर रेटिंग',
                'rider_rating' => 'सवार रेटिंग',
                'rider_comments' => 'सवार की टिप्पणियाँ',
                'driver_comments' => 'ड्राइवर की टिप्पणियाँ',
            ]
        ],
        'manage_owe_amounts' => [
            'title' => 'देय राशि प्रबंधित करें',
            'owe_amount' => 'देय राशि',
            'table' => [
                'id' => 'आईडी',
                'company_id' => 'कंपनी आईडी',
                'company_name' => 'कंपनी का नाम',
                'trip_ids' => 'यात्रा आईडी',
                'owe_amount' => 'देय राशि',
                'remaining_owe_amount' => 'शेष देय राशि',
                'action' => 'क्रिया',
                'driver_id' => 'चालक आईडी',
                'driver_name' => 'चालक का नाम',
            ]
        ]

    ],
    'drive' => [
        'start_drive_with' => 'के साथ ड्राइविंग शुरू करें',
        'works_first' => 'काम जो आपको पहले रखता है',
        'drive_you_need' => 'जब आप चाहें ड्राइव करें, जो आपको चाहिए कमाएँ',
        'own_schedule' => 'अपना शेड्यूल सेट करें',
        'drive_with' => 'आप ड्राइव कर सकते हैं',
        'anytime' => 'कभी भी, दिन या रात, साल के 365 दिन। जब आप ड्राइव करते हैं, यह हमेशा आप पर निर्भर करता है, इसलिए यह आपके जीवन में महत्वपूर्ण चीजों में हस्तक्षेप नहीं करता है।',
        'every_turn' => 'हर मोड़ पर अधिक कमाएं',
        'fare_start' => 'यात्रा किराए एक मूल राशि से शुरू होते हैं, फिर समय और दूरी के साथ बढ़ते हैं। और जब मांग सामान्य से अधिक होती है, तो ड्राइवर अधिक कमाते हैं।',
        'app_lead' => 'ऐप को रास्ता दिखाने दें',
        'tap_go' => 'बस टैप करें और जाएं। आपको टर्न-बाय-टर्न दिशानिर्देश, अधिक कमाने में मदद करने वाले उपकरण, और 24/7 समर्थन मिलेगा। और अगर आपके पास स्मार्टफोन नहीं है, तो हम आपको एक से कनेक्ट कर सकते हैं।',
        'hit_road' => 'सड़क पर उतरें',
        'easy_started' => 'शुरू करना आसान है',
        'sign_online' => 'ऑनलाइन साइन अप करें',
        'about_yourself' => 'हमें अपने और अपनी कार के बारे में थोड़ा बताएं। वाहन आवश्यकताएँ क्षेत्र के अनुसार भिन्न होती हैं, इसलिए हम आपको दिखाएंगे कि आपके शहर के लिए क्या आवश्यक है।',
        'share_doc' => 'कुछ दस्तावेज़ साझा करें',
        'upload_license' => 'बस अपना लाइसेंस, पंजीकरण, बीमा का प्रमाण और ड्राइवर स्क्रीनिंग शुरू करने के लिए आवश्यक जानकारी अपलोड करें।',
        'get_app' => 'ऐप प्राप्त करें और जाएं',
        'approve_drive' => 'एक स्वतंत्र ठेकेदार के रूप में ड्राइव करने के लिए स्वीकृत होने के बाद',
        'provide_you_need' => 'हम आपको सड़क पर सफल होने के लिए आवश्यक सब कुछ प्रदान करेंगे।',
        'signup_now' => 'अभी साइन अप करें',
        'about_app' => 'ऐप के बारे में',
        'design_drivers' => 'ड्राइवरों के लिए ही डिज़ाइन किया गया',
        'make_money' => 'जब आप पैसा कमाना चाहते हैं, तो बस ऐप खोलें और आपको यात्रा अनुरोध प्राप्त होने लगेंगे। आपको अपने यात्री के बारे में जानकारी और उनके स्थान और गंतव्य के लिए दिशानिर्देश मिलेंगे। जब यात्रा समाप्त हो जाएगी, तो आपको एक और निकटवर्ती अनुरोध प्राप्त होगा। और अगर आप सड़क से उतरना चाहते हैं, तो आप किसी भी समय साइन ऑफ कर सकते हैं।',
        'safety_screen' => 'जानिए आप सड़क पर उतरने के लिए तैयार हैं। चाहे आप अपनी कार चला रहे हों या व्यावसायिक रूप से लाइसेंस प्राप्त वाहन, आपको न्यूनतम आवश्यकताओं को पूरा करना होगा और ऑनलाइन एक सुरक्षा स्क्रीनिंग पूरी करनी होगी।',
        'rewards' => 'इनाम',
        'drive_seat' => 'आप ड्राइवर की सीट पर हैं। इसलिए ईंधन, वाहन रखरखाव, सेल फोन बिल और अधिक पर छूट के साथ खुद को पुरस्कृत करें। अपने दैनिक खर्चों को कम करें और अधिक ड्राइविंग करके अतिरिक्त कमाई करें।',
        'vehicle_solution' => 'वाहन समाधान',
        'need_car' => 'कार की आवश्यकता है? हम आपको भागीदारों से जोड़ सकते हैं जो विशेष वाहन सौदे पेश करते हैं जो आपको सड़क पर लाने और कमाई शुरू करने में मदद कर सकते हैं। कई मील की कोई सीमा और लचीली वापसी नीतियां प्रदान करते हैं ताकि आप जितना चाहें उतना ड्राइव कर सकें।',
        'you_with' => 'जब आप ड्राइव करते हैं',
        'support' => 'आपको 24/7 ड्राइवर समर्थन और बीमा कवरेज प्राप्त होता है। और सभी सवार अपने व्यक्तिगत जानकारी और फोन नंबर के साथ सत्यापित होते हैं, इसलिए आप जानेंगे कि आप किसे उठा रहे हैं और हम भी।',
        'making_money' => 'पैसा बनाना शुरू करें',
        'ready_money' => 'पैसा बनाने के लिए तैयार? पहला कदम ऑनलाइन साइन अप करना है।',
        'support' => 'हर मोड़ पर समर्थन',
        'we_want' => 'हम हर',
        'hassle_free' => 'यात्रा को परेशानी-मुक्त बनाना चाहते हैं। इसलिए हम आपके खाते की स्थापना, किराए के समायोजन और अधिक के लिए यहां मदद करने के लिए हैं जब भी आपको आवश्यकता हो।',
        'safety_behind' => 'पहिया के पीछे सुरक्षा',
        'out_commitment' => 'ड्राइवरों के लिए हमारी प्रतिबद्धता',
        'keeping_safe' => 'लोगों को सड़क पर सुरक्षित रखने के लिए समर्पित है। हमारी तकनीक हमें हर यात्रा से पहले, दौरान, और बाद में ड्राइवर की सुरक्षा पर ध्यान केंद्रित करने की अनुमति देती है।',
        'before_trip' => 'यात्रा से पहले',
        'picking_up' => 'यात्रियों को उठाना',
        'anonymous_pickup' => 'कोई गुमनाम पिकअप नहीं',
        'riders_account' => 'सभी सवारों को एक खाता बनाना और यात्रा का अनुरोध करने से पहले उनका नाम, ईमेल पता, और फोन नंबर प्रदान करना आवश्यक है। इसलिए जब आप अनुरोध स्वीकार करते हैं, तो आप जानेंगे कि आप किसे उठा रहे हैं और हम भी।',
        'sub_number' => 'वैकल्पिक फोन नंबर',
        'location_around_world' => 'दुनिया भर में कई स्थानों पर,',
        'stays_private' => 'तकनीक का उपयोग करता है जो फोन नंबरों को गुमनाम करता है ताकि संपर्क विवरण गोपनीय रहें। इसलिए जब आप और आपका सवार एक दूसरे से संपर्क करने की आवश्यकता हो, तो आपकी व्यक्तिगत जानकारी गोपनीय रहती है।',
        'on_trip' => 'यात्रा पर',
        'getting_destination' => 'गंतव्य पर पहुंचना',
        'app_navigation' => 'ऐप नेविगेशन',
        'riders_enter' => 'जब सवार अपना गंतव्य दर्ज करते हैं, तो आपको ऐप में टर्न-बाय-टर्न दिशानिर्देश स्वचालित रूप से मिलेंगे—ताकि आप सुरक्षित रूप से वहां पहुंचने पर ध्यान केंद्रित कर सकें।',
        'on_the_map' => 'हमेशा नक्शे पर',
        'gps_data' => 'प्रत्येक यात्रा के लिए जीपीएस डेटा लॉग किया जाता है ताकि हम जान सकें कि आप किसे ड्राइव कर रहे हैं और कहां जा रहे हैं, जो जवाबदेही को बढ़ावा देता है और अच्छे व्यवहार को प्रोत्साहित करता है।',
        'after_trip' => 'यात्रा के बाद',
        'improving' => 'हमेशा सुधार',
        'experience' => 'अनुभव',
        'no_change' => 'कोई परिवर्तन नहीं, कोई परेशानी नहीं',
        'fares_atuo' => 'किराए स्वचालित रूप से सवार के फ़ाइल में भुगतान विधि पर चार्ज किए जाते हैं, इसलिए अधिकांश यात्राओं के लिए आप पूरी तरह से नकदी का उपयोग करने से बच सकते हैं। लेकिन अगर सवार नकद में भुगतान करते हैं, तो ऐप स्वचालित रूप से क्रेडिट जारी करता है ताकि आपको कभी भी परिवर्तन करने की आवश्यकता न हो।',
        'driver_feedback' => 'ड्राइवर फीडबैक',
        'rate_your_driver' => 'आप हर यात्रा के बाद अपने सवार को रेट करते हैं। हम उन रेटिंग्स की समीक्षा करते हैं ताकि यह सुनिश्चित हो सके कि हर कोई जिसे आप उठाते हैं वह उतना ही सम्मानजनक है जितना आप हैं। हमारी सेवा की शर्तों का उल्लंघन करने वाले सवारों को उपयोग से रोका जा सकता है',
        'drive_safely' => 'सुरक्षित रूप से ड्राइव करें',
        'information' => 'इस वेब पेज पर दी गई जानकारी केवल सूचना के उद्देश्य से है और आपके देश, क्षेत्र, या शहर में लागू नहीं हो सकती है। इसे बिना सूचना के बदला जा सकता है और अपडेट किया जा सकता है।',
        'drivers_first' => 'ड्राइवरों को पहले रखना',
        'exp_around' => 'आपके चारों ओर बनाया गया अनुभव',
        'control_with' => 'आप नियंत्रण में हैं',
        'app_for_drivers' => 'ड्राइवरों के लिए ऐप में विशेषताएं डिज़ाइन की गई हैं जो आपको यह तय करने में मदद करती हैं कि आप कैसे, कहाँ, और कब कमाएँ।',
        'going_online' => 'ऑनलाइन जाना',
        'always_avail' => 'हमेशा उपलब्ध है। इसलिए जब भी आप ड्राइव करने के लिए तैयार हों, ऐप खोलें और गो ऑनलाइन पर टैप करें।',
        'accept_trip_request' => 'यात्रा अनुरोध स्वीकार करना',
        'receive_trip_request' => 'ऑनलाइन होने के बाद, आप अपने क्षेत्र में यात्रा अनुरोध स्वचालित रूप से प्राप्त करना शुरू करेंगे। आपका फोन बीप करेगा और स्क्रीन चमकेगी—स्वीकार करने के लिए टैप करें।',
        'turn_by_turn' => 'टर्न-बाय-टर्न दिशानिर्देश',
        'provides_navigation' => 'ऐप आपके सवार के पिकअप स्थान के लिए नेविगेशन प्रदान करता है, और हम उन्हें बताएंगे जब आप लगभग वहां होंगे। एक बार यात्रा शुरू होने के बाद, आपको उनके गंतव्य के लिए दिशानिर्देश मिलेंगे।',
        'track_earnings' => 'अपनी कमाई ट्रैक करें',
        'summaries' => 'हर यात्रा के बाद, आप देखेंगे कि आपने कितना कमाया और अपने दिन की कुल कमाई का व्यापक सारांश। कमाई हर सप्ताह आपके बैंक खाते में स्वचालित रूप से ट्रांसफर होती है, या आप प्रति दिन 5 बार तुरंत नकद निकाल सकते हैं।',
        'rating' => 'रेटिंग प्रणाली',
        'rider_driver_rate' => 'रेटिंग्स एक दो-तरफा सड़क है। सवार और ड्राइवर हर यात्रा के बाद एक दूसरे को रेट करते हैं ताकि केवल सम्मानजनक, शिष्ट लोग ही',
        'platform' => 'मंच पर अनुमत हों।',
        'communication' => 'संचार',
        'feedback_success' => 'सफलता के लिए फीडबैक',
        'stay_informed' => 'सूचित रहें',
        'customized_updates' => 'अपने शहर में स्थानीय घटनाओं और प्रचारों के बारे में अनुकूलित अपडेट प्राप्त करें, और सर्वोत्तम वितरण के सुझाव प्राप्त करें',
        'rider_comment' => 'सवार की टिप्पणियाँ',
        'rating_section' => 'रेटिंग अनुभाग का उपयोग करके यह जानें कि लोग अपनी 5-स्टार यात्राओं के बारे में क्या प्यार करते हैं और यह पता करें कि सवार कम रेटिंग क्यों देते हैं ताकि आप इसके अनुसार समायोजन करने का निर्णय ले सकें।',
        'start_drive_now' => 'अभी ड्राइविंग शुरू करें',
        'start_drive_nowive' => 'के साथ ड्राइव करें',
        'earn_your_terms' => 'और अपनी शर्तों पर कमाएं।',
        'already_signed_up' => 'पहले ही साइन अप कर लिया?',
        'invite_friends' => 'अपने दोस्तों को आजमाने के लिए आमंत्रित करें',
        'you_earn' => 'और जब वे सड़क पर उतरेंगे, तो आप अतिरिक्त कमाई करेंगे।',
        'info_page' => 'इस वेब पेज पर दी गई जानकारी केवल सूचना के उद्देश्य से है और आपके देश, क्षेत्र, या शहर में लागू नहीं हो सकती है। इसे बिना सूचना के बदला जा सकता है और अपडेट किया जा सकता है।',
        'driver_requirments' => 'ड्राइवर आवश्यकताएँ',
        'how_to_drive' => 'कैसे ड्राइव करें',
        'own_boss' => 'आपका अपना बॉस होना और अच्छा पैसा कमाना एक शानदार तरीका है। एक व्यावसायिक लाइसेंस से लेकर कार तक,',
        'help_you_every' => 'आपको हर कदम पर मदद कर सकता है।',
        'min_requirments' => 'न्यूनतम आवश्यकताएं',
        'commercial_license' => 'न्यूयॉर्क सिटी में ड्राइव करने के लिए, आपको NYC TLC (टैक्सी और लिमोसिन कमीशन) से एक व्यावसायिक लाइसेंस और एक व्यावसायिक रूप से लाइसेंस प्राप्त वाहन की आवश्यकता होगी।',
        'help_you_both' => 'आपको दोनों में मदद कर सकता है।',
        'what_you_need' => 'यहां आपको क्या चाहिए:',
        'driver_license' => 'एक मान्य यूएस ड्राइवर का लाइसेंस',
        'tlc_license' => 'एक टीएलसी ड्राइवर का लाइसेंस',
        'tlc_license_vehicle' => 'एक टीएलसी-लाइसेंस प्राप्त वाहन (आप एक किराए पर ले सकते हैं या अपना पंजीकृत कर सकते हैं)',
        'require_documents' => 'आवश्यक दस्तावेज़',
        'addition_documents' => 'उपरोक्त आवश्यकताओं के अलावा, आपको निम्नलिखित दस्तावेज़ों की भी आवश्यकता होगी:',
        'proof_insurance' => 'व्यावसायिक बीमा का प्रमाण',
        'proof_vehicle_registration' => 'व्यावसायिक वाहन पंजीकरण का प्रमाण',
        'vehicle_permit' => 'एक टीएलसी-फॉर-हायर वाहन परमिट',
        'ready_make_money' => 'पैसा बनाने के लिए तैयार?',
        'first_step' => 'पहला कदम साइन अप करना है',
    ],
    'user' => [
        'disabled' => 'खाता अक्षम',
        'protect' => 'आपकी जानकारी की सुरक्षा के लिए, हमने अस्थायी रूप से आपका खाता अक्षम कर दिया है। कृपया जारी रखने के लिए हमें ईमेल करें।',
        'email_us' => 'हमें ईमेल करें',
        'vehicle_info' => 'अपनी वाहन जानकारी दर्ज करें',
        'vehicle_name' => 'वाहन का नाम / उदाहरण: टोयोटा कैमरी, होंडा अकॉर्ड...',
        'vehicle_number' => 'वाहन संख्या / उदाहरण: WNF 382',
        'vehicle_type' => 'अपना वाहन प्रकार चुनें',
        'continue' => 'जारी रखें',
        'forgot_paswrd' => 'पासवर्ड भूल गए',
        'next' => 'अगला',
        'no_account' => 'क्या आपके पास खाता नहीं है?',
        'reset_paswrd' => 'कृपया अपना पासवर्ड रीसेट करें,',
        'continue_with' => 'फेसबुक के साथ जारी रखें',
        'continue_with_google' => 'गूगल के साथ जारी रखें',
        'continue_with_apple' => 'एप्पल के साथ जारी रखें',
        'need_partner' => 'को आपके जैसे भागीदारों की जरूरत है।',
        'need_partner_content' => 'और स्वतंत्र ठेकेदार के रूप में अच्छी कमाई करें। हमारे समुदाय के सवारों को शहर के चारों ओर सवारी पाने में मदद करने के लिए साप्ताहिक भुगतान प्राप्त करें। अपना बॉस बनें और अपने शेड्यूल पर गाड़ी चलाने के लिए किराए में भुगतान प्राप्त करें।',
        'correct' => 'कृपया निम्नलिखित को सही करें:',
        'create_account' => 'नया खाता बनाएँ',
        'proceed' => 'आगे बढ़कर, मैं सहमत हूं कि',
        'contact' => 'या उसके प्रतिनिधि मुझे ईमेल, फोन, या एसएमएस (स्वचालित साधनों सहित) के माध्यम से संपर्क कर सकते हैं जो मैंने प्रदान किया है, जिसमें विपणन उद्देश्यों के लिए भी शामिल है।',
        'money_make' => 'अच्छा पैसा कमाएं।',
        'money_make_content' => 'क्या आपके पास कार है? इसे एक पैसे की मशीन में बदल दें। शहर में हलचल है और :site_name आपके लिए इसे आसान बनाता है। और, शुरू करने के लिए आपके पास पहले से ही सब कुछ है।',
        'drive_when_want' => 'जब चाहें गाड़ी चलाएं।',
        'drive_when_want_content' => '९ से ५ के बाहर कुछ चाहिए? एक स्वतंत्र ठेकेदार के रूप में',
        'imp_moments' => 'आपको स्वतंत्रता और लचीलापन मिलता है जब भी आपके पास समय हो गाड़ी चलाने का। अपना शेड्यूल सेट करें, ताकि आप जीवन के सभी महत्वपूर्ण क्षणों में उपस्थित रह सकें।',
        'no_office' => 'कोई कार्यालय नहीं, कोई बॉस नहीं।',
        'no_office_content' => 'चाहे आप अपने परिवार का समर्थन कर रहे हों या कुछ बड़ा बचा रहे हों,',
        'freedom' => 'आपको स्वतंत्रता देता है जब आपके लिए सही हो तब गाड़ी चलाने की। चुनें जब आप गाड़ी चलाते हैं, कहाँ जाते हैं, और किसे उठाते हैं।',
        'safe_reliable' => 'मिनटों में सुरक्षित, विश्वसनीय सवारी',
        'promo' => 'प्रोमो कोड',
        'clicking_terms' => 'क्लिक करके "साइन अप", आप सहमत हैं ',
        'terms' => 'के नियम और शर्तें',
        'and' => 'और',
        'privacy' => 'गोपनीयता नीति',
        'submit' => 'जमा करें',
        'firstname' => 'पहला नाम',
        'lastname' => 'अंतिम नाम',
        'email' => 'ईमेल',
        'mobile' => 'मोबाइल',
        'paswrd' => 'पासवर्ड',
        'drive_with_Ridein' => 'के साथ गाड़ी चलाएं',
        'ride_with' => 'सवारी करें',
        'update' => 'अपडेट करें',
        'email_address' => 'ईमेल या मोबाइल नंबर दर्ज करें',
        'mobile_no' => 'मोबाइल नंबर कम से कम ६ अंकों का होना चाहिए',
        'disabled_account' => 'उपयोगकर्ता को अक्षम कर दिया गया है',
        'disabled_company_account' => 'कंपनी को अक्षम कर दिया गया है',
        'no_recognize' => 'यह मोबाइल नंबर द्वारा पहचाना नहीं जा सकता है ',
        'no_recognize_email' => 'यह ईमेल द्वारा पहचाना नहीं जा सकता है :site',
        'no_paswrd' => 'आपके द्वारा दर्ज किया गया पासवर्ड गलत है।',
        'link' => 'हमने आपका पासवर्ड रीसेट करने के लिए एक लिंक भेजा है ',
        'mobile_no_exists' => 'मोबाइल नंबर पहले से मौजूद है',
        'email_exists' => 'ईमेल पहले से मौजूद है',
        'register_successfully' => 'सफलतापूर्वक पंजीकृत',
        'login_failed' => 'लॉग इन विफल। कृपया अपना ईमेल/पासवर्ड जांचें।',
        'google_login_failed' => 'लॉग इन विफल।',
        'country_code' => 'देश कोड',
        'user_type' => 'उपयोगकर्ता प्रकार',
        'veh_name' => 'वाहन का नाम',
        'veh_no' => 'वाहन संख्या',
        'veh_type' => 'वाहन प्रकार',
        'token' => 'टोकन समाप्त हो गया है।',
        'invalid_token' => 'अमान्य टोकन।',
        'new_paswrd' => 'नया पासवर्ड',
        'cnfrm_paswrd' => 'पासवर्ड की पुष्टि करें',
        'pswrd_chnge' => 'पासवर्ड सफलतापूर्वक बदल गया है।',
        'profile_image' => 'प्रोफ़ाइल छवि',
        'license_image' => 'लाइसेंस छवि अपलोड नहीं कर सके',
        'update_success' => 'सफलतापूर्वक अपडेट किया गया',
        'update_fail' => 'प्रोफ़ाइल छवि अपलोड नहीं कर सके',
        'invalid_file_type' => 'अमान्य फाइल प्रकार। केवल JPG, GIF और PNG प्रकार स्वीकार किए जाते हैं।',
        'insurance_image' => 'बीमा छवि अपलोड नहीं कर सके',
        'rc_image' => 'आरसी बुक छवि अपलोड नहीं कर सके',
        'permit_image' => 'परमिट छवि अपलोड नहीं कर सके',
        'add_success' => 'सफलतापूर्वक जोड़ा गया',
        'rc_book' => 'आरसी बुक',
        'insurance' => 'बीमा',
        'permit' => 'परमिट',
        'begin_trip' => 'यात्रा शुरू करें',
        'end_trip' => 'यात्रा समाप्त करें',
        'email_mobile' => 'अपना ईमेल या मोबाइल नंबर दर्ज करें',
        'service_not_available_country' => 'चयनित देश के लिए सेवा उपलब्ध नहीं है',
        'active_message' => 'आपकी प्रोफ़ाइल सक्रिय हो गई है',
        'pending_message' => 'कृपया कार या दस्तावेज़ विवरण के लिए प्रशासन से अनुमोदन की प्रतीक्षा करें',
        'car_details_message1' => 'कृपया अपने वाहन का विवरण अपलोड करें',
        'car_details_message2' => 'कृपया अपने वाहन के दस्तावेज़ का विवरण अपलोड करें',
        'document_details_message' => 'कृपया अपने ड्राइवर के दस्तावेज़ का विवरण अपलोड करें',
        'inactive_message' => 'आपकी प्रोफ़ाइल निष्क्रिय हो गई है',
        'default_vehicle_delete_msg' => 'डिफ़ॉल्ट वाहन को हटाया नहीं जा सकता',
        'delete_success' => 'सफलतापूर्वक हटाया गया',
        'vehicle_not_activated' => 'वाहन अभी तक सक्रिय नहीं हुआ है',
        'default_vehicle_trip_error' => 'डिफ़ॉल्ट वाहन पहले से ही यात्रा में है, इसलिए आप इस वाहन को डिफ़ॉल्ट के रूप में सेट नहीं कर सकते',
    ]
];
