<?php

/**
 * Send sms via Twillio
 *
 * @package     Ridein
 * @subpackage  Services
 * @category    Msg 19 Service
 * @author      Source Monster Team
 * @version     2.2
 * @link        https://sourcemonster.in
*/

namespace App\Services\SMS;

use Illuminate\Http\Request;
use App\Contracts\SMSInterface;
use Craftsys\Msg91\Facade\Msg91;
use Illuminate\Support\Facades\Config;

/// otp template ID : 6848232bd6fc0503b306f782
// template:  Your Mahayatri login OTP is ##OTP##. Do not share this OTP with anyone. It is valid for 10 minutes. MHYTRI

class Msg19Sms implements SMSInterface
{
	
	public function initialize(){
		
		Config::set('services.msg91.key', api_credentials('auth_key', 'MSG19'));
	}
	
	
		/**
     * Send OTP message
     *
     * @param String $phone_number
     * @return Array SMS Response
     */
	protected function sendOTP($phone_number)
	{
		try {
			
			$data = Msg91::otp()->to(str_replace('+', '', $phone_number))
		    ->options(function (\Craftsys\Msg91\OTP\Options $options) {
				$options->digits((int)site_settings('otp_length')); 
			})
			->template('6848232bd6fc0503b306f782')
			->send();
	
			return array('status_code' => 1,'message'=>'Success','status'=>true);
		} 
		catch(\Exception $e) {
			return array('status_code' => 0,'message'=>$e->getMessage() ,'status'=>false);
		}
	}
	
	
	/**
     * Verify OTP number
     *
     * @param String $phone_number, String $verification_code
     * @return Array SMS Response
     */
	protected function verifyOTP($phone_number, $verification_code)
	{
		try {

		 
			$verification = Msg91::otp((int)$verification_code)
			->to(str_replace('+', '', $phone_number))
			->verify();
			
			$response = $verification->getData();
			
			
			if($response['type'] === 'success')
				return array('status_code' => 1,'message'=> $response['message'],'status'=>true);
			else 
				return array('status_code' => 0,'message'=>__('messages.signup.wrong_otp'),'status'=>false);
		} 
		catch(\Exception $e) {
			return array('status_code' => 0,'message'=>__('messages.signup.wrong_otp'),'status'=>false);
		}
	}
	
	
		/**
     * Send Text message to mobile
     *
     * @param String $phone_number, String $verification_code
     * @return Array SMS Response
     */
	public function send($phone_number, $text='',$verification_code=false)
	{
		$this->initialize();
		if($text){
			$result = $this->SendTextMessage($phone_number,$text);
		}
		else if($verification_code) {
			$result = $this->verifyOTP($phone_number, $verification_code);
		} else {
			$result = $this->sendOTP($phone_number);
		}
		return $result;
	}
	
	
	/**
     * Send Text message to mobile
     *
     * @param String $[to] user phone number
     * @param String $[text] [message to be send]
     * @return Array SMS Response
     */
	public function SendTextMessage($to,$text)
	{
		try {
			
		
		}catch(\Exception $e) {
			return array('status_code' => 0,'message'=>__('messages.signup.wrong_otp'),'status'=>false);
		}
	}
	
			
	
}