<?php

/**
 * Paystack Payment Service
 *
 * @package     Ridein
 * @subpackage  Services\Payments
 * @category    Paystack
 * @author      Source Monster Team
 * @version     2.2.1
 * @link        https://sourcemonster.in
 */

namespace App\Services\Payments;

use App\Contracts\PaymentInterface;
use App\Services\PaymentMethods\PaystackPayment as PaystackGateway;

class PaystackPayment extends PaystackGateway implements PaymentInterface
{


    public function view()
    {

        return array('view' => 'payment.paystack');
    }

    public function Payment($paymentData, $authCode)
    {
        $responce = $this->makePayment($paymentData, $authCode);
        return $this->returnResponce($responce);
    }


    public function Verify($requestData)
    {
        $responce = $this->paymentVerify($requestData);
        return $this->returnResponce($responce);
    }

    public function webHook($requestData, $signature)
    {
        $responce = $this->handleWebHook($requestData, $signature);
        return $this->returnResponce($responce);
    }


    public function returnResponce($responce)
    {
        $responce->status_code =  $responce->status ? "1" : "0";
        return $responce;
    }
}
