<?php


return [
	'admin' => [
		'dashboard' => 'Tablero',
		'copyright' => 'Derechos de autor',
		'all_rights_reserved' => 'Todos los derechos reservados',
		'manage_admin' => [
			'title' => 'Administrar administradores',
			'admin_users' => 'Usuarios administradores',
			'role_and_permissions' => 'Roles y permisos'
		],
		"manage_company" => 'Gestionar empresa',
		'manage_drivers' => 'Gestionar conductores',
		'manage_riders' => 'Gestionar pasajeros',
		'manage_documents' => 'Gestionar documentos',
		'send_messages' => 'Enviar mensajes',
		'manage_emails' => [
			'title' => 'Gestionar Correos Electrónicos',
			'send_mail' => 'Enviar correo',
			'email_settings' => 'Configuraciones de correo electrónico'
		],
		'manage_manual_booking' => [
			'title' => 'Gestionar reservas manuales',
			'manual_booking' => 'Reserva manual',
			'view_manual' => 'Ver reservas manuales/programadas'
		],
		'vehicle_make' => 'Marca del vehículo',
		'vehicle_model' => 'Modelo del vehículo',
		'additional_reasons' => 'Motivos adicionales',
		'manage_cancel_reason' => 'Administrar motivos de cancelación',
		'manage_locations' => 'Gestionar ubicaciones',
		'manage_fare' => 'Gestionar tarifas',
		'manage_trips' => [
			'title' => 'Gestionar Viajes',
			'manage_ride_requests' => 'Gestionar Solicitudes de Viaje',
			'manage_trips' => 'Gestionar Viajes',
			'manage_canceled_trips' => 'Gestionar Viajes Cancelados',
			'cancelled_trips' => 'Viajes Cancelados',
			'manage_payments' => 'Gestionar Pagos',
			'request_details' => 'Detalles de la Solicitud',
			'ratings' => 'Calificaciones',
			'payments' => 'Pagos',
			'ride_requests' => 'Solicitudes de Viaje',
			'trips' => 'Viajes',
		],
		'manage_payouts' => [
			'title' => 'Gestionar Pagos',
			'company_payouts' => 'Pagos de la Empresa',
			'driver_payouts' => 'Pagos del Conductor',
			'driver_payouts_title' => 'Gestionar Conductor :payout_title',
			'company_payouts_title' => 'Gestionar Empresa :payout_title',
			'table' => [
				'id' => 'ID',
				'driver_id' => 'ID del Conductor',
				'driver_name' => 'Nombre del Conductor',
				'payout_amount' => 'Monto del Pago',
				'company_id' => 'ID de la Empresa',
				'company_name' => 'Nombre de la Empresa',
				'payout_amount' => 'Monto del Pago',
				'action' => 'Acción',
			]
		],
		'manage_owe_amount' => 'Gestionar deuda',
		'manage_statements' => [
			'title' => 'Administrar Declaraciones',
			'overall_statements' => 'Declaraciones Generales',
			'drivers_statments' => 'Declaraciones de Conductores',
			'statements' => 'Declaraciones',
			'filter_by' => 'Filtrar Por',
			'search' => 'Buscar',
			'total_amount_received' => 'Cantidad Total Recibida',
			'total_earnings' => 'Ganancias Totales',
			'completed_rides' => 'Viajes Completados',
			'cancelled_rides' => 'Viajes Cancelados',
			'drivers' => 'Conductores',
			'overall' => 'Total',
			'view_by_rider' => 'Ver Por Pasajero',
			'from_date' => 'Desde la Fecha',
			'to_date' => 'Hasta la Fecha',
			'today' => 'Hoy',
			'weekly' => 'Semanal',
			'monthly' => 'Mensual',
			'yearly' => 'Anual',
			'custom' => 'Personalizado',
			'view_trip_details' => 'Ver Detalles del Viaje',
			'table' => [
				'driver_id' => 'ID del Conductor',
				'driver_name' => 'Nombre del Conductor',
				'mobile' => 'Móvil',
				'total_rides' => 'Total de Viajes',
				'earnings' => 'Ganancias',
				'joined_at' => 'Unido En',
				'details' => 'Detalles',
				'booking_id' => 'ID de Reserva',
				'company_name' => 'Nombre de la Empresa',
				'pickup_location' => 'Lugar de Recogida',
				'drop_location' => 'Lugar de Dejada',
				'trip_details' => 'Detalles del Viaje',
				'admin_commission' => 'Comisión del Administrador',
				'admin_payout_status' => 'Estado del Pago del Administrador',
				'dated_on' => 'Fechado En',
				'status' => 'Estado',
				'earned' => 'Ganado'
			]
		],
		'manage_wallet_and_promo' => [
			'title' => 'Administrar Billetera y Promociones',
			'wallet' => 'Billetera',
			'manage_wallet_amount' => 'Administrar Monto de Billetera',
			'manage_promo_code' => 'Administrar Código de Promoción',
			'add_wallet' => 'Agregar Billetera',
			'add_wallet_amount' => 'Agregar Monto de Billetera',
			'add_title' => 'Formulario de Agregar Billetera',
			'edit_wallet' => 'Editar Monto de Billetera',
			'edit_title' => 'Formulario de Editar Billetera',
			'rider' => 'Pasajero',
			'promo_code' => 'Código de Promoción',
			'add_promo_code' => 'Agregar Código de Promoción',
			'add_promo_code_form' => 'Formulario de Agregar Código de Promoción',
			'edit_promo_code' => 'Editar Código de Promoción',
			'edit_promo_code_form' => 'Formulario de Editar Código de Promoción',
			'table' => [
				'id' => 'ID',
				'user_id' => 'ID de Usuario',
				'first_name' => 'Nombre',
				'last_name' => 'Apellido',
				'wallet_amount' => 'Monto de Billetera',
				'currency_code' => 'Código de Moneda',
				'action' => 'Acción',
				'code' => 'Código',
				'original_amount' => 'Monto Original',
				'expire_date' => 'Fecha de Vencimiento',
				'status' => 'Estado',
			],
			'form' => [
				'username' => 'Nombre de Usuario',
				'amount' => 'Monto',
				'currency_code' => 'Código de Moneda',
				'promo_code' => 'Código de Promoción',
				'expire_date' => 'Fecha de Vencimiento',
				'status' => 'Estado',
			]
		],
		'referrals' => [
			'title' => 'Referencias',
			'drivers' => 'Conductores',
			'riders' => 'Pasajeros',
			'referral' => 'Referencia',
			'view_referral_details' => 'Ver Detalles de la Referencia',
			'details' => 'Detalles',
			'table' => [
				'id' => 'ID',
				'name' => 'Nombre',
				'driver_name' => 'Nombre del Conductor',
				'referral_name' => 'Nombre de la Referencia',
				'currency_code' => 'Código de Moneda',
				'earned_amount' => 'Monto Ganado',
				'pending_amount' => 'Monto Pendiente',
				'action' => 'Acción',
				'trips' => 'Viajes',
				'remaining_trips' => 'Viajes Restantes',
				'remaining_days' => 'Días Restantes',
				'amount' => 'Monto',
				'status' => 'Estado',
			]
		],
		'manage_map' => [
			'title' => 'Gestionar Mapa',
			'map_view' => 'Vista del Mapa',
			'heat_map' => 'Mapa de Calor',
			'map' => 'Mapa',
			'user' => 'Usuario',
			'unavailable_driver' => 'Conductor No Disponible',
			'available_driver' => 'Conductor Disponible',
			'unactivated_driver' => 'Conductor No Activado',
		],

		'manage_mobile_app_version' => [
			'title' => 'Gestionar Versión de Aplicación Móvil',
			'subtitle' => 'Versión de Aplicación Móvil',
			'edit_mobile_app_version_form' => 'Formulario de Edición de Versión de Aplicación Móvil',
			'add_mobile_app_version_form' => 'Formulario de Agregar Versión de Aplicación Móvil',
			'table' => [
				'id' => 'ID',
				'version' => 'Versión',
				'device_type' => 'Tipo de Dispositivo',
				'user_type' => 'Tipo de Usuario',
				'force_update' => 'Actualización Forzada',
				'created_at' => 'Creado En',
				'updated_at' => 'Actualizado En',
				'action' => 'Acción',
			],
			'form' => [
				'version' => 'Versión',
				'device_type' => 'Tipo de Dispositivo',
				'user_type' => 'Tipo de Usuario',
				'force_update' => 'Actualización Forzada',
			]
		],
		'api_credentials' => [
			'title' => 'Credenciales de API',
			'form_title' => 'Formulario de Credenciales de API',
			'form' => [
				'google_map_key' => 'Clave de Google Map',
				'google_map_server_key' => 'Clave de Servidor de Google Map',
				'twillo_sid' => 'Twillo SID',
				'twillo_token' => 'Token de Twillo',
				'twillo_from_number' => 'Número de Envío de Twillo',
				'twillo_service_sid' => 'Twillo Servicio SID',
				'apple_service_id' => 'ID de Servicio de Apple',
				'apple_team_id' => 'ID de Equipo de Apple',
				'apple_key_id' => 'ID de Clave de Apple',
				'apple_key_file' => 'Archivo de Clave de Apple',
				'firebase_database_url' => 'URL de la Base de Datos de Firebase',
				'firebase_service_account' => 'Archivo de Cuenta de Servicio de Firebase (JSON)'
			]
		],
		'payment_gateway' => [
			'title' => 'Pasarela de Pago',
			'form_title' => 'Formulario de Pasarela de Pago',
			'tabs' => [
				'paypal' => 'Paypal',
				'stripe' => 'Stripe',
				'paytm' => 'Paytm',
				'razorpay' => 'RazorPay',
				'flutterwave' => 'FlutterWave',
				'redsys' => 'Redsys',
				'braintree' => 'Braintree',
				'payout_methods' => 'Métodos de pago',
			],
			'form' => [
				'is_paypal_enabled' => '¿Está habilitado PayPal?',
				'paypal_mode' => 'Modo PayPal',
				'paypal_id' => 'ID de PayPal',
				'paypal_client_id' => 'ID de Cliente de PayPal',
				'paypal_secret' => 'Secreto de PayPal',
				'paypal_access_token' => 'Token de Acceso de PayPal',
				'is_stripe_enabled' => '¿Está habilitado Stripe?',
				'stripe_key' => 'Clave de Stripe',
				'stripe_secret' => 'Secreto de Stripe',
				'stripe_api_version' => 'Versión de API de Stripe',
				'is_paytm_enabled' => '¿Está habilitado Paytm?',
				'paytm_mode' => 'Modo Paytm',
				'paytm_merchant_id' => 'ID de Comerciante de Paytm',
				'paytm_merchant_key' => 'Clave de Comerciante de Paytm',
				'paytm_merchant_website' => 'Sitio Web de Comerciante de Paytm',
				'paytm_merchant_channel' => 'Canal de Comerciante de Paytm',
				'paytm_industry_type' => 'Tipo de Industria de Paytm',
				'is_razorpay_enabled' => '¿Está habilitado Razorpay?',
				'razorpay_mode' => 'Modo Razorpay',
				'razorpay_key' => 'Clave de Razorpay',
				'razorpay_secret' => 'Secreto de Razorpay',
				'is_flutterwave_enabled' => '¿Está habilitado Flutterwave?',
				'flutterwave_key' => 'Clave de Flutterwave',
				'flutterwave_secret' => 'Secreto de Flutterwave',
				'flutterwave_hash' => 'Hash de Flutterwave',
				'is_redsys_enabled' => '¿Está habilitado Redsys?',
				'redsys_mode' => 'Modo Redsys',
				'redsys_merchant_mode' => 'Código de Comerciante de Redsys',
				'redsys_key' => 'Clave de Redsys',
				'redsys_terminal' => 'Terminal de Redsys',
				'redsys_url_notification' => 'URL de Notificación de Redsys',
				'redsys_url_ok' => 'URL de Éxito de Redsys',
				'redsys_url_ko' => 'URL de Error de Redsys',
				'redsys_tradename' => 'Nombre Comercial de Redsys',
				'is_braintree_enabled' => '¿Está habilitado Braintree?',
				'payment_mode' => 'Modo de Pago',
				'braintree_merchant_id' => 'ID de Comerciante de Braintree',
				'Braintree_merchant_account_id' => 'ID de Cuenta de Comerciante de Braintree',
				'braintree_public_key' => 'Clave Pública de Braintree',
				'braintree_private_key' => 'Clave Privada de Braintree',
				'braintree_tokenization_key' => 'Clave de Tokenización de Braintree',
				'web_payment' => 'Pago en la Web',
				'payout_methods' => 'Métodos de Pago'
			]
		],
		'mange_fees' => [
			'title' => 'Gestionar Tarifas',
			'fees' => 'Tarifas',
			'fees_form' => 'Formulario de Tarifas',
			'form' => [
				'rider_service_fee' => 'Tarifa de Servicio del Pasajero',
				'driver_peak_fare' => 'Tarifa Pico del Conductor',
				'is_pool' => 'Monto del Segundo Pasajero',
				'is_pool_small' => 'Para Viajes Compartidos',
				'driver_service_fee' => 'Tarifa de Servicio del Conductor',
				'apply_trip_additional_fee' => 'Aplicar Tarifa Adicional al Viaje'
			]
		],
		'manage_referral_settings' => [
			'title' => 'Gestionar Configuraciones de Referencias',
			'referral_settings' => 'Configuraciones de Referencias',
			'form_title' => 'Formulario de Configuración de Referencias de Conductores',
			'form' => [
				'number_of_trips' => 'Número de Viajes',
				'driver_days' => 'Periodo de Tiempo (En días)',
				'currency_code' => 'Código de Moneda',
				'driver_amount' => 'Monto por Viajes',
				'referral_amount' => 'Monto de Referencia',
				'time_frame' => 'Periodo de Tiempo'
			]
		],
		'manage_metas' => [
			'title' => 'Gestionar Metadatos',
			'metas' => 'Metadatos',
			'edit_meta' => 'Editar Metadatos',
			'edit_meta_form' => 'Formulario de Edición de Metadatos',
			'table' => [
				'id' => 'ID',
				'url' => 'URL',
				'title' => 'Título',
				'description' => 'Descripción',
				'keywords' => 'Palabras Clave',
				'action' => 'Acción'
			],
			'form' => [
				'page_url' => 'URL de la Página',
				'page_title' => 'Título de la Página',
				'meta_description' => 'Descripción del Meta',
				'keywords' => 'Palabras Clave'
			]
		],
		'manage_country' => [
			'title' => 'Gestionar Países',
			'country' => 'País',
			'add_country' => 'Agregar País',
			'add_country_form' => 'Formulario para Agregar País',
			'edit_country' => 'Editar País',
			'edit_country_form' => 'Formulario para Editar País',
			'table' => [
				'id' => 'ID',
				'short_name' => 'Nombre Corto',
				'long_name' => 'Nombre Largo',
				'iso3' => 'Iso3',
				'num_code' => 'Código Numérico',
				'phone_code' => 'Código Telefónico',
				'action' => 'Acción',
			],
			'form' => [
				'short_name' => 'Nombre Corto',
				'long_name' => 'Nombre Largo',
				'iso3' => 'Iso3',
				'num_code' => 'Código Numérico',
				'phone_code' => 'Código Telefónico',
			]
		],
		'manage_currency' => [
			'title' => 'Gestionar Monedas',
			'currency' => 'Moneda',
			'add_currency' => 'Agregar Moneda',
			'add_currency_form' => 'Formulario para Agregar Moneda',
			'edit_currency' => 'Editar Moneda',
			'edit_currency_form' => 'Formulario para Editar Moneda',
			'table' => [
				'id' => 'ID',
				'name' => 'Nombre',
				'code' => 'Código',
				'rate' => 'Tasa',
				'status' => 'Estado',
				'action' => 'Acción',
			],
			'form' => [
				'name' => 'Nombre',
				'code' => 'Código',
				'rate' => 'Tasa',
				'symbol' => 'Símbolo',
				'status' => 'Estado',
			]
		],
		'manage_language' => [
			'title' => 'Gestionar Idiomas',
			'language' => 'Idioma',
			'add_language' => 'Agregar Idioma',
			'add_language_form' => 'Formulario para Agregar Idioma',
			'edit_language' => 'Editar Idioma',
			'edit_language_form' => 'Formulario para Editar Idioma',
			'table' => [
				'id' => 'ID',
				'name' => 'Nombre',
				'value' => 'Valor',
				'status' => 'Estado',
				'action' => 'Acción',
			],
			'form' => [
				'name' => 'Nombre',
				'value' => 'Valor',
				'status' => 'Estado',
			]
		],
		'manage_static_pages' => [
			'title' => 'Gestionar Páginas Estáticas',
			'static_page' => 'Páginas Estáticas',
			'page' => 'Página',
			'add_page' => 'Agregar Página',
			'add_page_form' => 'Formulario para Agregar Página',
			'edit_page' => 'Editar Página',
			'edit_page_form' => 'Formulario para Editar Página',
			'translations' => 'Traducciones',
			'add_translation' => 'Agregar Traducción',
			'table' => [
				'id' => 'Id',
				'name' => 'Nombre',
				'url' => 'Url',
				'status' => 'Estado',
				'updated_at' => 'Actualizado En',
				'action' => 'Acción',
			],
			'form' => [
				'name' => 'Nombre',
				'content' => 'Contenido',
				'footer' => 'Pie de página',
				'status' => 'Estado',
				'language' => 'Idioma',
				'question' => 'Pregunta',
				'answer' => 'Respuesta'
			]
		],
		'manage_help' => [
			'title' => 'Gestionar Ayuda',
			'help' => 'Ayuda',
			'category' => 'Categorías',
			'subcategory' => 'Subcategorías',
			'help_category' => 'Categoría de Ayuda',
			'add_help' => 'Agregar Ayuda',
			'add_help_form' => 'Formulario para Agregar Ayuda',
			'edit_help' => 'Editar Ayuda',
			'edit_help_form' => 'Formulario para Editar Ayuda',
			'help_sub_category' => 'Subcategoría de Ayuda',
			'add_help_category' => 'Agregar Categoría de Ayuda',
			'add_help_category_form' => 'Formulario para Agregar Categoría de Ayuda',
			'edit_help_category_form' => 'Formulario para Editar Categoría de Ayuda',
			'add_help_sub_category' => 'Agregar Subcategoría de Ayuda',
			'add_help_sub_category_form' => 'Formulario para Agregar Subcategoría de Ayuda',
			'edit_help_sub_category' => 'Editar Subcategoría de Ayuda',
			'edit_help_sub_category_form' => 'Formulario para Editar Subcategoría de Ayuda',
			'translations' => 'Traducciones',
			'add_translation' => 'Agregar Traducción',
			'table' => [
				'id' => "Id",
				'category' => 'Categoría',
				'subcategory' => 'Subcategoría',
				'question' => 'Pregunta',
				'suggested' => 'Sugerido',
				'answer' => 'Respuesta',
				'status' => 'Estado',
				'action' => 'Acción',
				'name' => 'Nombre',
				'description' => 'Descripción',
				'suggested' => 'Sugerido',
			],
			'form' => [
				'language' => 'Idioma',
				'category' => 'Categoría',
				'subcategory' => 'Subcategoría',
				'question' => 'Pregunta',
				'answer' => 'Respuesta',
				'name' => 'Nombre',
				'description' => 'Descripción',
				'suggested' => 'Sugerido',
				'status' => 'Estado',
			]
		],
		'join_us_links' => [
			'title' => 'Enlaces para Unirse',
			'join_us' => 'Únete a Nosotros',
			'join_us_form' => 'Formulario de Únete a Nosotros',
			'form' => [
				'facebook' => 'Facebook',
				'instagram' => 'Instagram',
				'twitter' => 'Twitter',
				'linkedin' => 'LinkedIn',
				'pinterest' => 'Pinterest',
				'youtube' => 'YouTube',
				'app_store_rider' => 'Enlace de la tienda de aplicaciones para el pasajero',
				'app_store_driver' => 'Enlace de la tienda de aplicaciones para el conductor',
				'play_store_rider' => 'Enlace de Play Store para el pasajero',
				'play_store_driver' => 'Enlace de Play Store para el conductor'
			]
		],
		'manage_support' => [
			'title' => 'Gestionar Soporte',
			'support' => 'Soporte',
			'add_support' => 'Agregar Soporte',
			'add_support_form' => 'Formulario para Agregar Soporte',
			'edit_support' => 'Editar Soporte',
			'edit_support_form' => 'Formulario para Editar Soporte',
			'note' => 'Nota* : Por favor llénelo con el código del país.(Ejemplo-911234567890).',
			'table' => [
				'id' => 'Id',
				'name' => "Nombre",
				'link' => 'Enlace',
				'status' => 'Estado',
				'action' => 'Acción',
			],
			'form' => [
				'name' => "Nombre",
				'link' => 'Enlace',
				'status' => 'Estado',
				'image' => 'Imagen',
				'number' => 'Número'
			]
		],
		'site_setting' => [
			'title' => 'Configuraciones del Sitio',
			'site_settings_form' => 'Formulario de Configuraciones del Sitio',
			'pool' => 'Solo Viaje en Grupo',
			'note' => 'Nota : Esta moneda debe ser la misma que tu moneda de Braintree',
			'form' => [
				'site_name' => 'Nombre del Sitio',
				'version' => 'Versión',
				'header_logo' => 'Logotipo del Encabezado',
				'header_white_logo' => 'Logotipo Blanco del Encabezado',
				'favicon' => 'Favicon',
				'timezones' => 'Zonas Horarias',
				'default_currency' => 'Moneda Predeterminada',
				'payment_currency' => 'Moneda de Pago',
				'trip_default_payment_method' => 'Método de Pago Predeterminado del Viaje',
				'driver_kilometer' => 'Kilómetro del Conductor',
				'pickup_kilometer' => 'Kilómetro de Recogida',
				'drop_kilometer' => 'Kilómetro de Entrega',
				'head_code' => 'Agregar código a <head> (para códigos de seguimiento como Google Analytics)',
				'default_language' => 'Idioma Predeterminado',
				'country_code' => 'Código del País',
				'manual_booking_contact_number' => 'Número de Contacto para Reserva Manual',
				'heat_map' => 'Mapa de Calor',
				'heat_map_hours' => 'Horas del mapa de calor',
				'update_location_interval' => 'Intervalo de Actualización de Ubicación',
				'otp_verification' => 'Verificación OTP',
				'covid_feature' => 'Función COVID',
				'driver_request_seconds' => 'Segundos de Solicitud del Conductor',
				'driver_request_limit' => 'Límite de Solicitud del Conductor',
				'pay_to_admin_driver_limit' => 'Límite de Pago al Administrador para el Conductor (Monto Fijo)*',
				'copyright_year' => 'Año de Derechos de Autor',
				'copyright_url' => 'URL de Derechos de Autor',
				'copyright_name' => 'Nombre de Derechos de Autor',
			]
		],
		'control_panel' => 'Panel de control',
		'home' => 'Inicio',
		'fields_are_mandatory' => 'Los campos son obligatorios',
		'submit' => 'Enviar',
		'cancel' => 'Cancelar',
		'add' => 'Añadir',
		"edit" => 'Editar',
		'reset' => 'Restablecer',
		'dashboard_page' => [
			'dashboard' => 'Tablero de control',
			'total_earnings' => 'Ganancias totales',
			'total_drivers' => 'Total de conductores',
			'total_riders' => 'Total de pasajeros',
			'total_trips' => 'Total de viajes',
			'today_earnings' => 'Ganancias de hoy',
			'today_drivers' => 'Conductores de hoy',
			'today_riders' => 'Pasajeros de hoy',
			'today_trips' => 'Viajes de hoy',
			'sales_graph' => 'Gráfico de ventas',
			'calender' => 'Calendario',
			'recent_ride_requests' => 'Solicitudes de viaje recientes',
			'table' => [
				'group_id' => 'ID de grupo',
				'rider_name' => 'Nombre del pasajero',
				'dated_on' => 'Fechado en',
				'status' => 'Estado',
				'driver_name' => 'Nombre del conductor',
				'group_id' => 'ID de grupo',
			]
		],
		'manage_admin_page' => [
			'admin_users' => 'Usuarios Administradores',
			'add_admin_user' => 'Añadir Usuario Administrador',
			'add_admin_user_form' => 'Formulario para Añadir Usuario Administrador',
			"edit_admin_user" => "Editar usuario administrador",
			"edit_admin_user_form" => "Formulario de edición de usuario administrador",
			'add_role' => 'Añadir Rol',
			'add_role_form' => 'Formulario para Añadir Rol',
			'edit_role' => "Editar rol",
			'edit_role_form' => "Formulario de edición del rol",
			'roles' => 'Roles',
			'table' => [
				'id' => 'ID',
				'username' => 'Nombre de usuario',
				'email' => 'Correo electrónico',
				'status' => 'Estado',
				'action' => 'Acción',
				'name' => 'Nombre',
				'display_name' => 'Nombre para Mostrar',
				'description' => 'Descripción',
			],
			'form' => [
				'name' => 'Nombre',
				'username' => 'Nombre de usuario',
				'email' => 'Dirección de correo electrónico',
				'password' => 'Contraseña',
				'country_code' => 'Código del país',
				'mobile_number' => 'Número de móvil (para propósitos de SOS)',
				'role' => 'Rol',
				'status' => 'Estado',
				'display_name' => 'Nombre para Mostrar',
				'description' => 'Descripción',
				'permissions' => 'Permisos',
			]
		],
		"manage_company_page" => [
			'title' => 'Administrar Empresa',
			'add_company' => 'Añadir Empresa',
			'add_company_form' => 'Formulario de Añadir Empresa',
			'edit_company' => 'Editar Empresa',
			'edit_company_form' => 'Formulario de Editar Empresa',
			'companies' => 'Empresas',
			'form' => [
				'name' => 'Nombre',
				'vat_number' => 'Número de IVA',
				'email' => 'Correo electrónico',
				'password' => 'Contraseña',
				'country_code' => 'Código del país',
				'mobile_number' => 'Número de móvil',
				'status' => 'Estado',
				'address_line' => 'Dirección',
				'city' => 'Ciudad',
				'state' => 'Estado',
				'postal_code' => 'Código postal',
				'profile' => 'Perfil',
				'company_commission' => 'Comisión de la empresa'
			],
			'table' => [
				'id' => 'Id',
				'name' => 'Nombre',
				'drivers' => 'Conductores',
				'email' => 'Correo electrónico',
				'mobile_number' => 'Número de móvil',
				'status' => 'Estado',
				'action' => 'Acción'
			]
		],
		"manage_drivers_page" => [
			'title' => 'Administrar Conductores',
			'drivers' => 'Conductores',
			'add_driver' => 'Añadir Conductor',
			'add_driver_form' => 'Formulario de Añadir Conductor',
			'edit_driver' => 'Editar Conductor',
			'edit_driver_form' => 'Formulario de Editar Conductor',
			'table' => [
				'id' => 'Id',
				'first_name' => 'Nombre',
				'last_name' => 'Apellido',
				'company_name' => 'Nombre de la empresa',
				'email' => 'Correo electrónico',
				'gender' => 'Género',
				'status' => 'Estado',
				'mobile_number' => 'Número de móvil',
				'device_type' => 'Tipo de dispositivo',
				'created_at' => 'Creado en',
				'action' => 'Acción',
			],
			'form' => [
				'first_name' => 'Nombre',
				'last_name' => 'Apellido',
				'password' => 'Contraseña',
				'country_code' => 'Código del país',
				'company_name' => 'Nombre de la empresa',
				'email' => 'Correo electrónico',
				'gender' => 'Género',
				'status' => 'Estado',
				'mobile_number' => 'Número de móvil',
				'device_type' => 'Tipo de dispositivo',
				'address_line1' => 'Dirección línea 1',
				'address_line2' => 'Dirección línea 2',
				'city' => 'Ciudad',
				'state' => 'Estado',
				'postal_code' => 'Código postal',
				'expire_date' => 'Fecha de vencimiento',
				'account_holder_name' => 'Nombre del titular de la cuenta',
				'account_number' => 'Número de cuenta',
				'name_of_bank' => 'Nombre del banco',
				'bank_location' => 'Ubicación del banco',
				'code' => 'Código BIC/SWIFT',
			]
		],
		"manage_riders_page" => [
			'title' => 'Gestionar Conductores',
			'riders' => 'Conductores',
			'add_rider' => 'Agregar Conductor',
			'add_rider_form' => 'Formulario de Agregar Conductor',
			'edit_rider' => 'Editar Conductor',
			'edit_rider_form' => 'Formulario de Editar Conductor',
			'table' => [
				'id' => 'Id',
				'first_name' => 'Nombre',
				'last_name' => 'Apellido',
				'email' => 'Correo Electrónico',
				'gender' => 'Género',
				'status' => 'Estado',
				'mobile_number' => 'Número de Móvil',
				'device_type' => 'Tipo de Dispositivo',
				'created_at' => 'Creado En',
				'action' => 'Acción',
			],
			'form' => [
				'first_name' => 'Nombre',
				'last_name' => 'Apellido',
				'password' => 'Contraseña',
				'country_code' => 'Código del País',
				'email' => 'Correo Electrónico',
				'gender' => 'Género',
				'status' => 'Estado',
				'mobile_number' => 'Número de Móvil',
				'device_type' => 'Tipo de Dispositivo',
				'home_location' => 'Ubicación del Hogar',
				'work_location' => 'Ubicación del Trabajo'
			]
		],
		"manage_documents_page" => [
			'title' => 'Documentos',
			'add_documents' => 'Agregar Documentos',
			'add_documents_form' => 'Formulario de :add Documentos',
			'edit_documents' => 'Editar Documentos',
			'edit_documents_form' => 'Formulario de :edit Documentos',
			'table' => [
				'id' => 'Id',
				'document_for' => 'Documento Para',
				'country' => 'País',
				'document_name' => 'Nombre del Documento',
				'status' => 'Estado',
				'action' => 'Acción',
			],
			'form' => [
				'language' => 'Idioma',
				'document_for' => 'Documento Para',
				'country' => 'País',
				'document_name' => 'Nombre del Documento',
				'status' => 'Estado',
				'expire_on_date' => 'Fecha de Expiración',
			]
		],
		'manage_send_message_page' => [
			'title' => 'Enviar Mensaje',
			'send_message_form' => 'Formulario de Envío de Mensaje',
			'all' => 'Todos',
			'specific_users' => 'Usuarios específicos',
			'sms' => 'SMS',
			'push_notification' => 'Notificación push',
			'all_driver' => 'Conductor',
			'all_rider' => 'Pasajero',
			'all_company' => 'Empresa',
			'all_type' => 'Pasajero & Conductor & Empresa',
			'form' => [
				'to' => 'Para',
				'user_type' => 'Tipo de Usuario',
				'message_type' => 'Tipo de Mensaje',
				'message' => 'Mensaje',
			]
		],
		'manage_emails_page' => [
			'send_email' => 'Enviar Correo Electrónico',
			'send_email_form' => 'Formulario de Envío de Correo Electrónico',
			'notes' => 'Nota: El correo electrónico se enviará solo a usuarios registrados.',
			'email_settings' => 'Configuración de Correo Electrónico',
			'email_settings_form' => 'Formulario de Configuración de Correo Electrónico',
			'form' => [
				'email_to' => 'Correo Electrónico A',
				'email_address' => 'Dirección de Correo Electrónico',
				'subject' => 'Asunto',
				'message' => 'Mensaje (la salutación se añadirá automáticamente)',
				'host' => 'Anfitrión',
				'driver' => 'Controlador',
				'port' => 'Puerto',
				'from_address' => 'Dirección del Remitente',
				'form_name' => 'Nombre del Formulario',
				'encryption' => 'Cifrado',
				'username' => 'Nombre de Usuario',
				'password' => 'Contraseña',
			]
		],
		'manage_manual_booking_page' => [
			'title' => 'Reserva Manual',
			'heading' => 'Despacho de Taxi Manual',
			'select_driver_availability' => 'Seleccionar Disponibilidad del Conductor',
			'map_zoom_level' => 'Nivel de Zoom del Mapa',
			'auto_assign_driver' => 'Asignar Conductor Automáticamente',
			'fare_estimation' => 'Estimación de Tarifa',
			'minimum_fare' => 'Tarifa Mínima',
			'base_fare' => 'Tarifa Base',
			'distance' => 'Distancia',
			'time' => 'Tiempo',
			'minutes' => 'Minutos',
			'peak_price' => 'Precio Pico',
			'total_fare' => 'Tarifa Total',
			'notes' => 'Notas',
			'reason' => 'Razón',
			'manual_auto_booking' => [
				'title' => 'Reserva Automática Manual',
				'point_1' => 'El administrador puede agregar / editar la reserva del viaje más tarde en esta página.',
				'point_2' => 'La disponibilidad actual del conductor no está conectada con la reserva que se está haciendo.',
				'point_3' => 'Agregar una reserva desde aquí no enviará una solicitud al conductor de inmediato.',
				'point_4' => 'En caso de seleccionar la opción "Asignar Conductor Automáticamente", el conductor recibirá una solicitud automática 5 minutos antes de la hora real de la reserva.',
				'point_5' => 'En caso de no seleccionar la opción "Asignar Conductor Automáticamente", el conductor recibirá una confirmación de reserva y un SMS de recordatorio 30 minutos antes de la hora real de la reserva.',
				'point_6' => 'El conductor debe comenzar el viaje programado yendo a "Tu Viaje" >> sección Próximos en la aplicación del conductor.',
				'point_7' => 'En caso de "Asignar Conductor Automáticamente", se seguirá el algoritmo competitivo.'
			],
			'manual_assign_booking' => [
				'title' => 'Asignación Manual de Reserva',
				'point_1' => 'Por favor confirme la disponibilidad futura del conductor antes de hacer la reserva.',
				'point_2' => 'El conductor debe comenzar el viaje programado yendo a "Tu Viaje" >> sección Próximos en la aplicación del conductor.',
			],
			'manage_bookings' => 'Gestionar Reservas',
			'cancel_reason' => 'Razón de Cancelación',
			'booking_cancel' => 'Cancelar Reserva',
			'booking_cancel_reason' => 'Razón de Cancelación de Reserva',
			'cancel_by' => 'Cancelar por',
			'cancelled_by' => 'Cancelado por',
			'cancel' => 'Cancelar',
			'trip_cancelled' => 'Viaje cancelado',
			'immediate_request' => 'Solicitud inmediata',
			'table' => [
				'company_name' => 'Nombre de la empresa',
				'booked_by' => 'Reservado por',
				'date' => 'Fecha',
				'driver_name' => 'Nombre del Conductor',
				'rider_name' => 'Nombre del Pasajero',
				'pickup_location' => 'Ubicación de Recogida',
				'drop_location' => 'Ubicación de Destino',
				'trip_details' => 'Detalles del Viaje',
				'status' => 'Estado',
			]

		],
		'manage_vehicle_make' => [
			'title' => 'Marca de Vehículo',
			'add_vehicle_make' => 'Agregar Marca de Vehículo',
			'form_title' => 'Formulario para Agregar Marca de Vehículo',
			'edit_vehicle_make' => 'Editar Marca de Vehículo',
			'edit_form_title' => 'Formulario para Editar Marca de Vehículo',
			'form' => [
				'status' => 'Estado',
				'make' => 'Marca de Vehículo',
			],
			'table' => [
				'id' => 'Id',
				'status' => 'Estado',
				'make' => 'Marca',
			]
		],
		'manage_vehicle_model' => [
			'title' => 'Modelo de Vehículo',
			'add_vehicle_model' => 'Añadir Modelo de Vehículo',
			'form_title' => 'Formulario de Añadir Modelo de Vehículo',
			'edit_vehicle_model' => 'Editar Modelo de Vehículo',
			'edit_form_title' => 'Formulario de Editar Modelo de Vehículo',
			'table' => [
				'id' => 'ID',
				'make' => 'Marca',
				'model' => 'Modelo',
				'status' => 'Estado',
				'action' => 'Acción',
			],
			'form' => [
				'vehicle_make' => 'Marca del Vehículo',
				'model' => 'Nombre del Modelo del Vehículo',
				'status' => 'Estado',
			]
		],
		'manage_vehicle_type' => [
			'title' => 'Tipos de Vehículos',
			'vehicles' => 'Vehículos',
			'vehicle_types' => 'Tipos de Vehículos',
			'add_vehicle_type' => 'Añadir Tipo de Vehículo',
			'form_title' => 'Formulario de Añadir Tipo de Vehículo',
			'edit_vehicle_type' => 'Editar Tipo de Vehículo',
			'edit_form_title' => 'Formulario de Editar Tipo de Vehículo',
			'table' => [
				'id' => 'ID',
				'vehicle_name' => 'Nombre del Vehículo',
				'description' => 'Descripción',
				'is_pool' => 'Es para Pool',
				'status' => 'Estado',
				'action' => 'Acción',
			],
			'form' => [
				'vehicle_name' => 'Nombre del Vehículo',
				'description' => 'Descripción',
				'vehicle_image' => 'Imagen del Vehículo',
				'vehicle_active_image' => 'Imagen Activa del Vehículo',
				'vehicle_app_icon' => 'Ícono de la App del Vehículo',
				'is_pool' => 'Es para Pool',
				'status' => 'Estado',
			]
		],
		'manage_vehicles' => [
			'title' => 'Gestionar Vehículos',
			'vehicles' => 'Vehículos',
			'add_vehicles' => 'Añadir Vehículos',
			'edit_vehicles' => 'Editar Vehículos',
			'add_vehicle_form' => 'Formulario de Añadir Vehículo',
			'edit_vehicle_form' => 'Formulario de Editar Vehículo',
			'form' => [
				'company_name' => 'Nombre de la Empresa',
				'driver_name' => 'Nombre del Conductor',
				'vehicle_type' => 'Tipo de Vehículo',
				'make' => 'Marca',
				'model' => 'Modelo',
				'status' => 'Estado',
				'default' => 'Predeterminado',
				'handicap_accessibility_available' => 'Accesibilidad para Discapacitados Disponible',
				'child_seat_accessibility_available' => 'Accesibilidad para Asiento de Niño Disponible',
				'request_form' => 'Formulario de Solicitud',
				'vehicle_number' => 'Número de Vehículo',
				'color' => 'Color',
				'year' => 'Año',
				'expire_date' => 'Fecha de Vencimiento',
				'request_form_note' => 'Si el conductor es hombre, se seleccionará automáticamente como ambos.',
				'default_note' => 'Si el conductor tiene solo un vehículo con estado activo, se seleccionará automáticamente como predeterminado.'
			],
			'table' => [
				'id' => 'ID',
				'company_name' => 'Nombre de la Empresa',
				'driver_name' => 'Nombre del Conductor',
				'vehicle_type' => 'Tipo de Vehículo',
				'make' => 'Marca/Modelo',
				'vehicle_number' => 'Número de Vehículo',
				'status' => 'Estado',
				'action' => 'Acción',
			]
		],
		'manage_additional_reasons' => [
			'title' => 'Razones Adicionales',
			'add_additional_reason' => 'Agregar Razón Adicional',
			'edit_additional_reason' => 'Editar Razón Adicional',
			'add_title' => 'Formulario de Agregar Razón Adicional',
			'edit_title' => 'Formulario de Editar Razón Adicional',
			'table' => [
				'id' => 'ID',
				'reason' => 'Razón',
				'status' => 'Estado',
				'action' => 'Acción'
			],
			'form' => [
				'reason' => 'Razón',
				'status' => 'Estado'
			]
		],
		'cancel_reasons' => [
			'title' => 'Razón de Cancelación',
			'add_cancel_reason' => 'Agregar Razón de Cancelación',
			'edit_cancel_reason' => 'Editar Razón de Cancelación',
			'add_title' => 'Formulario de Agregar Razón de Cancelación',
			'edit_title' => 'Formulario de Editar Razón de Cancelación',
			'translations' => 'Traducciones',
			'remove' => 'Eliminar',
			'add_translations' => 'Agregar Traducciones',
			'table' => [
				'id' => 'ID',
				'reason' => 'Razón',
				'cancelled_by' => 'Cancelado por',
				'status' => 'Estado',
				'action' => 'Acción',
			],
			'form' => [
				'language' => 'Idioma',
				'reason' => 'Razón',
				'cancelled_by' => 'Cancelado por',
				'status' => 'Estado'
			]
		],
		'locations' => [
			'title' => 'Ubicaciones',
			'add_location' => 'Agregar Ubicación',
			'edit_location' => 'Editar Ubicación',
			'add_title' => 'Formulario de Agregar Ubicación',
			'edit_title' => 'Formulario de Editar Ubicación',
			'table' => [
				'id' => 'ID',
				'location_name' => 'Nombre de la Ubicación',
				'status' => 'Estado',
				'action' => 'Acción'
			],
			'form' => [
				'name' => 'Nombre',
				'status' => 'Estado'
			]
		],
		'manage_fares' => [
			'title' => 'Gestionar Tarifas',
			'add_manage_fare' => 'Agregar Tarifa',
			'edit_manage_fare' => 'Editar Tarifa',
			'add_title' => 'Formulario de Agregar Tarifa',
			'edit_title' => 'Formulario de Editar Tarifa',
			'peak_fare_details' => 'Detalles de Tarifa en Hora Pico',
			'night_fare_details' => 'Detalles de Tarifa Nocturna',
			'table' => [
				'id' => 'ID',
				'location_name' => 'Nombre de la Ubicación',
				'vehicle_type' => 'Tipo de Vehículo',
				'apply_peak' => 'Aplicar Hora Pico',
				'apply_night' => 'Aplicar Noche',
				'action' => 'Acción',
			],
			'form' => [
				'location' => 'Ubicación',
				'vehicle_type' => 'Tipo de Vehículo',
				'base_fare' => 'Tarifa Base',
				'capacity' => 'Capacidad',
				'minimum_fare' => 'Tarifa Mínima',
				'per_minutes' => 'Por Minuto',
				'per_kilometer' => 'Por Kilómetro',
				'waiting_time_limit' => 'Límite de Tiempo de Espera (En Minutos)',
				'waiting_charges' => 'Cargos por Espera (Por Minuto)',
				'schedule_ride_fare' => 'Tarifa de Viaje Programado',
				'currency_code' => 'Código de Moneda',
				'apply_peak_fare' => 'Aplicar Tarifa en Hora Pico',
				'apply_night_fare' => 'Aplicar Tarifa Nocturna',
				'day' => 'Día',
				'start_time' => 'Hora de Inicio',
				'end_time' => 'Hora de Fin',
				'peak_fare' => 'Tarifa en Hora Pico',
				'night_fare' => 'Tarifa Nocturna'
			]
		],
		'manage_trip' => [
			'manage_ride_requests' => 'Gestionar Solicitudes de Viaje',
			'ride_requests' => 'Solicitudes de Viaje',
			'manage_trips' => 'Gestionar Viajes',
			'trips' => 'Viajes',
			'request_details' => [
				'request_status' => '¡Conductor aún no asignado!',
				'vehicle_type' => 'Tipo de Vehículo',
				'rider_name' => 'Nombre del Pasajero',
				'driver_name' => 'Nombre del Conductor',
				'company_name' => 'Nombre de la Empresa',
				'pickup_address' => 'Dirección de Recogida',
				'drop_address' => 'Dirección de Destino',
				'ride_start_time' => 'Hora de Inicio del Viaje',
				'ride_end_time' => 'Hora de Fin del Viaje',
				'ride_status' => 'Estado del Viaje'
			],
			'table' => [
				'id' => 'ID',
				'request_id' => 'ID de Solicitud',
				'rider_name' => 'Nombre del Pasajero',
				'driver_name' => 'Nombre del Conductor',
				'earned' => 'Ganado',
				'pickup_location' => 'Ubicación de Recogida',
				'drop_location' => 'Ubicación de Destino',
				'date_and_time' => 'Fecha y Hora',
				'status' => 'Estado',
				'amount' => 'Monto',
				'trip_date' => 'Fecha del Viaje',
				'company_name' => 'Nombre de la Empresa',
				'vehicle_details' => 'Detalles del Vehículo',
				'payment_mode' => 'Modo de Pago',
				'payment_status' => 'Estado de Pago',
				'action' => 'Acción',
				'reason' => 'Razón',
				'comments' => 'Comentarios',
				'cancelled_by' => 'Cancelado Por',
				'cancel_at' => 'Cancelado En',
				'time_fare' => 'Tarifa por Tiempo',
				'distance_fare' => 'Tarifa por Distancia',
				'base_fare' => 'Tarifa Base',
				'is_pool' => 'Monto del Segundo Pasajero (Compartido)',
				'tips' => 'Propinas',
				'additional_fee' => 'Tarifa Adicional',
				'access_fee' => 'Tarifa de Acceso',
				'admin_commission' => 'Comisión Administrativa',
				'total_fare' => 'Tarifa Total',
				'earnings' => 'Ganancias',
				'car_name' => 'Nombre del Coche',
				'trip_number' => 'Número de Viaje',
				'driver_rating' => 'Calificación del Conductor',
				'rider_rating' => 'Calificación del Pasajero',
				'rider_comments' => 'Comentarios del Pasajero',
				'driver_comments' => 'Comentarios del Conductor',
			]
		],
		'manage_owe_amounts' => [
			'title' => 'Gestionar Cantidad Adeudada',
			'owe_amount' => 'Cantidad Adeudada',
			'table' => [
				'id' => 'Id',
				'company_id' => 'ID de la Empresa',
				'company_name' => 'Nombre de la Empresa',
				'trip_ids' => 'IDs de Viajes',
				'owe_amount' => 'Cantidad Adeudada',
				'remaining_owe_amount' => 'Cantidad Adeudada Restante',
				'action' => 'Acción',
				'driver_id' => 'ID del Conductor',
				'driver_name' => 'Nombre del Conductor',
			]
		]




	],
	'home' => [
		'title' => 'Ir allí',
		'desc' => 'Ingrese a la ubicación de recogida y entrega y disfrute del viaje a un precio asequible',
		'drivedesc' => 'Empiece a conducir con :site_name, con recompensas y ganancias exclusivas. Conveniente en su máxima expresión.',
		'drive_you1' => 'Reserve para su taxi inmediato',
		'goals1' => 'Independientemente del horario, el usuario puede reservar su viaje en el tipo de cabina conveniente, ya sea SUV, sedán u otros para comenzar su viaje en la puerta. ',
		'siginup' => 'Regístrate',
		'or' => 'O',
		'siginup_drive' => 'Regístrese para conducir',
		'siginup_company' => 'Regístrese para la empresa',
		'company' => 'Empresa',
		'company_history' => 'Encuentra todo lo necesario para realizar un seguimiento de su éxito en la empresa',
		'company_signin' => 'signo en',
		'company_signup' => 'La compañía se inscribe',
		'become_company' => 'Convertirse en una empresa',
		'rider_acnt' => 'con su cuenta de jinete.',
		'aggrement' => 'Al continuar, acepto que',
		'easy_way' => 'La manera más fácil alrededor',
		'easy_content' => 'Un toque, un coche pasa directamente a usted. Hop en-su conductor sabe exactamente a dónde ir. Y cuando llegue allí, sólo tienes que salir. El pago es completamente transparente.',
		'anywhere' => 'En cualquier lugar en cualquier momento',
		'anywhere_content' => 'viajes diarios. Mandado por toda la ciudad. vuelo por la mañana. bebidas por la noche. Siempre que te diriges, contar con {{}} $ nombre_del_sitio para un paseo-No se requiere reservación.',
		'lowcost' => 'Bajo costo al lujo',
		'lowcost_content' => 'coches económicos a precios de todos los días están siempre disponibles. Para las ocasiones especiales, ninguna ocasión en absoluto, o cuando simplemente una necesidad de un poco más de espacio, llamar a un coche negro o SUV.',
		'reason' => 'Razones para montar',
		'drive_you' => 'Conducir cuando se desea',
		'you_need' => 'Haga lo que necesita',
		'drive_with' => 'conducir con',
		'goals' => 'es flexible y gratificante, ayudando a los conductores cumplen con su carrera y metas financieras.',
		'suprt' => 'El apoyo a los conductores afectados por la prohibición de la inmigración',
		'provide' => 'Estamos proporcionando acceso a apoyo legal 24/7 para los conductores afectados por la prohibición y la asistencia financiera para los conductores varados en el extranjero.',
		'now_arrive' => 'ahora llegar',
		'safe' => 'ciudades seguras y modernas',
		'helping' => 'ciudades que ayudan a prosperar',
		'city_with' => 'Una ciudad con',
		'city_with_content' => 'da a la gente más formas de ganar dinero, tiene un menor número de conductores ebrios en la carretera, y proporciona el transporte en cualquier lugar, en cualquier momento.',
		'safe_ride' => 'paseos seguro para todos',
		'backseat' => 'Ya sea a caballo en el asiento trasero o conducir desde el principio, todas las partes del',
		'designed' => 'experiencia está diseñado en torno a su seguridad y la seguridad.',
		'fare' => 'estimador de tarifas',
		'how_much' => '¿Cuánto cuesta',
		'cost' => 'costará en su ciudad? Calcular una estimación de tarifas para su próximo viaje. Basta con entrar en un lugar de recogida y destino para empezar.',
		'get_started' => 'Empezar',
		'invalid_mobile_no' => 'Numero de celular invalido. Inténtalo de nuevo.',
		'field_is_required' => 'es requerido.',
	],

	'footer' => [
		'siginup_ride' => 'Registra para montar',
		'driver' => 'Convertirse en un conductor',
		'ride' => 'Paseo',
		'drive' => 'Conducir',
		'rider_app' => 'Aplicación de jinete',
		'driver_app' => 'Aplicación de controlador',
		'safety' => 'La seguridad',
		'using_cookies' => 'Cookies: :site_name sitio utiliza cookies para mejorar la experiencia del usuario. Mediante el uso de nuestra página web usted acepta nuestras cookies de acuerdo con nuestra',
	],
	'help' => [
		'welcome'            => '¡Bienvenido! ¿Cómo podemos ayudar?',
		'search_anything'    => 'Búsqueda de nada',
		'help_center'        => 'Centro de ayuda',
		'suggested_helps'    => 'Ayuda sugerido Lista',
		'no_suggested_helps' => 'Sin sugerido Ayuda!',
		'no_results_found'   => 'No se han encontrado resultados',
		'back'               => 'Espalda',
	],
	'header' => [
		'help'                     => 'Ayuda',
		'profile' => 'Tu perfil',
		'profil' => 'Perfil',
		'credit_card' => 'Añadir la tarjeta de crédito',
		'verify_email' => 'verificar correo electrónico',
		'mytrips' => 'Mis viajes',
		'payment' => 'Pago',
		'logout' => 'Cerrar sesión',
		'invoice' => 'Factura',
		'signin' => 'Registrarse',
		'location' => 'Kochi',
		'use_location' => 'Utilizamos su ubicación para personalizar la información que desea ver.',
		'chng_location' => 'CAMBIAR LOCACIÓN',
		'back' => 'Espalda',
		'require' => 'requisitos',
		'app' => 'controlador de la Aplicación',
		'area' => 'No en Kochi? Por favor, introduzca su ubicación para ayudarnos a mostrar la información correcta para su área.',
		'how_it_works' => 'Cómo funciona',
		'menu' => 'Menú',
	],
	'dashboard' => [
		'trip_invoice' => 'Las facturas del viaje en coche',
		'invoice_no' => 'Número de factura',
		'trip_date' => 'Fecha de viaje',
		'invoice' => 'Factura',
		'invoice_issued' => 'Factura emitida por',
		'behalf' => 'a nombre de:',
		'date' => 'Fecha',
		'desc' => 'Descripción',
		'net_amt' => 'Importe neto',
		'payment_mode' => 'Modo de pago',
		'base_fare' => 'Tarifa base',
		'distance_fare' => 'distancia Fare',
		'time_fare' => 'Fare tiempo',
		'total_fare' => 'Tarifa total de viaje',
		'admin_amt' => 'Monto admin',
		'owe_amt' => 'Owe Cantidad',
		'driver_payout' => 'Pago controlador',
		'cash_collect' => 'efectivo cobrado',
		'total_payout' => 'Pago total',
		'access_fee' => 'Tarifa de acceso',
		'wallet_amt' => 'Monto Monedero',
		'promo_amt' => 'Cantidad de Promoción',
		'paid_amt' => 'Monto de pago',
		'payment_methods' => 'Métodos de pago',
		'personal_cash' => 'efectivo personal',
		'personal_paytm' => 'Paytm personales',
		'promotions' => 'promociones',
		'apply' => 'Aplicar',
		'no_active' => 'No hay promociones activas',
		'gratuity' => 'Propina para TAXI',
		'preferred' => 'Su propina preferido se aplicará a cualquier futuros viajes de taxi que usted solicite a través',
		'taxi' => 'Esto se aplicará a los gastos de taxi (no Negro, SUV, o',
		'paid' => 'y se pagará a su conductor. La gratuidad sólo se aplica en algunos países.',
		'taxi_gratuity' => 'La gratuidad TAXI',
		'save' => 'Salvar',
		'dwnld_invoice' => 'Descargar facturas de viajes realizados por usted y sus conductores. Tenga en cuenta que las tarifas están sujetas a ajustes por',
		'feedback' => 'basado en la retroalimentación del cliente. Sus facturas reflejarán esos ajustes.',
		'download' => 'Descargar',
		'print' => 'Impresión',
		'pdf' => 'PDF',
		'no_details' => 'No hay detalles encontrados',
		'schedule_fare' => 'Fare horario',
		'peak_fare' => 'Fare pico',
		'upload_file' => 'subido',

	],
	'profile' => [
		'general' => 'Información general',
		'location' => 'Ubicación',
		'mobile' => 'Móvil',
		'email' => 'Dirección de correo electrónico',
		'profile_photo' => 'Foto de perfil',
		'filter' => 'Viajes de filtro',
		'timeframe' => 'Periodo de tiempo',
		'pickup' => 'Recoger',
		'driver' => 'Conductor',
		'rider' => 'Jinete',
		'fare' => 'Tarifa',
		'car' => 'Coche',
		'view_detail' => 'Ver Detalle',
		'your_trip' => 'Tu viaje',
		'dwnld_invoice' => 'Descargar factura',
		'kilometer' => 'kilómetros',
		'trip_time' => 'Hora de viajar',
		'rode_with' => 'Con Rode',
		'phone' => 'Teléfono',
		'addr' => 'Dirección',
		'profile_city' => 'Ciudad',
		'country' => 'País',
		'profile_postal_code' => 'Código postal',
		'fare_break' => 'DESGLOSE FARE',
		'you_rode' => 'Usted montó con',
		'track_every' => 'Encuentra todo lo necesario para el seguimiento de su éxito en el camino.',
		'driver_signin' => 'signo conductor en',
		'driver_signup' => 'Conductor se inscribe',
		'trip_history' => 'Administrar las opciones de pago, revisar el historial de viaje, y mucho más.',
		'rider_signin' => 'señal piloto en',
		'rider_signup' => 'Piloto inscribirse',
		'name' => 'Nombre',
		'gender' 		=> 'Género',
		'male' 			=> 'Masculino',
		'female' 		=> 'Hembra',
		'phone_number' 	=> 'Número de teléfono',
		'change'		=> 'Cambio',
	],

	'drive' => [
		'start_drive_with' => 'Empezar a conducir con',
		'works_first' => 'Trabajo que pone en primer lugar',
		'drive_you_need' => 'Conducir cuando se quiere, gana lo que necesita',
		'own_schedule' => 'Fijar su propio horario',
		'drive_with' => 'Se puede conducir con',
		'anytime' => 'en cualquier momento, de día o de noche, los 365 días del año. Cuando maneja es siempre de usted, por lo que nunca interfiere con las cosas importantes de su vida.',
		'every_turn' => 'Ganar más en cada vuelta',
		'fare_start' => 'tarifas de ida y comienzan con una cantidad base, entonces aumentan con el tiempo y la distancia. Y cuando la demanda es superior a la normal, los conductores ganan más.',
		'app_lead' => 'Deje que la aplicación abrir el camino',
		'tap_go' => 'Sólo tienes que pulsar y listo. Usted obtendrá giro a su vez, las direcciones, las herramientas para ayudarle a ganar más, y soporte 24/7. Y si usted no tiene un teléfono inteligente, podemos conectar a uno.',
		'hit_road' => 'Golpear la carretera',
		'easy_started' => 'Es fácil empezar',
		'sign_online' => 'Inscribirse en línea',
		'about_yourself' => 'Cuéntanos un poco sobre usted y su coche. requisitos del vehículo varían según la región, por lo que voy a mostrar lo que se necesita para su ciudad.',
		'share_doc' => 'Compartir algunos documentos',
		'upload_license' => 'Sólo tienes que subir su licencia, registro, comprobante de seguro, y la información necesaria para iniciar una proyección conductor.',
		'get_app' => 'Descarga la aplicación y vaya',
		'approve_drive' => 'Una vez que esté aprobado para conducir con',
		'provide_you_need' => 'como contratista independiente, vamos a proporcionar todo lo necesario para ser un éxito en el camino.',
		'signup_now' => 'REGÍSTRATE AHORA',
		'about_app' => 'Acerca de la aplicación',
		'design_drivers' => 'Diseñado sólo para los conductores',
		'make_money' => 'Cuando se quiere hacer dinero, basta con abrir la aplicación y usted comenzará a recibir solicitudes de viaje. Usted obtendrá información sobre su jinete y direcciones a su ubicación y destino. Cuando el viaje ha terminado, recibirá otra solicitud cercano. Y si re listo para salir de la carretera, se puede firmar en cualquier momento.',
		'safety_screen' => 'Sabe que está listo para salir a la carretera. Ya sea que usted está conduciendo su propio coche o un vehículo comercial con licencia, debe cumplir con los requisitos mínimos y completar un tamizado de seguridad en línea.',
		'rewards' => 'recompensas',
		'drive_seat' => 'Usted está en el asiento del conductor. Así recompensa con descuentos en combustible, mantenimiento de vehículos, facturas de teléfono celular, y más. Reducir sus gastos diarios y llevar a casa los ingresos adicionales por la conducción más.',
		'vehicle_solution' => 'equipamiento para vehículos',
		'need_car' => '¿Necesita un coche? Podemos conectarlo a los socios que ofrecen ofertas de vehículos exclusivos que se puede obtener en la carretera y de ingresos. Muchos ofrecen sin tapas kilometraje y las políticas de devolución flexible para que pueda conducir y ganar tanto como desee.',
		'you_with' => 'Cuando se conduce con',
		'support' => 'obtiene el apoyo y el seguro de cobertura 24/7 conductor. Y todos los pilotos se verifican con sus datos personales y número de teléfono, para que sepa quién está recogiendo y así nosotros también.',
		'making_money' => 'Empezar a ganar dinero',
		'ready_money' => 'Listo para ganar dinero? El primer paso es registrarse en línea.',
		'support' => 'El apoyo a cada paso',
		'we_want' => 'Queremos que cada',
		'hassle_free' => 'viaje sea sin problemas. Así que estamos aquí para ayudar con la configuración de la cuenta, los ajustes de tarifas, y más cuando lo necesite.',
		'safety_behind' => 'Seguridad al volante',
		'out_commitment' => 'Nuestro compromiso con los conductores',
		'keeping_safe' => 'se dedica a mantener a salvo en la carretera. Nuestra tecnología nos permite centrarse en la seguridad del conductor antes, durante y después de cada viaje.',
		'before_trip' => 'Antes del viaje',
		'picking_up' => 'Recoger pasajeros',
		'anonymous_pickup' => 'No se hacen recogidas anónimos',
		'riders_account' => 'Todos los corredores deben crear una cuenta y proporcionar su nombre, dirección de correo electrónico y número de teléfono antes de que puedan solicitar un paseo. Así que cuando se acepta una solicitud, usted sabrá que usted está recogiendo y así te.',
		'sub_number' => 'números de teléfono sustitutos',
		'location_around_world' => 'En muchos lugares del mundo,',
		'stays_private' => 'que utiliza la tecnología anonimiza números de teléfono para mantener la información de contacto confidencial. Así que cuando usted y su piloto necesita ponerse en contacto entre sí, su información personal se mantiene privada.',
		'on_trip' => 'De viaje',
		'getting_destination' => 'Llegar al destino',
		'app_navigation' => 'Dentro de la aplicación de navegación',
		'riders_enter' => 'Cuando los pilotos entran en su destino, automáticamente recibirá instrucciones paso a paso en la aplicación, para que pueda centrarse en conseguir allí con seguridad.',
		'on_the_map' => 'Siempre en el mapa',
		'gps_data' => 'los datos GPS se registra para cada viaje, así que sabemos que usted está conduciendo y donde vas, que promueve la responsabilidad y fomenta el buen comportamiento.',
		'after_trip' => 'Después del viaje',
		'improving' => 'Siempre la mejora de la',
		'experience' => 'experiencia',
		'no_change' => 'Sin cambios, sin complicaciones',
		'fares_atuo' => 'Tarifas cargan automáticamente método de pago del ciclista en el archivo, por lo que para la mayoría de los viajes se puede evitar el uso de dinero en efectivo por completo. Pero si un pasajero paga en efectivo, la aplicación emite automáticamente el crédito por lo que nunca tendrá que hacer el cambio.',
		'driver_feedback' => 'la respuesta del conductor',
		'rate_your_driver' => 'Valora su piloto después de cada viaje. Se revisan las calificaciones para asegurar que todo el mundo se levanta es tan respetuoso como eres. Jinetes reportados para violar nuestros términos de servicio pueden ser impedidos de usar',
		'drive_safely' => 'Conduce con seguridad con',
		'information' => 'La información proporcionada en esta página web tiene carácter meramente informativo y puede no ser aplicable en su país, región o ciudad. Está sujeto a cambios y puede ser actualizada sin previo aviso.',
		'drivers_first' => 'Poner los conductores primero',
		'exp_around' => 'Una experiencia construida a su alrededor',
		'control_with' => 'Usted tiene el control con',
		'app_for_drivers' => 'La aplicación de los conductores está diseñado con características que le ayudan a decidir cómo, dónde y cuando se gana.',
		'going_online' => 'El ir en línea',
		'always_avail' => 'está siempre disponible. Así que cuando usted está listo para conducir, abrir la aplicación y pulse Ir en línea.',
		'accept_trip_request' => 'La aceptación de solicitudes de viaje',
		'receive_trip_request' => 'Una vez en línea, usted comenzará automáticamente a recibir solicitudes de viaje en su área. El teléfono emitirá un pitido y la pantalla parpadeará veces para aceptar.',
		'turn_by_turn' => 'Paso a paso las direcciones',
		'provides_navigation' => 'La aplicación proporciona la navegación a su lugar de recogida del jinete, y vamos a hacerles saber cuando estás casi allí. Una vez comenzado el viaje, podrás obtener indicaciones para llegar a su destino.',
		'track_earnings' => 'El seguimiento de sus ganancias',
		'summaries' => 'Después de cada viaje, podrás ver exactamente cuánto ganó y resúmenes completos del total de su día. Las ganancias se transfieren automáticamente a su cuenta bancaria cada semana, o se pueden retirar inmediatamente hasta 5 veces al día.',
		'rating' => 'sistema de clasificación',
		'rider_driver_rate' => 'Las calificaciones son una calle de dos vías. Pilotos valoran entre sí después de cada viaje para asegurar que, gente amable única respetuosas son permitidos en el',
		'platform' => 'plataforma.',
		'communication' => 'Comunicación',
		'feedback_success' => 'Comentarios para el éxito',
		'stay_informed' => 'Mantente informado',
		'customized_updates' => 'Recibe actualizaciones personalizadas sobre eventos locales y promociones en tu ciudad, y consejos sobre cómo ofrecer la mejor',
		'rider_comment' => 'Rider comentarios',
		'rating_section' => 'Utilice la sección de calificaciones para escuchar lo que la gente gusta de sus viajes de 5 estrellas y descubrir por qué los pilotos dan bajos niveles de audiencia para que pueda decidir cómo ajustar en consecuencia.',
		'start_drive_now' => 'Empezar a conducir ahora',
		'start_drive_nowive' => 'conducir con',
		'earn_your_terms' => 'y ganar en sus propios términos.',
		'already_signed_up' => 'Ya se inscribió?',
		'invite_friends' => 'Invita a tus amigos a probar',
		'you_earn' => 'y usted ganará extra cuando se ponen en camino.',
		'info_page' => 'La información proporcionada en esta página web tiene carácter meramente informativo y puede no ser aplicable en su país, región o ciudad. Está sujeto a cambios y puede ser actualizada sin previo aviso.',
		'driver_requirments' => 'requisitos de controlador',
		'how_to_drive' => 'Cómo conducir con',
		'own_boss' => 'es una gran manera de ser su propio jefe y ganar mucho dinero. De uso comercial a un coche,',
		'help_you_every' => 'le puede ayudar a cada paso del camino.',
		'min_requirments' => 'Requerimientos mínimos',
		'commercial_license' => 'Para conducir en la ciudad de Nueva York, tendrá uso comercial de la ciudad de Nueva York TLC (Comisión de Taxis y Limosinas) y un vehículo con licencia comercial.',
		'help_you_both' => 'le puede ayudar con ambos.',
		'what_you_need' => 'Esto es lo que se necesita:',
		'driver_license' => 'Una licencia de conducir válida de los EE.UU.',
		'tlc_license' => 'Una licencia de conducir TLC',
		'tlc_license_vehicle' => 'Un vehículo con licencia de TLC (se puede alquilar uno o registrar su propia)',
		'require_documents' => 'Documentos requeridos',
		'addition_documents' => 'Además de los requisitos anteriores, también necesitará la siguiente documentación:',
		'proof_insurance' => 'Prueba de seguro comercial',
		'proof_vehicle_registration' => 'Prueba de registro de vehículos comerciales',
		'vehicle_permit' => 'Una TLC a sueldo permiso de vehículo',
		'ready_make_money' => 'Listo para ganar dinero?',
		'first_step' => 'El primer paso es registrarse',
	],

	'driver_dashboard' => [
		'add_vehicle' => 'Añadir Vehículo',
		'make' => 'Hacer',
		'model' => 'Modelo',
		'year' => 'Año',
		'license_plate' => 'Placa',
		'reupload' => 'DOCUMENTOS volver a subir',
		'make_year' => '2015',
		'make_company' => 'Tata',
		'make_product' => 'Indica',
		'reg_no' => 'TN22DA0103',
		'type' => 'VIN',
		'upload_documents' => 'Sube documentos: licencia de conducir  \ - (Volver / hacia atrás)',
		'select_file' => 'ARCHIVO seleccionar y cargar',
		'contract_carriage' => 'Cargar documento: Contrato de Permiso de carro',
		'back_profile' => 'Volver al Perfil',
		'driver_license_back' => 'Driver  de licencia - (Volver / hacia atrás)',
		'upload' => 'Subir',
		'driver_license_front' => 'Driver  de licencia - (frontal)',
		'motor_insurance' => 'Certificado de seguro de vehículos automóviles',
		'reg_certificate' => 'Certificado de registro',
		'carriage_permit' => 'Permiso carro contrato',
		'upload_driver_license' => 'Sube documentos: licencia de conducir  \ - (Volver / hacia atrás)',
		'banking_details' => 'Datos bancarios Cuenta',
		'payment_details' => 'Pagos Los detalles se invaild',
		'weekly_payout' => 'Permite recibir pagos semanales',
		'ifsc' => 'Código IFSC',
		'ifsc_code' => 'KVBL00016',
		'bank' => 'Nombre del banco',
		'bank_name' => 'KARUR VYSYA BANCO',
		'account' => 'Número de cuenta bancaria',
		'account_no' => 'xxxxxxxxxxxx40',
		'account_name' => 'Nombre del titular de la cuenta (tal y como se ve en su estado de cuenta)',
		'driver_address' => 'Dirección',
		'address' => 'kk Nagar',
		'driver_city' => 'Ciudad',
		'city' => 'Chennai',
		'driver_postal_code' => 'Código postal',
		'postal_code' => '600078',
		'driver_dob' => 'Fecha de nacimiento',
		'dob' => '06/10/2015',
		'under_req_age' => 'Bajo edad requerida',
		'download_invoice_driver' => 'Descargar facturas de viajes realizados por usted y sus conductores. Tenga en cuenta que las tarifas están sujetas a ajustes por  nombre_del_sitio basado en la retroalimentación del cliente. Sus facturas reflejarán esos ajustes.',
		'client_feedback' => 'basado en la retroalimentación del cliente. Sus facturas reflejarán esos ajustes.',
		'total_earnings' => 'Ganancias Totales',
		'pay_period' => 'PERÍODO DE PAGO',
		'current_statement' => 'Estado de cuenta actual',
		'all_statement' => 'Ver todos Declaración',
		'completed_trips' => 'Viajes completadas',
		'acceptance_rate' => 'Nivel de aceptación',
		'cancelled_trips' => 'viajes cancelados',
		'daily_earnings' => 'Las ganancias diarias',
		'status' => 'Estado',
		'all_trips' => 'todos los viajes',
		'pickup_time' => 'Hora de recogida',
		'vehicle' => 'Vehículo',
		'duration' => 'Duración',
		'distance' => 'La distancia (km)',
		'add_photo' => 'Añadir foto',
		'manage_documents' => 'administrar documentos',
		'driver_documents' => 'Documentos del conductor',
		'vehicle_documents' => 'Documentos del vehiculo',
		'select_upload' => 'Seleccionar archivo y subir',
		'Active' 			=> 'Activo',
		'Inactive'			=> 'Inactivo',
		'Pending'			=> 'Pendiente',
		'Car_details'		=> 'Detalles del coche',
		'Document_details'	=> 'Detalles del documento',

		'edit' => 'Editar',
		'set_as_default' => 'Establecer por defecto',
		'delete' => 'Eliminar',
		'vehicle_details' => 'Detalles del vehículo',
		'vehicle_make' => 'Marca del vehículo',
		'vehicle_model' => 'Modelo de vehículo',
		'vehicle_number' => 'Número de vehículo',
		'vehicle_color' => 'Color del vehículo',
		'vehicle_year' => 'Año del vehículo',
		'vehicle_type' => 'tipo de vehiculo',
		'default_vehicle_inactive_error' => 'El vehículo seleccionado está inactivo. Entonces no puedes configurar el vehículo predeterminado',
		'default_vehicle_intrip_error' => 'El vehículo predeterminado ya está en viaje, por lo que no puede configurar este vehículo como predeterminado',
		'default_success_msg' => 'El vehículo predeterminado se ha actualizado correctamente',
		'select' => 'Seleccione',

		'handicap' => 'Desventaja',
		'child_seat' => 'Asiento para niños',
		'request_from' => 'Solicitud de',
		'both' => 'Ambos',
		'yes' => 'si',
		'no' => 'No',
		'available' => 'Disponible',
	],
	'errors' => [
		'unauthorize' => 'acción no autorizada.',
		'content_block' => 'La página que busca no se encuentra.',
		'oops' => '¡Huy!',
		'cannot_find' => 'Podemos  parecen encontrar la página que  buscando.',
		'be_right_back' => 'Vuelvo enseguida',
	],
	'ride' => [
		'ride_with_Ridein' => 'Empezar a montar con :site_name',
		'how_works' => '¿Cómo funciona :site_name',
		'request' => 'Solicitud',
		'request_content' => 'Toque en cada opción de envío para ver el tiempo de espera, tamaños y precios. Optó por una tarifa plana de $ 30 Pick up camión, $ 40 Camión de cama plana, $ 50 la caja del camión en su condado. A continuación, introduzca el lugar de recogida y toque de peticiones y su conductor llegará en cuestión de minutos.',
		'delivery' => 'entrega',
		'delivery_content' => 'Su conductor viene a ti. Verá información de contacto y detalles de vehículos de conducir en la aplicación, por lo que sabe que está recibiendo en el coche adecuado.',
		'pay_go' => 'Pagar e ir',
		'pay_go_content' => 'Hop y evaluar su conductor cuando llegue a su destino. Se cobrará automáticamente la tarjeta de crédito registrada, por lo que nunca necesitamos dinero en efectivo.',
		'faq' => 'Preguntas frecuentes',
		'what_expect' => 'Qué esperar en el camino',
		'make_reserve' => '¿Puedo hacer una reserva?',
		'make_reserve_content' => 'servicio a la carta está disponible en todas las ciudades que operamos. Cuando esté listo para montar, utilizar la aplicación para solicitar la recolección de un conductor cercano. La demanda de paseos puede fluctuar en diferentes momentos del día y de la noche. Un gran demanda de paseos en un momento determinado puede afectar la rapidez con un piloto acepta la solicitud de viaje y se dirige a su lugar de recogida. Si estás en una agenda muy apretada, se recomienda la comprobación de ETA de la ubicación de su recogida para diferentes opciones de vehículos aproximadamente 15-30 minutos antes de que esté listo para montar. :site_name en algunas ciudades ahora incluye la opción de programar un viaje :site_nameX. Así es cómo :site_name',
		'schedule_ride' => 'Toque el botón programar un viaje sobre el deslizador opción de vehículo.',
		'select_date' => 'Seleccione una fecha y ventanas preferido de 15 minutos de tiempo cuando va a estar listo para ser recogido.',
		'select_pickup_location' => 'Introduzca su lugar de recogida y de destino.',
		'review_fare' => 'Revisar su estimación de precio y el horario del grifo.',
		'after_confirm' => 'Toque TRIP PROGRAMA confirmar. Después de confirmar, seleccione viajes desde el menú de la aplicación, a continuación, seleccione PRÓXIMA para revisar los próximos viajes programados o programar un nuevo viaje. Si necesita cancelar un viaje programado, pulse CANCELAR. Cuando la fecha y hora en que programan un viaje para la aproximación, los conductores cercanos recibirán su solicitud paseo. El conductor que acepta esta solicitud viaje puede llegar a su lugar de recogida en cualquier momento dentro de su ventana de 15 minutos. Recomendamos estar listo y disponible para su recogida para toda la duración de tiempo. Un conductor que no se puede localizar en el lugar de recogida puede cancelar el viaje después de 5 minutos. Tenga en cuenta que los precios de descargas puede aplicar a un viaje programado. Esto puede afectar a su viaje de ida. Echa un vistazo al siguiente enlace para ver donde está disponible cerca de paseos programados.',
		'do_i_need' => '¿Es necesario que la punta?',
		'do_i_need_content' => 'La aplicación SITE_NAME no puede incluir una punta cuando la facturación para un viaje de ida. Donde esté disponible como una opción de vehículo, SITE_NAME es una excepción. En la mayoría de ciudades, SITE_NAME es una experiencia sin dinero en efectivo. La propina es voluntaria. Las propinas no están incluidas en la tarifa, tampoco se espera o se requiere. Como jinete, usted no está obligado a ofrecer a su conductor una propina en efectivo. Si usted decide que le gustaría a la punta, su conductor es bienvenido a aceptar.',
		'cancel_request' => 'Cancelación de mi solicitud',
		'cancel_request_content' => 'solicitudes de viaje deben hacerse sólo cuando esté listo para montar y cerca del lugar de recogida. Esto permite a los conductores para operar de manera eficiente en la plataforma SITE_NAME. A veces es posible que desee cancelar una solicitud de paseo después de que ha sido aceptada por un conductor. Mientras que la aplicación SITE_NAME le permite cancelar en cualquier momento, una tasa de cancelación puede ser cargado. Esta comisión tiene como objetivo compensar conductores-socios por el tiempo y esfuerzo dedicado en dirección a un lugar de recogida. Una solicitud paseo puede ser cancelada de forma gratuita después de que su solicitud inicial. Si el controlador está funcionando más de 5 minutos detrás del proporcionado ETA, se puede cancelar la solicitud de paseo sin incurrir en un cargo por cancelación. En los viajes SITE_NAMEP, se le puede cobrar una cuota de cancelación de $ 2 si se cancela cada vez que un piloto acepta la solicitud de paseo. Me cobraron una tasa de cancelación. Estamos encantados de revisar y hacer ajustes según sea necesario.',
		'start_riding' => 'empezar a montar',
		'start_riding_content' => 'Tienes lugares para estar. Dejar las llaves en casa y solicitar un paseo.',
		'already_have_account' => '¿Ya tienes una cuenta?',
		'invite' => 'Invita a tus amigos a dar una vuelta :site_name.',
		'always_ride' => 'Siempre el viaje que desea',
		'get_whatever' => 'La mejor manera de llegar a donde vas',
		'tap_button' => 'Toque un botón, conseguir un paseo',
		'tap_button_content' => 'Elija su paseo y establecer su ubicación. Usted verá de conducir vehículos de imagen y datos, y hacer un seguimiento de su llegada en el mapa.',
		'always_on' => 'Siempre encendido, siempre disponible',
		'always_on_content' => 'No hay llamadas telefónicas para hacer, no hay pick-ups para programar. Con disponibilidad 24/7, solicitar un viaje en cualquier momento del día, cualquier día del año.',
		'we_listen' => 'Califica, escuchamos',
		'we_listen_content' => 'Valorar su conductor y proporcionar información anónima sobre su viaje. Su aportación nos ayuda a tomar cada salida una experiencia de 5 estrellas.',
		'every_price' => 'Hay un paseo para cada precio',
		'any_occasion' => 'Y cualquier ocasión',
		'economy' => 'Economía',
		'premium' => 'Prima',
		'accessibility' => 'Accesibilidad',
		'start_finish' => 'De principio a fin, un viaje en la que puede confiar',
		'your_safety' => 'Su seguridad es importante para nosotros, antes, durante y después de cada viaje. Es por eso que continuamos desarrollando tecnología que ayuda a hacer millones de paseos más seguros todos los días.',
		'keep_safe' => 'CÓMO mantenerse a salvo',
		'your_first' => 'Tu primero',
		'min_away' => 'está a unos minutos',
		'business_travel' => 'Los viajes de negocios',
		'trip_seperate' => 'Mantenga viajes de trabajo independiente',
		'trip_seperate_content' => 'Ya sea que le dirigen al aeropuerto, una reunión en la ciudad, o en la casa después de una noche en la oficina,',
		'hard_as' => 'trabaja tan duro como usted lo hace.',
		'pool' => 'PISCINA',
		'share_save' => 'Compartir su viaje y guardar',
		'pool_content' => 'POOL que coincide con los jinetes encabezados en la misma dirección. Siempre es la forma más barata',
		'ride_adds' => 'Y compartir el viaje añade sólo unos pocos minutos de su viaje.',
		'airport' => 'Aeropuertos',
		'shuttle' => 'Saltar el transporte al aeropuerto',
		'shuttle_content' => 'Solicitar un paseo bajo demanda en más de 400 aeropuertos en todo el mundo. Y con múltiples opciones de vehículos, hay un montón  de espacio para todo su equipaje.',
		'trip_safety' => 'de seguridad de disparo',
		'commitment_riders' => 'Nuestro compromiso con los pilotos',
		'people_safe' => 'se dedica a mantener a salvo en la carretera. Nuestra tecnología nos permite centrarse en la seguridad del piloto antes, durante y después de cada viaje. Así es cómo.',
		'getting_safe_ride' => 'Conseguir un viaje seguro',
		'safe_pickups' => 'pastillas seguras',
		'find_location' => 'aplicación busca automáticamente su ubicación para proporcionar un servicio de puerta a puerta. Eso significa que a mantenerse seguro y cómodo donde se encuentre hasta que llegue a su conductor.',
		'open_everyone' => 'Abierto a todos, en todas partes',
		'request_blindly' => 'Todas las solicitudes de paseo son ciegas coinciden con el conductor más cercano disponible. Así que no hay discriminación basada en la raza, el género, o de destino.',
		'driver_profile' => 'Perfiles de controladores',
		'driver_profile_content' => 'Cuando se está emparejado con un conductor, verá su nombre, número de placa, foto, y la calificación, de modo que sepa con quién está recogiendo antes de tiempo. E incluso después del viaje, usted es capaz de ponerse en contacto con su conductor si se deja algo atrás.',
		'destination' => 'Cómo llegar a su destino',
		'eta' => 'Compartir su ETA',
		'eta_content' => 'Una vez que el controlador que ha recogido, compartir su ETA con sus amigos y familiares para que puedan seguir su ruta y saber cuándo se puede esperar.',
		'follow_trip' => 'Siga su viaje en tiempo real, por lo que siempre sabe dónde está. Y si se utiliza',
		'follow_trip_content' => 'Piscina, usted sabrá exactamente quién está montando con usted.',
		'always_here' => 'Siempre aquí para lo que necesites',
		'anonymous_feedback' => 'comentarios anónimos',
		'anonymous_feedback_content' => 'Después de cada viaje, se puede calificar el conductor y proporcionar información anónima sobre su viaje. Revisamos todas las observaciones ya que nuestro objetivo es hacer de cada paseo una gran experiencia.',
		'support_head' => 'soporte 24/7',
		'support_head_content' => 'Nuestro equipo de soporte está siempre dispuesto a responder a cualquier pregunta que pueda tener acerca de su viaje y ayudarle a recuperar los objetos perdidos.',
		'rapid_response' => 'Respuesta rápida',
		'rapid_response_content' => 'Nuestros equipos de respuesta a incidentes especialmente entrenados están disponibles durante todo el día para manejar cualquier preocupación urgentes que se presenten.',
		'work_event' => '“Trabajo eventos altas horas de la noche, y con',
		'feel_safer' => 'Me siento más segura sabiendo que no tengo que ir a esperar afuera y esperamos que pueda parar un paseo “.',
		'feel_safer_name' => 'Bretaña,',
		'rider_from' => 'Piloto de Portland',
		'app_offline' => 'En la App y fuera de línea',
		'imporving_experience' => 'La mejora de las experiencias con la tecnología',
		'sub_phone_number' => 'números de teléfono sustitutos',
		'use_technology' => 'que utiliza la tecnología anonimiza números de teléfono para mantener la información de contacto confidencial. Así que cuando usted y su conductor necesita ponerse en contacto entre sí, su información personal se mantiene privada.',
		'assisting' => 'Ayudar a hacer cumplir la ley',
		'assisting_content' => 'En los casos en que la policía local nos provee de un proceso legal válido, les proporcionamos datos útiles para ayudar en sus investigaciones.',
		'rider_safety' => 'consejos de seguridad piloto',
		'how_keep_safe' => 'Cómo mantenerse a salvo',
		'how_keep_safe_content' => 'Se trabajó con la policía para crear esta guía sobre cómo conducir con seguridad con',
		'safe_while' => 'En él se explica lo que puede hacer para mantenerse a salvo mientras se conduce.',
		'safer_ride' => 'Obtener un viaje seguro con',
	],
	'user' => [
		'disabled' => 'Cuenta deshabilitada',
		'protect' => 'Para ayudar a proteger su información, que  inhabilitado temporalmente su cuenta. Por favor, envíenos un correo electrónico para continuar.',
		'email_us' => 'Envíenos un correo electrónico',
		'vehicle_info' => 'Ingrese la información de su vehículo',
		'vehicle_name' => 'Nombre del vehículo / por ejemplo: Toyoto Camry, Honda Accord ...',
		'vehicle_number' => 'Número de vehículo / por ejemplo: fiebre del Nilo Occidental 382',
		'vehicle_type' => 'Elija su tipo de vehículo',
		'continue' => 'Continuar',
		'forgot_paswrd' => 'Se te olvidó tu contraseña',
		'next' => 'Siguiente',
		'no_account' => 'Don  tiene una cuenta?',
		'reset_paswrd' => 'Por favor, cambie su contraseña,',
		'continue_with' => 'Continuar con Facebook',
		'need_partner' => 'las necesidades de los socios como usted.',
		'need_partner_content' => 'y ganar mucho dinero como contratista independiente. Obtener semanal que se paga sólo para ayudar a nuestra comunidad de pilotos consiguen paseos alrededor de la ciudad. Sea su propio jefe y se les paga en las tarifas por conducir en su propio horario.',
		'correct' => 'Por favor, corrija la siguiente:',
		'create_account' => 'Crea una cuenta nueva',
		'proceed' => 'Al continuar, acepto que',
		'contact' => 'o sus representantes pueden ponerse en contacto conmigo por correo electrónico, teléfono o SMS (incluyendo por medios automatizados) en la dirección de correo electrónico o número proporciono, incluso para fines de marketing.',
		'money_make' => 'Hacer un buen dinero.',
		'money_make_content' => '¿Tengo un coche? Convertirlo en una máquina de hacer dinero. La ciudad es un hervidero y  nombre_del_sitio hace que sea fácil para que usted pueda sacar provecho de la acción. Además, usted  ya tiene todo lo que necesita para empezar.',
		'drive_when_want' => 'Conducir cuando lo desee.',
		'drive_when_want_content' => '¿Necesita algo fuera de la 9 a 5? Como contratista independiente con',
		'imp_moments' => 'usted tiene la libertad y flexibilidad para conducir cada vez que tenga tiempo. Fijar su propio horario, por lo que puede estar allí para todos los momentos más importantes de la vida.',
		'no_office' => 'Sin cargo, sin jefe.',
		'no_office_content' => 'Ya sea que esté apoyando a su familia o ahorrar para algo grande,',
		'freedom' => 'le da la libertad de ponerse al volante cuando tiene sentido para usted. Elija cuando se conduce, a donde vaya, y que usted toma.',
		'safe_reliable' => 'paseos, seguro y fiable en cuestión de minutos',
		'promo' => 'Código promocional',
		'clicking_terms' => 'Al hacer clic en "Registrarse", acuerda',
		'terms' => ' Términos y Condiciones',
		'and' => 'y',
		'privacy' => 'Política de privacidad',
		'submit' => 'ENVIAR',
		'firstname' => 'Nombre de pila',
		'lastname' => 'Apellido',
		'email' => 'Email',
		'paswrd' => 'Contraseña',
		'drive_with_Ridein' => 'Con conducir',
		'ride_with' => 'Viajar con',
		'update' => 'actualizar',
		'email_address' => 'Correo electrónico o número de teléfono móvil',
		'mobile_no' => 'El usuario ha sido desactivado',
		'disabled_account' => 'Este número móvil puede  ser reconocido por',
		'disabled_company_account' => 'La compañía ha sido desactivado',
		'no_recognize' => 'La contraseña que ha introducido no es correcto.',
		'no_recognize_email' => 'Este correo electrónico no puede ser reconocido por :site',
		'no_paswrd' => 'Hemos enviado un enlace para restablecer la contraseña para',
		'link' => 'número de teléfono móvil ya existe',
		'mobile_no_exists' => 'el Email ya existe',
		'email_exists' => 'Registrado correctamente',
		'register_successfully' => 'Registrado correctamente',
		'login_failed' => 'Error de inicio de sesion. Consulta tu correo electrónico / contraseña.',
		'google_login_failed' => 'Error de inicio de sesion.',
		'country_code' => 'Error de inicio de sesion.',
		'user_type' => 'Tipo de usuario',
		'veh_name' => 'Número de vehículo',
		'veh_no' => 'Nombre de vehículos',
		'veh_type' => 'tipo de vehiculo',
		'token' => 'Token ha caducado.',
		'invalid_token' => 'NSimbolo no valido.',
		'new_paswrd' => 'ueva contraseña',
		'cnfrm_paswrd' => 'Confirmar contraseña',
		'pswrd_chnge' => 'La contraseña ha cambiado correctamente.',
		'profile_image' => 'Imagen de perfil',
		'license_image' => 'No se pudo cargar Licencia de la imagen',
		'update_success' => 'actualizado correctamente',
		'update_fail' => 'No se pudo cargar Imagen del perfil',
		'invalid_file_type' => 'Tipo de archivo invalido. Sólo se aceptan tipos JPG, GIF y PNG.',
		'insurance_image' => 'No se pudo cargar imagen Seguro',
		'rc_image' => 'No se pudo cargar Rc libro Imagen',
		'permit_image' => 'No se pudo cargar Permiso Imagen',
		'add_success' => 'Agregado exitosamente',
		'rc_book' => 'rc libro',
		'insurance' => 'Seguro',
		'permit' => 'Permiso',
		'begin_trip' => 'Comience de viaje',
		'end_trip' => 'fin de viaje',
		'email_mobile' => 'Ingrese su correo electrónico o número de teléfono móvil',
		'service_not_available_country' => 'El servicio no está disponible para el país seleccionado',
		'active_message' => 'Tu perfil ha sido activado',
		'pending_message' => 'Espere hasta obtener la aprobación del administrador para los detalles del auto o documento',
		'car_details_message1' => 'Sube los detalles de tu vehículo',
		'car_details_message2' => 'Cargue los detalles del documento de su vehículo',
		'document_details_message' => 'Cargue los detalles de su documento de controlador',
		'inactive_message' => 'Tu perfil ha sido desactivado',
		'default_vehicle_delete_msg' => 'El vehículo predeterminado no se puede eliminar',
		'delete_success' => 'Borrado exitosamente',
		'vehicle_not_activated' => 'El vehículo aún no se activó',
		'default_vehicle_trip_error' => 'El vehículo predeterminado ya está en viaje, por lo que no puede configurar este vehículo como predeterminado',
	],

	'account' => [
		'bank_detail' => 'Detalles del banco',
		'bank_name' => 'Nombre del banco',
		'bank_location' => 'localización del Banco',
		'bank_code' => 'Código BIC / SWIFT',
		'payout_methods'           => 'Métodos de pago',
		'add_payout_method'        => 'Añadir Método de Pago',
		'payout_methods_desc'      => 'Cuando recibe un pago para una reserva, lo llamamos el pago en un "pago". Nuestro sistema de pago seguro admite varios métodos de pago, que pueden ser de configuración y editado aquí. Sus opciones de pago disponibles y monedas difieren según el país.',
		'method'                   => 'Método',
		'default'                  => 'Defecto',
		'ready'                    => 'Listo',
		'remove'                   => 'retirar',
		'set_default'              => 'Establecer predeterminado',
		'add_payout_method'        => 'Añadir Método de Pago',
		'direct_deposit'           => 'Deposito directo',
		'email_id'                 => 'Identificación de correo',
		'payout_released_desc1'    => 'Los pagos por viajes se entregan a usted una vez que se completa el viaje, y se demora un tiempo adicional para que el dinero llegue, según su método de pago.',
		'payout_released_desc2'    => 'Podemos enviar dinero a la gente',
		'payout_released_desc3'    => 'con estos métodos de pago. ¿Cual prefieres?',
		'payout_method'            => 'método de pago',
		'processing_time'          => 'Tiempo de procesamiento',
		'additional_fees'          => 'cargos adicionales',
		'currency'                 => 'Moneda',
		'business_days'            => 'días hábiles',
		'none'                     => 'Ninguna',
		'business_day_processing'  => 'procesamiento día hábil solamente; fines de semana y días festivos bancarios pueden causar retrasos',
		'address'                  => 'Dirección',
		'zone'                     => 'Zona',
		'city'                     => 'Ciudad',
		'state'                    => 'Estado',
		'province'                 => 'Provincia',
		'postal_code'              => 'código postal',
		'country'                  => 'País',
		'submit'                   => 'Enviar',
		'next'                     => 'Siguiente',
		'completed_transactions'   => 'Las transacciones completadas',
		'future_transactions'      => 'Las transacciones futuras',
		'future_payout'            => 'Pago futuro',
		'paid_out'                 => 'Pagado',
		'refund'                   => 'Reembolso',
		'all_payout_methods'       => 'Todos los métodos de pago',
		'export_to_csv'            => 'Exportar a CSV',
		'all_listings'             => 'Todas las listas',
		'date'                     => 'Fecha',
		'type'                     => 'Tipo',
		'amount'                   => 'Cantidad',
		'payout'                   => 'Pago',
		'transfer_to'              => 'Transferir a',
		'pay_to'                   => 'Pagar a',
		'change_your_pwd'          => 'Cambia tu contraseña',
		'old_pwd'                  => 'Contraseña anterior',
		'update_pwd'               => 'Actualiza contraseña',
		'payout_updated'           => 'Método de pago se ha actualizado correctamente.',
		'bank_detail_updated' => 'Los datos bancarios se han actualizado con éxito.',
		'payout_default'           => 'De pago de preferencia en el estado por defecto.',
		'payout_deleted'           => 'Método de Pago seleccionada ha eliminado correctamente.',
		'payout_already_defaulted' => 'Ya en pago de preferencia de estado por defecto.',
		'payout_defaulted'         => 'Método de Pago seleccionada ha establecido con éxito en Incumplimiento.',
		'blank_address'            => 'La dirección no puede estar en blanco.',
		'blank_city'               => 'Ciudad no puede estar en blanco.',
		'blank_post'               => 'Código postal no puede estar en blanco.',
		'blank_country'            => 'País no puede estar en blanco.',
		'choose_method'            => 'Elija el método de cobro.',
		'valid_email'              => 'Introduzca la ID de correo electrónico válida.',
		'loading'                  => 'Cargando',
		'no_transactions'          => 'No hay Transacciones',
		'details' 				   => 'Detalles',
		'options' 				   => 'Opciones',
		'document_id' => 'ID del documento',
		'vehicle_id' => 'ID del vehículo',
		'expired_date' => 'Fecha de vencimiento',
		'document_image' => 'Imagen de documento',
		'invalid_id' => 'identificación invalida',
		'license_no' => 'Número de vehículo',
		'vehicle_type' => 'tipo de vehiculo',
		'make_id' => 'Hacer Id',
		'model_id' => 'Id del modelo',
		'year' => 'Año',
	],
	'email' => [
		'your' => 'la información de pago se ha actualizado',
		'payout_information_updated' => 'información de pagos ha sido borrado',
		'payout_information_deleted' => 'Su información de pagos por defecto se ha cambiado',
		'payout_information_changed' => 'Su información de pagos por defecto se ha cambiado',
		'payout_update' 			 => 'Tu: información de pagos :site_name fue actualizado el :updated_date',
		'payment_information_del' 	 => 'Tu información de pagos :site_name ha sido borrado',
		'hope_messgae_friends' 		 => 'Esperamos que este mensaje te encuentre bien. Tu: información de la cuenta de pago :site_name ha cambiado recientemente en :updated_date Para ayudar a mantener su cuenta segura, queríamos llegar a confirmar que ha realizado este cambio. No dude en hacer caso omiso de este mensaje si ha actualizado su información de cuenta de pago en :updated_date',
		'change_your_account' 		 => 'Si no realiza este cambio a su cuenta, por favor, póngase en contacto con nosotros.',
	],

	//web Service
	'credentials' => 'Esas credenciales dont se ven bien. Inténtalo de nuevo',
	'login_success' => 'Inicio de sesión exitoso',
	'inactive_admin' => 'Su cuenta Deactivated..Please contacto administrativo',
	'offline' => 'Desconectado',
	'update_success' => 'actualizado correctamente',
	'complete_your_trips' => 'Por favor, complete su visita',
	'facebook_https_error' => 'Facebook Registrarse / Entrar funcionará sólo en los sitios de producción.',
	'invalid_credentials' => 'Credenciales no válidas',
	'message_send_failed' => 'El envío de mensajes por favor, inténtalo de nuevo ..',
	'otp_sent_success' => 'Otp enviado con éxito',
	'already_have_account' => 'Ya tiene una cuenta, por favor entre ...',
	'promo_already_applied' => 'código promocional ya se aplicó',
	'promo_applied_success' => 'Promo aplicado con éxito',
	'promo_expired' => 'código promocional ha caducado',
	'promo_invalid' => 'código promocional no es válido',
	'amount_added_success' => 'Monto agregado con éxito',
	'code_required' => 'Se requiere que el campo de código',
	'active' => 'Activo',
	'pending' => 'Pendiente',
	'complete_trips' => 'Por favor, complete su visita',
	'cancel_reason_required' => 'Se requiere cancelar campo Razón',
	'mobile_number_exist' => 'Número Móvil existe',
	'enter_registered_number' => 'Por favor, introduzca el número de móvil registrado',
	'first_name_required' => 'Se requiere el campo Nombre',
	'last_name_required' => 'Se requiere campo Apellido',
	'mobile_num_required' => 'Se requiere campo Número Móvil',
	'country_code_required' => 'Se requiere campo Código de país',
	'email_id_required' => 'Se requiere campo email Id',
	'profile_image_required' => 'Se requiere el campo de imagen de perfil',
	'address_line1_required' => 'línea de dirección se requiere 1 Campo',
	'address_line2_required' => 'línea de dirección se requiere 2 terreno',
	'city_required' => 'Se requiere campo Ciudad',
	'state_required' => 'Se requiere campo Nombre de Estado',
	'postal_code_required' => 'Se requiere campo Código Postal',
	'service_not_available' => 'Servicio no disponible en lugar determinado',
	'cars_found' => 'coches encontrado',
	'no_cars_found' => 'No se han encontrado coches',
	'success' => 'Éxito',
	'field_is_required' => 'Se requiere campo',
	'please_complete_your_current_trip' => 'Por favor completa tu viaje actual',
	'base_fare' => 'Tarifa base',
	'access_fee' => 'Tarifa de acceso',
	'total_fare' => 'Tarifa total',
	'total_time_fare' => 'Tarifa de tiempo total',
	'wallet_amount' => 'Monto de la cartera',
	'driver_payout' => 'Pago del conductor',
	'applied_owe_amount' => 'Cantidad debida aplicada',
	'owe_amount' => 'adeuda cantidad',
	'cash_collected' => 'Efectivo cobrado',
	'distance_fare' => 'Tarifa de distancia',
	'schedule_fare' => 'Tarifa de horario',
	'promo_amount' => 'Cantidad Promo',
	'total_km_fare' => 'Tarifa total en km',
	'time_fare' => 'Tarifa de tiempo total',
	'total_trip_fare' => 'Tarifa total del viaje',
	'payable_amount' => 'Pagar la cantidad',
	'peak_fare' => 'Fare pico',
	'number_does_not_exists' => 'Número no existe',
	'peak_time_fare' => 'precios en tiempo pico',
	'normal_fare' => 'tarifa normal',
	'tips' => 'Consejos',
	'toll_fee' => 'Peaje',
	'subtotal_fare' => 'Sub total',
	'peak_subtotal_fare' => 'Sub total',
	'location_unavailable' => 'Localización disponible',
	'location_country' => 'Sin servicio',
	'trip_cash_collected' => 'Conductor recoge dinero en efectivo para el viaje.',
	'request_accepted' => 'Conductor aceptó su solicitud de viaje y conductor está en el camino.',
	'driver_arrive' => 'El conductor acaba de llegar a su ubicación.',
	'trip_begined' => 'Su viaje desde la ubicación de recogida a la ubicación de entrega se inició correctamente.',
	'trip_ended' => 'Su viaje desde la ubicación de recogida a la ubicación de entrega finaliza correctamente.',
	'sms_payment_detail' => 'Su viaje se ha completado.',
	'cash_collected_payment_detail' => 'tarifa total es: total_fare. tarifa básica es: base_fare. El tiempo es la tarifa: time_fare. Distancia tarifa es: distance_fare.',
	'trip_booked_driver_message' => 'Viaje programado para usted en: date',
	'trip_booked_driver_remainder' => 'Viaje programado para recordarle que: date.',
	'trip_booked_rider_remainder' => 'Viaje programado para recordarle que: date.',
	'trip_booked_user_message' => 'Viaje reservado con éxito en: date.',
	'trip_booked_driver_detail' => 'El nombre del controlador es: FIRST_NAME apellido y número de teléfono es: PHONE_NUMBER.',
	'peak_fare_detail' => 'la tarifa máxima es: peak_fare.',
	'schedule_fare_detail' => 'tarifa horario es: schedule_fare.',
	'service_fare_detail' => 'la tarifa del servicio es: service_fare.',
	'trip_booked_user_remainder' => 'Viaje reservado con éxito en :date.',
	'trip_booked_vehicle_detail' => 'nombre del vehículo es: name y el número es :number.',
	'trip_booked_user_remainder' => 'Su viaje comenzará en: date.',
	'service_fee' 				 => 'Tarifa de servicio',
	'waiting_charge'			 => 'Cargo en espera',
	'just_now'				  	 => 'Justo ahora',
	'ago'				  	 	 => 'hace',
	'payment_complete_success'   => 'Pago completado con éxito',
	'wallet_add_success'         => 'Cantidad de billetera agregada correctamente',


	'signup' => [
		'car_document' 		=> 'Documento de coches',
		'photo' 			=> 'Foto',
		'national_id' 		=> 'Identificación nacional',
		'license_front' 	=> 'Frente licencia',
		'license_back' 		=> 'Licencia Volver',
	],

	'required' => [
		'cancel_reason' 	=> 'Cancelar Razón',
		'cancel_reason_id' 	=> 'Cancelar Id Razón',
		'user_type' 		=> 'Tipo de usuario',
		'trip_id' 			=> 'Id viaje',
	],

	'referrals' => [
		'referral_code' 				=> 'código de referencia',
		'enter_valid_referral_code'     => 'Found entrado el código de referencia no',
		'referral'						=> 'Remisión',
		'referral_header'				=> 'Registro y recibir el pago: cantidad por cada referencia Regístrese!',
		'referral_not_available'		=> 'Actualmente Referidos no disponible.',
		'previous_referrals' 			=> 'sus referencias',
		'referral_credited' 			=> 'Remisión acreditada',
		'referral_credited_desc'		=> 'Monto de referencia acreditado a su billetera',
		'rider_name'					=> 'Nombre del jinete',
		'driver_name'					=> 'Nombre del conductor',
		'total_trips'					=> 'Viajes totales',
		'trips_remaining'				=> 'Viajes restantes',
		'total_days'					=> 'Días totales',
		'days_remaining'				=> 'Días restantes',
		'earnable_amount'				=> 'Cantidad acumulable',
		'status'						=> 'Estado',
		'Pending'						=> 'Pendiente',
		'Expired'						=> 'Caducada',
		'Completed'						=> 'Terminada',
	],

	'date_time' => [
		'year' 			=> 'año',
		'month' 		=> 'mes',
		'week' 			=> 'semana',
		'day' 			=> 'día',
		'hour' 			=> 'hora',
		'minute' 		=> 'minuto',
		'second' 		=> 'segundo',
	],

	'api' => [
		'payout_successfully'	=> 'pago con éxito',
		'positive_integer' 		=> 'número entero positivo no válido',
		'owe_amount_empty'		=> 'Adeudar cantidad vacía',
		'referral_amount_empty'	=> 'cantidad de referencia Vacío',
		'not_generate_amount'	=> 'No adeudar cantidad generar',
		'saved_cards' 			=> 'Tarjetas guardadas',
		'pay'					=> 'pagar',
		'invalid'				=> 'Valor no válido',
		'reason_inactive_admin'	=> 'Esta razón eliminado, elija otra.',
		'trip_already_completed' => 'Viaje ya completadas.',
		'listed_successfully'	=> 'Listado con éxito',
		'updated_successfully'	=> 'actualizado correctamente',
		'invalid_credentials' 	=> 'Credenciales no válidas',
		'something_went_wrong' 	=> 'Algo salió mal',
		'document_required' 	=> 'Documento requerido',
		'payout_details_added' 	=> 'Detalles de pago se agrega correctamente',
		'no_data_found'			=> 'Datos no encontrados',
		'email_already_exists' 	=> 'el Email ya existe',
		'toll_reason'			=> 'Razón de peaje',
		'success'				=> 'Éxito',
		'trip_booked'			=> 'Viaje reservado manualmente',
		'manual_booking_update'	=> 'Reservas Manual',
		'trip_fare_details'		=> 'viaje de ida',
		'waiting_charge_apply_after' => ':amount / min Tasa de espera se aplica después Min :minutes de llegada hasta las salidas de disparo.',
		'trip_total_fare'		=> 'tarifa total es :total_fare.',
		'driver_confirmed' => 'Conductor Confirmado',
		'trip_confimred' => 'Su viaje ha sido confirmado. Pronto recibirá los detalles del conductor.',
		'no_trips_found'		=> 'Ningún viaje encontrados',
		'your_otp_to_begin_trip' => 'Su contraseña de una sola vez para iniciar viaje es',
		'please_add_card_details' => 'Por favor, añadir datos de la tarjeta primero',
		'created_successfully'	=> 'Creado con éxito',
		'payment_not_completed' => 'El pago que no hayan concluido',
		'driver_earnings'		=> 'Las ganancias del controlador',
		'trip_earning'			=> 'Ganancia de viaje',
		'total_fare'			=> 'Tarifa total',
		'total_fare_tooltip'	=> 'Tarifa incluye tarifa de tiempo, distancia y tarifas, etc.,',
		'admin_remaining_amount' => 'Monto Pendiente de administración',
		'schedule_ride_updated'	=> 'Programe el viaje actualizado con éxito',
		'schedule_ride_created' => 'Programar viaje enviado con éxito',
		'your_otp_is'			=> 'Su número de OTP es ',
		'authentication_failed' => 'Error de autenticación',
		'schedule_cancelled' 	=> 'horario Cancelado',
		'schedule_remainder' 	=> 'El resto tropezar programada',
		'trip_begin_by_driver' 	=> 'Viaje se inició por el conductor',
		'trip_cancelled_by_driver' 	=> 'Viaje cancelado por el controlador',
		'request_accepted' 		=> 'Petición aceptada',
		'driver_arrived' 		=> 'conductor llegó',
		'trip_ended_by_driver'	=> 'Viaje terminó por controlador',
		'trip_request'			=> 'Solicitud de viaje',
		'trip_scheduled'		=> 'viaje programado',
		'invalid_request'		=> 'Solicitud no válida',
		'bank_transfer'			=> 'Transferencia bancaria',
		'paypal'				=> 'PayPal',
		'stripe'				=> 'Stripe',
		'change_debit_card'		=> 'Cambiar tarjeta de débito / tarjeta de crédito',
		'add_debit_card'		=> 'Agregar tarjeta de débito / tarjeta de crédito',
		'Cash'					=> 'Efectivo',
		'PayPal'				=> 'PayPal',
		'Card Payment'			=> 'Pago con tarjeta',
	],
];
