<?php 
/**
 * Paypal Razorpay Service
 *
 * @package     Ridein
 * @subpackage  Services\Payments
 * @category    Razorpay
 * @author      Sourcemonster Team
 * @version     2.2.1
 * @link        https://sourcemonster.in
*/



namespace App\Services\Payments;

use App\Services\PaymentMethods\FlutterwavePayment as FlutterwaveGateway;
use App\Contracts\PaymentInterface;

class FlutterwavePayment  extends FlutterwaveGateway implements PaymentInterface 
{

    public function view($user)
	{

        $payment_data = session()->get('payment_data');
        $data['response'] =  $this->makePayment($payment_data,request()->pay_key);
        return array('view' => 'payment.flutterwave','data' => $data);
    }


    public function Payment($paymentData,$authCode)
    {   
        $responce = $this->makePayment($paymentData,$authCode);
        return $this->returnResponce($responce);

    }

    public function Verify($request){
        $requestData = arrayToObject([
            'payment_type' => $request->query('payment_type'),
            'status' => $request->query('status'),
            'tx_ref' => $request->query('tx_ref'),
            'transaction_id' => $request->query('transaction_id'),
            ]);
           
        $responce = $this->payment_verify($requestData);
        return $this->returnResponce($responce);
    }

    
    public function returnResponce($responce)
    {
      $responce->status_code =  $responce->status ? "1":"0";
      return $responce;
    }

}